/*
 * Decompiled with CFR 0.152.
 */
package pm;

import gnu.getopt.Getopt;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import pm.gui.PM_WindowDialog_deprecated;
import pm.gui.PM_WindowImport;
import pm.gui.PM_WindowMain;
import pm.inout.PM_All_ExternalPrograms;
import pm.inout.PM_All_InitValues;
import pm.inout.PM_LogFile;
import pm.inout.PM_SequencesInout;
import pm.inout.PM_XML_File_Session;
import pm.picture.PM_ImportInternal;
import pm.picture.PM_MetadataContainer;
import pm.search.PM_DatabaseLucene;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Demon;
import pm.utilities.PM_Interface;
import pm.utilities.PM_ListenerX;
import pm.utilities.PM_MSG;
import pm.utilities.PM_Utils;

public class PM_Start
implements PM_Interface,
Runnable {
    private static final int PORT = 37683;
    private ServerSocket server;
    private static PM_Start pmStart;
    private static PM_Configuration properties;

    public static void firstMain(String[] stringArray) {
        PM_MSG.setResourceBundle(new Locale("en"));
        String string = "PM-Version = " + PM_Utils.getPmVersion() + "/" + PM_Utils.getDateCompiled();
        System.out.println(string);
        System.out.print("firstMain: args = ");
        for (String object2 : stringArray) {
            System.out.print(" " + object2);
        }
        System.out.println();
        properties = PM_Configuration.init(stringArray);
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (Exception exception) {
            System.out.println("set Look and Feel: ERROR: " + exception);
        }
        PM_LogFile.getInstance().start();
        System.out.println("Start PM");
        System.out.print("Operating System = ");
        if (PM_Utils.isLinux()) {
            System.out.println("Linux");
        } else {
            System.out.println(PM_Utils.getPropertyString(System.getProperties(), "os.name"));
        }
        PM_All_ExternalPrograms.getInstance().init();
        PM_All_InitValues.getInstance().init();
        Object object3 = null;
        PM_ListenerX pM_ListenerX = null;
        if (!properties.getBatch()) {
            object3 = PM_WindowDialog_deprecated.getInstance().startProgram();
            pM_ListenerX = ((PM_WindowDialog_deprecated)object3).getListener();
        }
        PM_XML_File_Session.getInstance().open();
        PM_SequencesInout.getInstance().open();
        PM_DatabaseLucene.getInstance().open();
        PM_MetadataContainer.getInstance().initialize(pM_ListenerX);
        PM_DatabaseLucene.getInstance().flush();
        if (PM_DatabaseLucene.getInstance().getNeuErzeugen() || PM_XML_File_Session.getInstance().indexFilesGeaendert()) {
            PM_DatabaseLucene.getInstance().alleLuceneEintraegeNeuErstellen(pM_ListenerX);
        }
        if (object3 != null) {
            ((PM_WindowDialog_deprecated)object3).stop();
        }
        if (properties.getBatch()) {
            System.out.println("----> BATCH");
            if (properties.getDaemon()) {
                new PM_Demon();
            }
            PM_MetadataContainer.getInstance().close();
            PM_DatabaseLucene.getInstance().close();
            PM_SequencesInout.getInstance().close();
            PM_All_ExternalPrograms.getInstance().close();
            PM_XML_File_Session.getInstance().close();
            properties.close();
            System.out.println("PM normal end (batch)");
            System.exit(0);
        }
        PM_WindowDialog_deprecated pM_WindowDialog_deprecated = PM_WindowDialog_deprecated.getInstance().startProgram();
        PM_ListenerX pM_ListenerX2 = pM_WindowDialog_deprecated.getListener();
        PM_WindowMain pM_WindowMain = new PM_WindowMain();
        pM_WindowMain.init(pM_ListenerX2);
        pM_WindowMain.setVisible(true);
        if (pM_WindowDialog_deprecated != null) {
            pM_WindowDialog_deprecated.stop();
        }
        List<File> list = PM_Configuration.getInstance().getImportFiles();
        PM_WindowImport.addImportFiles(list);
        if (!list.isEmpty()) {
            pM_WindowMain.getWindowRechts().doStartExternalImport();
        } else {
            List<File> list2 = PM_MetadataContainer.getInstance().getPicturesWithoutThumbs(null);
            if (list2.size() > 0) {
                PM_ImportInternal pM_ImportInternal = new PM_ImportInternal();
                pM_ImportInternal.checkAndImport();
            }
        }
        new PM_Demon();
    }

    public static void main(String[] stringArray) {
        pmStart = new PM_Start();
        pmStart.launch(stringArray);
    }

    public void launch(String[] stringArray) {
        try {
            this.server = new ServerSocket(37683);
            new Thread(this).start();
            PM_Start.firstMain(stringArray);
        }
        catch (IOException iOException) {
            this.relaunch(stringArray);
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    int n;
                    Socket socket = this.server.accept();
                    InputStreamReader inputStreamReader = new InputStreamReader(socket.getInputStream());
                    StringBuffer stringBuffer = new StringBuffer();
                    char[] cArray = new char[256];
                    while ((n = inputStreamReader.read(cArray)) >= 0) {
                        stringBuffer.append(cArray, 0, n);
                    }
                    String[] stringArray = stringBuffer.toString().split("\\n");
                    this.otherMain(stringArray);
                }
            }
            catch (IOException iOException) {
                System.out.println("ex: " + iOException);
                iOException.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void relaunch(String[] stringArray) {
        try {
            Socket socket = new Socket("localhost", 37683);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(socket.getOutputStream());
            for (int i = 0; i < stringArray.length; ++i) {
                outputStreamWriter.write(stringArray[i] + "\n");
            }
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (Exception exception) {
            System.out.println("ex: " + exception);
            exception.printStackTrace();
        }
        System.exit(0);
    }

    public void otherMain(final String[] stringArray) {
        System.out.print("otherMain: args = ");
        for (String string : stringArray) {
            System.out.print(" " + string);
        }
        System.out.println();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n;
                ArrayList<File> arrayList = new ArrayList<File>();
                Getopt getopt = new Getopt("testprog", stringArray, "e:b:i:");
                while ((n = getopt.getopt()) != -1) {
                    if (n != 105) continue;
                    String string = getopt.getOptarg();
                    if (string == null) break;
                    arrayList.add(new File(string));
                    break;
                }
                for (int i = getopt.getOptind(); i < stringArray.length; ++i) {
                    arrayList.add(new File(stringArray[i]));
                }
                if (arrayList.isEmpty()) {
                    JOptionPane.showConfirmDialog(null, "PM is yet running.", "Error", -1, 1);
                    return;
                }
                if (PM_WindowImport.addImportFiles(arrayList)) {
                    PM_WindowImport.setTimer();
                    String string = "Ein EXTERNER Bilder-Import wurde erkannt.\nWechseln Sie ins Fenster \"Import\" und\nbet\u00e4tigen Sie dort den Button \"Extern importieren\"";
                    JOptionPane.showConfirmDialog(null, string, "Import extern", -1, 1);
                }
            }
        });
    }
}

