/* supply Wacom Bamboo finger events to xsmouse.sys */
rc=RxFuncAdd('SysGetMessage','RexxUtil','SysGetMessage')
rc=RxFuncAdd('SysSleep','RexxUtil','SysSleep')

/* set input file name */
ddNameI='ofinger.log'

/* set log file name */
ddNameR='sfinger.log'

/* report sfinger.cmd started */
info='<============<sfinger.cmd> started on <'||date()||'> at <'||time()'>============>'
rc=lineout(ddNameR,info) ; say info

/* set device driver name */
ddNameO='XSMOUSE$'

/* verify that the emulate mouse driver exists in config.sys */
if stream(ddNameO,'command','query exists') \= '\DEV\' || ddNameO
then do
  info='DEVICE=?:\OS2\BOOT\XSMOUSE.SYS required in CONFIG.SYS'
  rc=lineout(ddNameR,info) ; say info
  /* wait */
  '@pause'
  exit
  end

/* acquire the emulate mouse driver */
rc=stream(ddNameO,'command','open')
if rc \= 'READY:'
then do
  info=rc||' Device driver '||ddNameO||' currently in use. Please try later.'
  rc=lineout(ddNameR,info) ; say info
  /* wait */
  '@pause'
  exit
  end

/* set digitizer size */
xdmm=125.00 ; /* millimeter */
ydmm=085.00 ; /* millimeter */

/* set finger fixed extends */
xMaxFinger=480 ; yMaxFinger=320

/* set finger margins */
xMinFinger=trunc(xMaxFinger/10)
xMaxFinger=xMaxFinger-xMinFinger
yMinFinger=trunc(yMaxFinger/10)
yMaxFinger=yMaxFinger-yMinFinger

/* report finger extends */
extends='xSize='||xdmm||' mm. xMinFinger='||xMinFinger||' points. xMaxFinger='||xMaxFinger||' points.'
rc=lineout(ddNameR,extends) ; say extends
extends='ySize='||ydmm||' mm. yMinFinger='||yMinFinger||' points. yMaxFinger='||yMaxFinger||' points.'
rc=lineout(ddNameR,extends) ; say extends

/* initialize mouse events */
But1Down=x2c(0600) ; But2Down=x2c(1800)
But3Down=x2c(6000) ; ButsDown=x2c(1E00)
MoveOnly=x2c(0100) ; NoButMov=x2c(0000)

/* set screen fixed extends */
xMaxScreen=1280 ; yMaxScreen=800

/* move cursor to center */
xMin=0 ; xMax=xMaxScreen ; xPos=trunc(xMax/2)
yMin=0 ; yMax=yMaxScreen ; yPos=trunc(yMax/2)
xMaxOut=reverse(d2c(xMaxScreen,2))
yMaxOut=reverse(d2c(yMaxScreen,2))
call xsMouse(MoveOnly)
LastEvent=MoveOnly

/* catch these here to release the mouse */
signal on error; signal on failure; signal on halt;
signal on novalue; signal on syntax;

do while lines(ddNameI)
  oiBuffer=x2c(linein(ddNameI))
  event=substr(oiBuffer,9,2)
  select
    when event=x2c(0200) then call Finger(NoButMov)
    when event=x2c(0201) then call Finger(But1Down)
    when event=x2c(0202) then call Finger(But2Down)
    when event=x2c(0204) then call Finger(But3Down)
    when event=x2c(0208) then call Finger(ButsDown)
    otherwise call Unknown
    end
  call SysSleep(0.020)
  end

/* cleanup */
signal ProcessComplete
exit

ReleaseButtons:
/* release only once */
if LastEvent==NoButMov then return
call xsMouse(NoButMov)
LastEvent=NoButMov
return

Finger:
parse arg type
/* use pointer input */
if bitand(substr(oiBuffer,16,1),'80'x)=='80'x
then do
  /* finger position */
  xPos=c2d(substr(oiBuffer,16,2))-32768
  yPos=c2d(substr(oiBuffer,18,2))
  /* finger calibration */
  if xPos<xMinFinger then xMinFinger=xPos
  if xPos>xMaxFinger then xMaxFinger=xPos
  if yPos<yMinFinger then yMinFinger=yPos
  if yPos>yMaxFinger then yMaxFinger=yPos
  /* use finger extends */
  xMin=xMinFinger ; xMax=xMaxFinger
  yMin=yMinFinger ; yMax=yMaxFinger
  end
/* use finger pointer */
call xsMouse(type)
LastEvent=type
return

Unknown:
/* show packet */
packet=c2x(substr(oiBuffer,9))
output='Packet='||packet||',Huh?'
rc=lineout(ddNameR,output)
say output
return

xsMouse:
parse arg EvntFlgs
/* calculate current screen position */
xCur=trunc(((xPos-xMin)*xMaxScreen)/(xMax-xMin))
yCur=trunc(((yPos-yMin)*yMaxScreen)/(yMax-yMin))

/* prepare event buffer */
xPosOut=reverse(d2c(xCur,2))
yPosOut=reverse(d2c(yCur,2))
oBuffer = EvntFlgs||yPosOut||xPosOut||yMaxOut||xMaxOut

/* write this event */
rc=charout(ddNameO,oBuffer)
rc=stream(ddNameO,'description')
/* check completion code */
if rc \= 'READY:'
then do
  say
  /* obtain and issue error message */
  parse value rc with sState ':' mNumber
  say SysGetMessage(mNumber,,ddNameO)
  /* wait */
  '@pause'
  exit
  end
return

/* report signal information */
error: failure: halt: novalue: syntax:
parse source system invokation filename
info=condition('c')||' condition raised at line '||sigl||' of'||'0D0A'x
info=info||filename||'0D0A'x||'|'||sourceline(sigl)
rc=lineout(ddNameR,info) ; say info

ProcessComplete:
/* report finger extends */
extends='xSize='||xdmm||' mm. xMinFinger='||xMinFinger||' points. xMaxFinger='||xMaxFinger||' points.'
rc=lineout(ddNameR,extends) ; say extends
extends='ySize='||ydmm||' mm. yMinFinger='||yMinFinger||' points. yMaxFinger='||yMaxFinger||' points.'
rc=lineout(ddNameR,extends) ; say extends

/* release the emulate mouse driver */
rc=stream(ddNameO,'command','close')

/* report sfinger.cmd stopped */
info='<============<sfinger.cmd> stopped on <'||date()||'> at <'||time()'>============>'
rc=lineout(ddNameR,info) ; say info
exit
