/* Wacom Bamboo finger events to xsmouse.sys */
rc=RxFuncAdd('SysGetMessage','RexxUtil','SysGetMessage')
rc=RxFuncAdd('SysSleep','RexxUtil','SysSleep')

/* set log file name */
ddNameR='afinger.log'

/* report afinger.cmd started */
info='<============<afinger.cmd> started on <'||date()||'> at <'||time()'>============>'
rc=lineout(ddNameR,info) ; say info

/* set device driver names */
ddNameI='$BAMBOO$' ; ddNameO='XSMOUSE$'

/* verify that the direct control driver exists in config.sys */
if stream(ddNameI,'command','query exists') \= '\DEV\' || ddNameI
then do
  info='DEVICE=?:\OS2\BOOT\USBECD.SYS required in CONFIG.SYS'
  rc=lineout(ddNameR,info) ; say info
  /* wait */
  '@pause'
  exit
  end

/* acquire the direct control driver */
rc=stream(ddNameI,'command','open write')
if rc \= 'READY:'
then do
  info=rc||' Device driver '||ddNameI||' currently in use. Please try later.'
  rc=lineout(ddNameR,info) ; say info
  /* wait */
  '@pause'
  exit
  end

/* set configuration - configured */
rc=charout(ddNameI,x2c(00 09 01 00 00 00 00 00))
rc=stream(ddNameI,'description')
if rc \= 'READY:'
then do
  /* obtain and issue error message */
  parse value rc with sState ':' mNumber
  say SysGetMessage(mNumber,,ddNameI)
  say 'set configuration failed!'
  /* wait */
  '@pause'
  exit
  end

/* set report - feature */
rc=charout(ddNameI,x2c(21 09 02 03 00 00 02 00 02 02))
rc=stream(ddNameI,'description')
if rc \= 'READY:'
then do
  /* obtain and issue error message */
  parse value rc with sState ':' mNumber
  say SysGetMessage(mNumber,,ddNameI)
  say 'set feature report failed!'
  /* wait */
  '@pause'
  exit
  end

/* wait 30 milliseconds */
call SysSleep(0.030)

/* verify that the emulate mouse driver exists in config.sys */
if stream(ddNameO,'command','query exists') \= '\DEV\' || ddNameO
then do
  info='DEVICE=?:\OS2\BOOT\XSMOUSE.SYS required in CONFIG.SYS'
  rc=lineout(ddNameR,info) ; say info
  /* wait */
  '@pause'
  exit
  end

/* acquire the emulate mouse driver */
rc=stream(ddNameO,'command','open')
if rc \= 'READY:'
then do
  info=rc||' Device driver '||ddNameO||' currently in use. Please try later.'
  rc=lineout(ddNameR,info) ; say info
  /* wait */
  '@pause'
  exit
  end

/* set digitizer size */
xdmm=125.00 ; /* millimeter */
ydmm=085.00 ; /* millimeter */

/* set finger fixed extends */
xMaxFinger=480 ; yMaxFinger=320

/* set finger margins */
xMinFinger=trunc(xMaxFinger/10)
xMaxFinger=xMaxFinger-xMinFinger
yMinFinger=trunc(yMaxFinger/10)
yMaxFinger=yMaxFinger-yMinFinger

/* report finger extends */
extends='xSize='||xdmm||' mm. xMinFinger='||xMinFinger||' points. xMaxFinger='||xMaxFinger||' points.'
rc=lineout(ddNameR,extends) ; say extends
extends='ySize='||ydmm||' mm. yMinFinger='||yMinFinger||' points. yMaxFinger='||yMaxFinger||' points.'
rc=lineout(ddNameR,extends) ; say extends

/* initialize mouse events */
But1Down=x2c(0600) ; But2Down=x2c(1800)
But3Down=x2c(6000) ; ButsDown=x2c(1E00)
MoveOnly=x2c(0100) ; NoButMov=x2c(0000)

/* set screen fixed extends */
xMaxScreen=1280 ; yMaxScreen=800

/* move cursor to center */
xMin=0 ; xMax=xMaxScreen ; xPos=trunc(xMax/2)
yMin=0 ; yMax=yMaxScreen ; yPos=trunc(yMax/2)
xMaxOut=reverse(d2c(xMaxScreen,2))
yMaxOut=reverse(d2c(yMaxScreen,2))
call xsMouse(MoveOnly)
LastEvent=MoveOnly

/* catch these here to release the mouse */
signal on error; signal on failure; signal on halt;
signal on novalue; signal on syntax;

/* initialize */
oiBuffer = x2c('EC 00 00 00 82 03 14 00 EE EE EE EE EE EE EE EE EE EE EE EE EE EE EE EE EE EE EE EE')

do forever
  call GetPacket
  event=substr(oiBuffer,9,2)
  select
    when event=x2c(0200) then call Finger(NoButMov)
    when event=x2c(0201) then call Finger(But1Down)
    when event=x2c(0202) then call Finger(But2Down)
    when event=x2c(0204) then call Finger(But3Down)
    when event=x2c(0208) then call Finger(ButsDown)
    otherwise call Unknown
    end
  end

/* cleanup */
signal ProcessComplete
exit

GetPacket:
rc=charout(ddNameI,oiBuffer)
rc=stream(ddNameI,'description')
if rc \= 'READY:'
then do
  /* obtain error message */
  parse value rc with sState ':' mNumber
  if mNumber == 95 /* character i/o call interrupted */
  then rc=stream(ddNameI,'command','open') /* retry */
  else do
    /* issue error message */
    say SysGetMessage(mNumber,,ddNameI)
    say 'get finger packet failed!'
    /* wait */
    '@pause'
    exit
    end
  end
return

Finger:
parse arg type
/* use pointer input */
if bitand(substr(oiBuffer,16,1),'80'x)=='80'x
then do
  /* finger position */
  xPos=c2d(substr(oiBuffer,16,2))-32768
  yPos=c2d(substr(oiBuffer,18,2))
  /* finger calibration */
  if xPos<xMinFinger then xMinFinger=xPos
  if xPos>xMaxFinger then xMaxFinger=xPos
  if yPos<yMinFinger then yMinFinger=yPos
  if yPos>yMaxFinger then yMaxFinger=yPos
  /* use finger extends */
  xMin=xMinFinger ; xMax=xMaxFinger
  yMin=yMinFinger ; yMax=yMaxFinger
  end
/* use finger pointer */
call xsMouse(type)
LastEvent=type
return

Unknown:
/* show packet */
packet=c2x(substr(oiBuffer,9))
output='Packet='||packet||',Huh?'
rc=lineout(ddNameR,output)
say output
return

xsMouse:
parse arg EvntFlgs
/* calculate current screen position */
xCur=trunc(((xPos-xMin)*xMaxScreen)/(xMax-xMin))
yCur=trunc(((yPos-yMin)*yMaxScreen)/(yMax-yMin))

/* prepare event buffer */
xPosOut=reverse(d2c(xCur,2))
yPosOut=reverse(d2c(yCur,2))
oBuffer = EvntFlgs||yPosOut||xPosOut||yMaxOut||xMaxOut

/* write this event */
rc=charout(ddNameO,oBuffer)
rc=stream(ddNameO,'description')
/* check completion code */
if rc \= 'READY:'
then do
  say
  /* obtain and issue error message */
  parse value rc with sState ':' mNumber
  say SysGetMessage(mNumber,,ddNameO)
  /* wait */
  '@pause'
  exit
  end
return

/* report signal information */
error: failure: halt: novalue: syntax:
parse source system invokation filename
info=condition('c')||' condition raised at line '||sigl||' of'||'0D0A'x
info=info||filename||'0D0A'x||'|'||sourceline(sigl)
rc=lineout(ddNameR,info) ; say info

ProcessComplete:
/* report finger extends */
extends='xSize='||xdmm||' mm. xMinFinger='||xMinFinger||' points. xMaxFinger='||xMaxFinger||' points.'
rc=lineout(ddNameR,extends) ; say extends
extends='ySize='||ydmm||' mm. yMinFinger='||yMinFinger||' points. yMaxFinger='||yMaxFinger||' points.'
rc=lineout(ddNameR,extends) ; say extends

/* release the emulate mouse driver */
rc=stream(ddNameO,'command','close')
/* release the direct control driver */
rc=stream(ddNameI,'command','close')

/* report afinger.cmd stopped */
info='<============<afinger.cmd> stopped on <'||date()||'> at <'||time()'>============>'
rc=lineout(ddNameR,info) ; say info
exit
