/* HP TC4200 tc4200tc stylus events to xsmouse.sys */
rc=RxFuncAdd('SysGetMessage','RexxUtil','SysGetMessage')
rc=RxFuncAdd('SysSleep','RexxUtil','SysSleep')

/* set log file name */
ddNameR='tc4200tc.log'

/* report tc4200tc.cmd started */
info='<===========<tc4200tc.cmd> started on <'||date()||'> at <'||time()'>===========>'
rc=lineout(ddNameR,info) ; say info

/* set device driver names */
ddNameI='COM1' ; ddNameO='XSMOUSE$'

/* verify that the com port driver exists in config.sys */
if stream(ddNameI,'command','query exists') \= '\DEV\' || ddNameI
then do
  info='DEVICE=?:\OS2\BOOT\COM.SYS (1,200,6,I) required in CONFIG.SYS'
  rc=lineout(ddNameR,info) ; say info
  /* wait */
  '@pause'
  exit
  end

/* setup communication mode */
'MODE '||ddNameI||':19200,N,8,1,TO=OFF'

/* verify that the emulate mouse driver exists in config.sys */
if stream(ddNameO,'command','query exists') \= '\DEV\' || ddNameO
then do
  info='DEVICE=?:\OS2\BOOT\XSMOUSE.SYS required in CONFIG.SYS'
  rc=lineout(ddNameR,info) ; say info
  /* wait */
  '@pause'
  exit
  end

/* acquire the emulate mouse driver */
rc=stream(ddNameO,'command','open')
if rc \= 'READY:'
then do
  info=rc||' Device driver '||ddNameO||' currently in use. Please try later.'
  rc=lineout(ddNameR,info) ; say info
  /* wait */
  '@pause'
  exit
  end

/* set digitizer size */
xdmm=245.76 ; /* millimeter */
ydmm=184.32 ; /* millimeter */

/* convert digitizer size */
xdmi=(xdmm*10000)/254 ; /* mInch */
ydmi=(ydmm*10000)/254 ; /* mInch */

/* set digitizer resolution */
xppi=2540/4 ; /* points/inch */
yppi=2540/4 ; /* points/inch */

/* set digitizer extends */
xMax=trunc((xdmi*xppi)/1000)
yMax=trunc((ydmi*yppi)/1000)

/* report digitizer extends */
extends='xSize='||xdmm||' mm, '||xdmi||' mInch, '||xMax||' points.'
rc=lineout(ddNameR,extends) ; say extends
extends='ySize='||ydmm||' mm, '||ydmi||' mInch, '||yMax||' points.'
rc=lineout(ddNameR,extends) ; say extends

/* set digitizer margins */
xMin=trunc(xMax/20) ; xMax=xMax-xMin
yMin=trunc(yMax/20) ; yMax=yMax-yMin

/* set digitizer pressure */
zMin=100 ; zMax=4000 /* guess */

/* set sum rolling averages */
nRol=64 /* number of samples */
xPos=trunc((xMin+xMax)/2) ; xSum=0
yPos=trunc((yMin+yMax)/2) ; ySum=0
zPos=trunc((zMin+zMax)/2) ; zSum=0
do index = 1 to nRol
  xRol.index=xPos ; xSum=xSum+xPos
  yRol.index=yPos ; ySum=ySum+yPos
  zRol.index=zPos ; zSum=zSum+zPos
  end

/* initialize mouse events */
But1Down=x2c(0600) ; But2Down=x2c(1800)
MoveOnly=x2c(0100) ; NoButMov=x2c(0000)

/* move to center */
call XsMouse(MoveOnly)

/* catch these here to release the mouse */
signal on error; signal on failure; signal on halt;
signal on novalue; signal on syntax;

i=0
do forever
  call GetPacket
/*
**     bit    7     6     5     4     3     2     1     0
**         Ŀ
**  byte.1   1    0   Prx   ?    ?    ?   Bt1  Bt0 
**         Ĵ
**  byte.2   0   x13  x12  x11  x10  x09  x08  x07 
**         Ĵ
**  byte.3   0   x06  x05  x04  x03  x02  x01  x00 
**         Ĵ
**  byte.4   0   y13  y12  y11  y10  y09  y08  y07 
**         Ĵ
**  byte.5   0   y06  y05  y04  y03  y02  y01  y00 
**         Ĵ
**  byte.6   0   z11  z10  z09  z08  z07  z06  z05 
**         Ĵ
**  byte.7   0   z04  z03  z02  z01  z00   ?    ?  
**         Ĵ
**  byte.8   0    0    0    0    0    0    0    0  
**         Ĵ
**  byte.9   0    0    0    0    0    0    0    0  
**         
*/
  sBtn=c2d(bitand(byte.1,'0F'x))
  xPos=128*c2d(byte.2)+c2d(byte.3)
  yPos=128*c2d(byte.4)+c2d(byte.5)
  zPos=32*c2d(byte.6)+c2d(bitand(byte.7,'7C'x))%4
  event=bitand(byte.1,'E3'x)
  select
    when event=='80'x then call XsMouse(NoButMov)
    when event=='A0'x then call XsMouse(MoveOnly)
    when event=='A1'x then call XsMouse(But1Down)
    when event=='A2'x then call XsMouse(But2Down)
    when event=='A3'x then call XsMouse(But1Down)
    otherwise call Unknown
    end
  end

/* cleanup */
signal ProcessComplete
exit

GetPacket:
do until i==10
  if i==0 then do
    /* obtain 1st byte of packet */
    do until bitand(byte.1,'80'x)=='80'x
      byte.1=charin(ddNameI)
      end
    end
  else byte.1=byte.i /* in sync */
  i=1 ; /* obtain rest of packet */
  do until bitand(byte.i,'80'x)=='80'x
    i=i+1 ; byte.i=charin(ddNameI)
    end
  end
return

Report:
parse arg type
/* show report */
output='sBtn='||sBtn||',xPos='||xPos||',yPos='||yPos||',zPos='||zPos||','||type
rc=lineout(ddNameR,output)
say output
return

Unknown:
/* show packet */
packet=c2x(byte.1||byte.2||byte.3||byte.4||byte.5||byte.6||byte.7||byte.8||byte.9)
output='Packet='||packet||',Huh?'
rc=lineout(ddNameR,output)
say output
return

XsMouse:
parse arg EvntFlgs
/* update sum rolling averages */
index=index-1 ; if index==0 then index=nRol
xSum=xSum+xPos-xRol.index ; xRol.index=xPos
ySum=ySum+yPos-yRol.index ; yRol.index=yPos
zSum=zSum+zPos-zRol.index ; zRol.index=zPos

/* set rolling averages */
xAvg=trunc(xSum/nRol)
yAvg=trunc(ySum/nRol)
zAvg=trunc(zSum/nRol)

/* calibrate offsets */
if xAvg<xMin then xMin=xAvg
if xAvg>xMax then xMax=xAvg
if yAvg<yMin then yMin=yAvg
if yAvg>yMax then yMax=yAvg
if zAvg<zMin then zMin=zAvg
if zAvg>zMax then zMax=zAvg

/* use sanity checks */
if xPos<xMin then xPos=xMin
if xPos>xMax then xPos=xMax
if yPos<yMin then yPos=yMin
if yPos>yMax then yPos=yMax

/* prepare current position */
xPosOut=reverse(d2c(xPos-xMin,2))
yPosOut=reverse(d2c(yPos-yMin,2))
xMaxOut=reverse(d2c(xMax-xMin,2))
yMaxOut=reverse(d2c(yMax-yMin,2))
oBuffer = EvntFlgs||yPosOut||xPosOut||yMaxOut||xMaxOut

/* write this event */
rc=charout(ddNameO,oBuffer)
rc=stream(ddNameO,'description')
/* check completion code */
if rc \= 'READY:'
then do
  say
  /* obtain and issue error message */
  parse value rc with sState ':' mNumber
  say SysGetMessage(mNumber,,ddNameO)
  /* wait */
  '@pause'
  exit
  end
return

/* report signal information */
error: failure: halt: novalue: syntax:
parse source system invokation filename
info=condition('c')||' condition raised at line '||sigl||' of'||'0D0A'x
info=info||filename||'0D0A'x||'|'||sourceline(sigl)
rc=lineout(ddNameR,info) ; say info

/* calculate current size */
xSize=xMax-xMin ; xdmm=(xSize*25.4)/xppi
ySize=yMax-yMin ; ydmm=(ySize*25.4)/yppi

/* report current extends */
extends='xMin='||xMin||',xMax='||xMax||',xSize='||xSize||' points, '||xdmm||' mm.'
rc=lineout(ddNameR,extends) ; say extends
extends='yMin='||ymin||',yMax='||yMax||',ySize='||ySize||' points, '||ydmm||' mm.'
rc=lineout(ddNameR,extends) ; say extends
extends='zMin='||zmin||',zMax='||zMax
rc=lineout(ddNameR,extends)
say extends

ProcessComplete:
/* release the emulate mouse driver */
rc=stream(ddNameO,'command','close')

/* report tc4200tc.cmd stopped */
info='<===========<tc4200tc.cmd> stopped on <'||date()||'> at <'||time()'>===========>'
rc=lineout(ddNameR,info) ; say info
exit
