/* comraw.cmd - obtain raw digitizer data from com port */

/* default bit rate and com port */
BitRate='19200' ; PortNumber='1'

/* process arguments */
parse upper arg Arg.1 Arg.2 .
do i = 1 to 2
  select
    /* modify bit rate */
    when Arg.i=='9600' then BitRate=Arg.i
    when Arg.i=='19200' then BitRate=Arg.i
    when Arg.i=='38400' then BitRate=Arg.i
    /* modify com port */
    when Arg.i=='1' then PortNumber=Arg.i
    when Arg.i=='2' then PortNumber=Arg.i
    when Arg.i=='3' then PortNumber=Arg.i
    when Arg.i=='4' then PortNumber=Arg.i
    /* ignore argument */
    otherwise nop
    end
  end

/* set input file name */
iFile='COM'||PortNumber

/* set communication mode */
'MODE '||iFile||':'BitRate',N,8,1,TO=OFF'

/* set output file name */
oFile=BitRate||'.raw'

do i = 1 to 32768
  /* copy raw digitizer data */
  rc=charout(oFile,charin(iFile))
  end
exit
