/* Sticker.cmd v1.1 (c)PYzone 2002-2003 */

/* Provides interactive selection of the target task window to track */
/* Keeps selected target window on top */
/* Allows to restore aspect ratio if target was resized (useful for TV & video) */

/* 9Lives! (and probably similar programs) aware */
/* Number of simultaneously tracked windows is not limited */

/* To (re)create the WPS object launch this script with any parameter */

NUMERIC DIGITS 10
call RxFuncAdd 'PYRxInit', 'PYRxUtil', 'PYRxInit'
call PYRxInit
call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs

parse source . . eP
parse arg restart .

title = "Sticker"
call set_icon arg(1,'e')

signal on HALT name h_exit
signal on SYNTAX name s_exit

SWP.SIZE = 1 ; SWP.MOVE = 2 ; SWP.ZORDER=4 
SWP.SHOW = 8 ; SWP.HIDE = 16
SWP.ACTIVATE = 128 ; SWP.DEACTIVATE = 256
SWP.MINIMIZE = 1024 ; SWP.MAXIMIZE = 2048 
SWP.RESTORE = 4096
    
Z_TOP = 3
 
cx.1 = 0 ;      cy.1 = 0                           
cx.2 = -32000 ; cy.2 = -32000
cx.3 = 32000 ;  cy.3 = 32000

big_loop:

parse value "" with f_screen sticked now_msg

call PYRxGo 't','....--'
my_hwnd = PYRxGo('t',title' config')
call brd_size

call PYRxGo 't','*','*','tl'		/* retrieve running tasks */
do i=1 to tl.0
  parse var tl.i hwnd pid . type vis . '"' task_ttl '220122'x win_ttl '"'
  if vis = 4 then			/* SWL_VISIBLE */
    if wordpos(type,'1 4') = 0 then	/* 1 = OS/2 FS , 4 = VDM FS */
      call PYRxGo 't','%',hwnd,'z_mem.hwnd'
     else
      do
	f_screen = f_screen' 'hwnd
	call PYRxGo 't','....-',hwnd
       end
  if pid = 0 then			/* Tasklist */
    do
      tl_hwnd = hwnd ; tl_ttl = win_ttl
     end
  call word task_ttl,2
  if pos(title': ',task_ttl) = 1 & words(task_ttl) = 4 then
    if datatype(result,'w') then
      if datatype(PYRxGo('t','%',result),'w') then
        do
	  sticked = sticked' 'result':'hwnd
	  call strip PYRxGo('t','.........?',result),,'"'
	  if length(result) > 32 then
	    result = left(result,30)||'..'
	  now_msg = now_msg||'0d0d'x||result
	 end
 end  /* do i=1 to tl.0 */

if now_msg \= "" then
  now_msg = " Now sticked "||words(sticked)||" task window(s):"||now_msg
 else
  now_msg = 'd'x
call PYRxMsg ,,,title,now_msg,my_hwnd,," Target "," Quit "
if result \= 11 then
  signal do_exit

/* ---- target task window selection ---- */
call PYRxGo 't','.Select Task to STICK',tl_hwnd
do forever
   /* ==== show TaskList ==== */
  call PYRxGo 't','%',tl_hwnd,'origin'
  parse var origin x y cx cy . . . dx dy
  if cx > dx then
    cx = dx
  if cy > dy then
    cy = dy
  call PYRxGo 't','!',tl_hwnd,(dx - cx)%2||' '||(dy - cy)%2||' 'cx' 'cy' 0 ',
			    ||(SWP.SIZE+SWP.MOVE+SWP.SHOW+SWP.ACTIVATE)
  do i=1 to 50 until PYRxGo('t','%',tl_hwnd) & PYRxGo('t','@',tl_hwnd)
    call PYRxKey 100
   end
  if i > 50 then
    iterate
   /* ==== init vars ==== */
  drop tl_ses act_hwnd tmp_hwnd type ; act_count = 0 ; off_list = my_hwnd
   /* ==== wait the TaskList to disappear ==== */
  do until tl_ses \= fg_ses | \PYRxGo('t','%',tl_hwnd)
    call PYRxKey 100*(tl_ses\='TL_SES')
    fg_ses = PYRxGo('i','.......................?')
    if tl_ses = 'TL_SES' then
      tl_ses = fg_ses
   end
   /* ==== collect "denied" windows ==== */
  call PYRxGo 't',,0,'tl'
  do i=1 to tl.0
    parse var tl.i . hwnd task_hwnd .
    if hwnd \= task_hwnd | (i = tl.0 & pos('"wpFolder window"',tl.i) \= 0) | pos(' "#3"',tl.i) \= 0 then  /* DeskTop | WarpCenter */
      off_list = off_list' 'hwnd
   end
   /* ==== fix new active window ==== */
  do i=1 to 50 until act_count = 5
    call PYRxKey 100
    act_hwnd = PYRxGo('t','@')
    do while act_hwnd \= tmp_hwnd | act_hwnd = tl_hwnd
      tmp_hwnd = act_hwnd
      act_count = 0
      iterate i
     end
    act_count = act_count + 1
   end
   /* ==== check if new active window is "legal" ==== */
  if pos(act_hwnd,off_list) \= 0 | \datatype(act_hwnd,'w') | act_count = 0 then
    iterate
  if act_count \= 0 then
    if PYRxGo('t','%',act_hwnd,'act_pos') \= 1 then
      iterate
     else    
      do 
	parse value PYRxGo('t','...?.....?',act_hwnd) with stick_type stick_ttl
	if stick_type = "" then
  	  iterate
       end
   /* ==== check if selected task is already sticked ==== */
  parse var sticked (act_hwnd) result ':' hwnd .
  if result = "" & datatype(hwnd,'w') then
    if datatype(PYRxGo('t','%',hwnd),'w') then
      do
	task_ttl = strip(PYRxGo('t','.........?',hwnd),,'"')
	type = " Off "
       end
   /* ==== request for stick time interval ==== */
  stick_ttl = strip(stick_ttl,,'"')
  if type \= " Off " then
    type = ""

  stick_dt = PYRxMsg(,,,,stick_ttl||'0000'x||'  Stick ?',act_hwnd,,type,' 1 sec.',' 10 sec.',' Skip ',' Quit ') - (type \= "")

  if stick_dt < 10 | stick_dt > 12 then
    do
      parse var z_mem.act_hwnd . . . . z_behind max_min hide_show .
      if z_behind \= '' then
	call PYRxGo 't','!',act_hwnd,'0 0 0 0 'z_behind' ',
			   ||(max_min = 1)*SWP.MINIMIZE + (hide_show = 2)*SWP.HIDE + SWP.ZORDER
			   
      if stick_dt \= 14 then
	iterate
     end

  call restore_tl
  if stick_dt = 14 then
    signal do_exit

  parse var act_pos stick_mem 1 x_mem y_mem cx cy .
  parse value w_size(act_hwnd,cx,cy) with stick_cx stick_cy 1 cx_mem cy_mem
  if type = "" then
    task_ttl = title': 'act_hwnd' 'stick_cx' 'stick_cy
  call PYRxGo 't',task_ttl ; i = 0
  if type \= "" then
    do i=1 to 50 until tl.0 = 1 
      call PYRxKey 200
      call PYRxGo 't','?',task_ttl,'tl'
     end
  if stick_dt = 10 then
    signal big_loop  
  if (stick_dt \= 11 & stick_dt \= 12) | i > 50 then
    signal do_exit
    
  stick_hwnd = act_hwnd ; stick_dt = 10*(stick_dt = 12)
  leave
 end /*do forever*/
/* ---- top position & aspect ratio management ---- */
timer=0 ; asp_flag=1 ; zl_top = Z_TOP' 'tl_hwnd
do timer_fix = timer while 1
  stick_time = timer + stick_dt*1000 + 1
  new_pos = 0
  do j=1 while timer < stick_time & timer >= timer_fix & new_pos = 0
    call PYRxKey 500
    timer = PYRxGo('i','.............?')
    /* ==== check if new script instance was started ==== */
    zl = "" ; call PYRxGo 't','?........?',title'*','tl'
    do i=1 to tl.0
      parse var tl.i hwnd result
      call strip result,,'"'
      if hwnd \= my_hwnd & task_ttl = result then
	signal do_exit	/* terminate if sticker for same target appeared */
      if pos('config',result) \= 0 then
	iterate timer_fix /* idle if new target is being selecting */
      zl = zl||word(result,2)||' '
     end
    /* ==== query current parameters of target window ==== */
    visible = PYRxGo('t','%',stick_hwnd,'w_pos')  /* =1 if visible */
    if \datatype(visible,'w') then
      signal do_exit	/* target window was closed */
    parse var w_pos x y cx cy z_behind max_min hide_show sx sy
    if stick_cur = 'STICK_CUR' then
      stick_cur = cx' 'cy
    if max_min = 1 | hide_show = 2 then
      iterate timer_fix		/* ignore all if minimized or hidden */
    if (abs(x - x_mem) >= sx) | (abs(y - y_mem) >= sy) then
      do
	call PYRxGo 't','%',,'w_pos'
	if anchor = delword(w_pos,3) then
	  iterate
	anchor = delword(w_pos,3)
	new_pos = 1 ; leave
       end
    if overlapped() then
      drop stick_mem
    if \visible then
      iterate
    if delword(stick_mem,5) = x' 'y' 'cx' 'cy' ' then
      iterate timer_fix		/* ignore all if minimized or hidden */
    /* check target's aspect ratio */
    parse value w_size(stick_hwnd,cx,cy) with w_cx w_cy
    if asp_flag & (w_cx \= cx_mem | w_cy \= cy_mem) then
      do 1 while abs(stick_cx/stick_cy - w_cx/w_cy) > 0.01
        call PYRxGo 't',task_ttl' config'  /*prevents to concurrents do pop-up */
	call PYRxMsg ,,,,stick_ttl||'0000'x||'  Aspect ratio was changed.',stick_hwnd,,'Resize','Ignore',' Use ','Reset','Track Off','Quit'
        _res_ = PYRxGo('t',task_ttl)
	if result = 16 then /* 'Quit' */
	  do
	    call PYRxGo 't','!',stick_hwnd,0' '0' 'stick_cur' '0' '||(SWP.SIZE + SWP.SHOW)
	    signal do_exit
           end
	if result = 15 then /* 'Track Off' */
	  asp_flag = 0
	if result = 13 then
	  do		/* Use */
	    stick_cx = w_cx ; stick_cy = w_cy
	    drop stick_cur
	   end
	select
	  when result = 11 then
	    if abs(cx - cx_mem) <= abs(cy - cy_mem) then
	      call resize 'X'
	     else	  
	      call resize 'Y'
	  when result \= 14 then
	    leave	/* Ignore, Use, Track Off */
	  otherwise	/* result=14 : Reset */
	    stick_cx = word(task_ttl,3) ; stick_cy = word(task_ttl,4)
	    cx = stick_cx + (cx - w_cx) ; cy = stick_cy + (cy - w_cy) 
	    w_cx = stick_cx ;		  w_cy = stick_cy
	    x = (sx - cx)%2 ;		  y = (sy - cy)%2
	 end /* select */
	new_pos = 2
       end
    cx_mem = w_cx ; cy_mem = w_cy
    x_mem = x ; y_mem = y
   end  /* do j=1 while timer < stick_time & timer >= timer_fix & new_pos = 0 */

  if  \visible & new_pos=0 then	/* fullproof */
    do
      x_mem = x_mem // sx
      if (x_mem + cx) < 0 then
	x_mem = x_mem + sx
      y_mem = y_mem // sy
      if (y_mem + cy) < 0 then
	y_mem = y_mem + sy
      new_pos = 1
     end

  z_move = SWP.SIZE + SWP.SHOW + SWP.ZORDER*(\visible | (stick_mem='STICK_MEM'))
  if stick_type = 3 & new_pos = 2 then
    call PYRxGo 't','!',stick_hwnd,x_mem' 'y_mem' 'cx' 'cy' 'Z_TOP' '||(SWP.MOVE + z_move)
   else
    if new_pos > 0 then
      do
	do z=1 to 3 until j < 10
	  call PYRxGo 't','!',stick_hwnd,x_mem' 'y_mem' 'cx.z' 'cy.z' 0 '||(SWP.MOVE + SWP.HIDE*((stick_type \= 3) | (new_pos > 1)))
	  do j=1 to 10 until abs(x_mem - cur_x) < 16 & abs(y_mem - cur_y) < 16
	    call PYRxKey 200
	    call PYRxGo 't','%', stick_hwnd, 'w_pos'
	    parse var w_pos cur_x cur_y .
	   end
	 end
	call PYRxGo 't','!',stick_hwnd,'0 0 'cx' 'cy' 'Z_TOP' 'z_move
       end
     else
      call pop_up
  
  do 10 until result
    call PYRxKey 200
    call PYRxGo 't','%',stick_hwnd,'stick_mem'
   end
  parse var stick_mem x_mem y_mem cx cy z_behind .
  stick_cur = cx' 'cy
  parse value w_size(stick_hwnd,cx,cy) with cx_mem cy_mem
 end	/* do timer_fix = timer while 1 */
  
h_exit:
call PYRxMsg ,,,title,"User break at line "sigl||'0'x,'i'
signal do_exit

s_exit:
call PYRxMsg ,,,title,"Syntax at line "sigl||'0'x,'i'

do_exit:
 call restore_tl
 if org_pos \= 'ORG_POS' then
   do  /* restore own window to its original state */
     parse var org_pos x y sx sy z_bh mmx s_hd .
     call PYRxGo 't','!',,x' 'y' 'sx' 'sy' 4 '||(SWP.SIZE+SWP.MOVE+SWP.ZORDER)
     call PYRxKey 100
     select
       when s_hd = 2 then
         nop   /* originally was hidden */
       when mmx = 1 then
         call PYRxGo 't','.'  /* was minimized */
       otherwise
         call PYRxGo 't','!'
      end
    end
 exit

/* tasklist restoration */
restore_tl :
  do while f_screen \= 'F_SCREEN'
    do i = 1 to words(f_screen)
      call PYRxGo 't','....+',word(f_screen,i)
     end
    drop f_screen
   end
  if tl_ttl \= 'TL_TTL' & tl_hwnd \= 'TL_HWND' then
    call PYRxGo 't','.'tl_ttl,tl_hwnd
  return
  
/* "true" window size evaluation considering borders, sliders and title */
w_size : procedure expose cl_hwnd SWP.
  parse arg w_hwnd, w_cx, w_cy
  title_cy = 0 ; h_scroll_cy = 0 ; v_scroll_cx = 0
  call PYRxGo 't',,w_hwnd,'cwl'
  do i=1 to cwl.0
    parse var cwl.i . result . '1'x '"' cl_name '"'
    call PYRxGo 't','%',result,'size_var'
    parse var size_var . . cx cy .
    select
      when cl_name = "#9" then	/* title */
        title_cy = cy
      when cl_name = "#8" then	/* scrollbars */
        if cx > cy then
          h_scroll_cy = cy	/* horizontal */
         else
          v_scroll_cx = cx	/* vertical */
      otherwise
        nop
     end
   end
  parse value brd_size() with brd_cx brd_cy .
  return (w_cx - 2*brd_cx - v_scroll_cx)||' ',
	||(w_cy - 2*brd_cy - h_scroll_cy - title_cy)

/* window borders size determination (indirect way) */
brd_size : procedure expose cl_hwnd anchor org_pos SWP.
  if cl_hwnd = 'CL_HWND' then
    do  /* started for the 1st time - let's "hide" - change our size to 1x1 pixel */
      call PYRxGo 't','%',,'org_pos' /* store original size */
      call PYRxGo 't',,0,'zl'
      call PYRxGo 't','!',,'0 0 0 0 0 '||(SWP.SIZE+SWP.HIDE+SWP.MAXIMIZE)
      call PYRxKey 100
      call PYRxGo 't','%',,'w_pos'
      anchor = delword(w_pos,3)
      hwnd = PYRxGo('t','!',,'0 0 1 1 0 '||(SWP.SIZE+SWP.MOVE+SWP.SHOW+SWP.RESTORE+SWP.DEACTIVATE))
      do i=1 to zl.0 until result = hwnd
	parse var zl.i . result . '1'x . . . . . . . . . . cl_hwnd .
       end
      if \datatype(cl_hwnd,'w') then
        cl_hwnd = 0
      call PYRxGo 't','%',,'w_pos'
      anchor = delword(w_pos,3)
     end
  if cl_hwnd = 0 then
    return '0 0'
  call PYRxGo 't','%',cl_hwnd,'w_pos'
  return w_pos

/* window resizing */
resize :
  axe = arg(1)
  interpret 'axe_const = c'axe' - w_c'axe' ; axe2 = 'axe' + c'axe
  if axe = 'Y' then
    w_cy = format((w_cx*stick_cy)/stick_cx,,0)
   else 
    w_cx = format((w_cy*stick_cx)/stick_cy,,0)
  interpret ,
    'if 'axe'<=0 then side=0 ; else ; if axe2 >= s'axe' then side=1 ;',
  ||'else side = (abs('axe') >= abs(s'axe'-axe2)) ; c'axe' = w_c'axe' + axe_const ;', 
  ||'if side then; do; 'axe' = axe2 - c'axe' ; if 'axe' < 0 then 'axe' = s'axe'-c'axe'; if 'axe' < 0 then 'axe' = 0 ; end ;',
  ||'else; do ; axe2 = 'axe'+c'axe'-s'axe'; if axe2 >= 0 then 'axe'='axe'-axe2 ; end'
  return

/* returns 1 if overlapped by other visible upper windows, otherwise returns 0 */
/* also returns 0 if another Sticker is more bottom in Desktop z-sequence */
/* (mainly, all z-movings will be performed only by bottommost Sticker) */
overlapped: procedure expose zl zl_top stick_hwnd z_mover z_order.
  drop z_order. ; j = 0 ; ovl = 0
  call PYRxGo 't',,0,'z_order'
  do i=1 to z_order.0 until z_order.i = stick_hwnd
    z_order.i = word(z_order.i,2)
    if pos(z_order.i,zl) \= 0 then
      j = j + 1
   end
  z_order.0 = i - 1 ; z_mover = j = words(zl)
  do i=1 to z_order.0 while z_mover & \ovl
    if pos(z_order.i,zl_top' 'zl) = 0 then
      ovl = ovl_by(z_order.i)
   end
  return ovl

/* returns 1 if indicated window visibly overlaps own window, otherwise returns 0 */
ovl_by: procedure expose zl
  call PYRxGo 't','%',arg(1),'w_pos'
  parse var w_pos x_ovl y_ovl cx_ovl cy_ovl . . hide_show .
  if hide_show = 2 | \datatype(result,'w') then
    return 0		/* ignore if hidden */
  do i = 1 to words(zl)
    call PYRxGo 't','%',word(zl,i),'w_pos'
    parse var w_pos x y cx cy . min_max hide_show .
    if min_max = 1 | hide_show = 2 | \datatype(result,'w') then
      iterate
    if ((x_ovl < x) & ((x_ovl+cx_ovl) >= x)) | ((x_ovl >= x) & (x_ovl <= (x + cx))) then
      if ((y_ovl < y) & ((y_ovl+cy_ovl) >= y)) | ((y_ovl >= y) & (y_ovl <= (y + cy))) then
	return 1
   end
  return 0

/* if it's bottommost Sticker (z_mover=1) - moves down all visible upper non-Stiker windows */
/* also always moves down upper Stickers that fully overlaps own window */
pop_up : procedure expose stick_hwnd x y cx cy visible zl_top zl z_mover SWP. z_order.
  do i = z_order.0 to 1 by -1	/* z_order sequence was filled by overlapped() */
    u_sticker = pos(z_order.i,zl_top' 'zl) \= 0
    if \u_sticker then 
      do
	if \z_mover then
	  iterate
       end
     else
      if visible then
	iterate
    call PYRxGo 't','%',z_order.i,'w_pos'
    parse var w_pos w_x w_y w_cx w_cy . . hide_show .
    if hide_show = 2 | \datatype(result,'w') then
      iterate		/* ignore if hidden */
    if u_sticker then
      do
	if (w_x > x) | ((w_x + w_cx) < (x + cx)) then
	  iterate
	if (w_y > y) | ((w_y + w_cy) < (y + cy)) then
	  iterate
       end
    call PYRxGo 't','!',z_order.i,'0 0 'w_cx' 'w_cy' 'stick_hwnd' '||(SWP.SIZE+SWP.ZORDER)
   end
  return

set_icon : procedure expose eP title restart
 /* is used once at start */
 /* decodes base64 icon code and attaches it to program file's EAs */
 /* creates WPS object and restarts program when it is "fresh" or is started with any parameter */

  call SysGetEA eP,'.ICON','ic'
  if \datatype(result,'w') | result \= 0 then
    ic = ''                      /* GetEA error */
  if length(ic) \= 3348 then
    do
       /* obtain base64-coded icon from last comment of script body */
      parse value charin(eP,,50000) with '2f2a7e'x i64 '2a2f'x
      call stream eP,'c','close'

       /* base64 decoding of icon */
      i64 = translate(i64,'0000'x,'0d0a'x)
      d_code = xrange('0'x,'3f'x) ; s_code = xrange('A','Z')||xrange('a','z')||'0123456789+/'
      ji = 1 ; ic = ''
      call pos '0'x,i64
      do while result \= 0
        tmp_s = ''
        if result > ji then
          tmp_s = x2b(c2x(translate(substr(i64,ji,result-ji),d_code,s_code)))
        ji = result+1
        do while tmp_s \= ''
          parse var tmp_s +2 ic.0 +6 +2 ic.1 +6 +2 ic.2 +6 +2 ic.3 +6 +2 ic.4 +6 +2 ic.5 +6 ,
                      +2 ic.6 +6 +2 ic.7 +6 +2 ic.8 +6 +2 ic.9 +6 +2 ic.10 +6 +2 ic.11 +6 tmp_s
          result = ic.0||ic.1||ic.2||ic.3||ic.4||ic.5||ic.6||ic.7||ic.8||ic.9||ic.10||ic.11
          if result \= '' then
            ic = ic||x2c(b2x(left(result,length(result)%8*8)))
         end
        call pos '0'x,i64,ji
       end
     end
  if length(ic) = 3344 then
    do  /* Just decoded, Ok - store it in EAs */
      ic = 'F9FF'x||translate('12',d2c(length(ic),2),'21')||ic
      call SysPutEA eP,'.ICON',ic
      restart = '$'
     end
  if restart \= '' then
    do  /* (re)make WPS object after prompt message */
      if length(ic) = 3348 then
        do  /* let's make a temporary icon file to show it in messagebox */
          tmp_s = SysTempFileName(left(eP,lastpos("\",eP))||'TMP?????.ICO')
          call charout tmp_s,substr(ic,5)
          call charout tmp_s
         end
       else
        tmp_s = ''
      if PYRxMsg(,,,,title||'0'x||'  Ready to use.',tmp_s,,' Ok ','Make WPS object') = 12 then
        call SysCreateObject "WPProgram",title,"<WP_DESKTOP>","EXENAME="eP";MINIMIZED=YES;CCVIEW=YES","REPLACE"
      if tmp_s \= '' then
        '@del 'tmp_s
      '@start /c /f /pgm "'eP'"'
     end
   else
    return
  exit

/*~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*/
