/* REXX -- Convert Postroad Mailer messages to PM Mail format */

/* Usage: make the PRM messages directory the current directory and 
          run this program. It will find all *.pop files and convert
          them to *.msg files, ready for PM Mail message importing.
          
          It isn't perfect, but it proved to be perfect enough for me.
          If I find more info on the PRM tags I may revisit this.
*/

/* Example messaage and PRM Decoding matrix (an emperical study)
   To: ibm-netrexx@hursley.ibm.com
   CC: slick.willy@whitehouse.gov
   N/A sent
   N/A C:\PR2\DPETERSO\sent
   Priority: 2Normal
   From: Dennis Peterson <dpeterso@halcyon.com>
   Reply-To: 1Dennis Peterson <dpeterso@halcyon.com>
   Subject: Java Sort Demo
Message body follows mandatory blank line

Does anyone recall this and know where to locate it, and what it might take to convert it to 
the current version of Java? 
 .
 .
 .
 
   N/A 
Regards, 
Dennis Peterson 
dpeterso@halcyon.com
*/

signal on halt name CLEANUP

Do while queued() > 0
   parse pull junk
end

crlf     = '0d0a'x
ugly_bit = '05'x
To_bit   = '01'x
CC_bit   = '02'x
From_bit = '0b'x
Subject_bit  = '0f'x
Reply_To_bit = '31'x
Priority_bit = '32'x

rc = sysfiletree('*pop','file_list','fo')
do i = 1 to file_list.0
   say file_list.i
   cc_flag = 0

   parse value file_list.i with base_name '.' debris
   outfile = base_name || '.msg'
   rc = SysFileTree(outfile,'junk','f')
   if rc = 0 then
      call SysFileDelete(outfile)
   else
      rc = stream(outfile,'C', 'open write')

/* for reasons I cannot recall, I used the command line 'cat' command
   to stream the data to rxqueue. If you don't have it you can always
   use the more normal OS/2 type command. I'm a Unix admin -- I use
   cat a lot :-)
   
   I think I had trouble with conventional methods and this is was an easy
   fix.
*/
      
   '@cat 'file_list.i'|rxqueue'

   Do While queued() > 0
      parse pull current_line
      tag = left(current_line,2)
      current_line = strip(current_line,l,ugly_bit)
      select
         when tag = '0501'x then do /* To:  */
            call lineout outfile, 'To:' strip(current_line,l,to_bit)
         end
         
         when tag = '0502'x then do /* CC:  */
            if cc_flag = 0 then
               call lineout outfile, 'CC:' strip(current_line,l,CC_bit) || ','
            else
               call lineout outfile, '   ' strip(current_line,l,CC_bit) || ','
            cc_flag = 1
         end
         
         when tag = '050b'x then do /* Call From  */
            call lineout outfile, 'From:' strip(current_line,l,From_bit)
         end
         
         when tag = '050f'x then do /* Call Subject */
            call lineout outfile, 'Subject:' strip(current_line,l,Subject_bit) || crlf
         end
         
         when tag = '0531'x then do  /* Call Reply-To */
            call lineout outfile, 'Reply-To:' strip(current_line,l,Reply_To_bit)
         end
         
         when tag = '0532'x then do  /* Call Priority */
            call lineout outfile, 'Priority:' strip(current_line,l,Priority_bit)
         end

         when tag = '0535'x then  /* CC: list at end of message */
            do while queued() > 0
               parse pull junk       /* strip it out */
            end

         when tag = '' then NOP
         when tag = '' then NOP
         when tag = '' then NOP
         otherwise call lineout outfile, current_line
      end
   end
   rc = stream(outfile,'C', 'close')
end
exit
CLEANUP:
Do while queued() > 0
   parse pull junk
end
exit
