/* Installation script for PM DCopy.
 * - J.R.Shannon 1992, 1993.
 */

CALL rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
CALL sysloadfuncs

SrcDir = ' '
DO UNTIL SrcDir <> ''
   SAY 'Please enter the drive or directory where the PM Dcopy files currently'
   SAY 'reside (e.g. A:, or C:\TEMP):'
   PULL SrcDir
END
IF Right(SrcDir,1) <> '\' THEN SrcDir = SrcDir||'\'

DestDir = ''
DO UNTIL DestDir <> ''
   SAY 'Please enter the full pathname of the directory into which you'
   SAY 'would like PM DCopy to be installed (eg. C:\FILES\APPS\PMDCOPY):'
   PULL DestDir
END

rc = SysFileTree(DestDir, 'Dirs', 'D')

IF Dirs.0 = 0 THEN
  CALL SysMkDir DestDir

folder = ''
SAY 'Do you want a PM DCopy program object created on the desktop? (Y/N)'
PULL response
IF response = "Y" THEN
   folder = '<WP_DESKTOP>'

'@copy' SrcDir||'pmdcopy.exe' destdir
'@copy' SrcDir||'pmdcopy.hlp' destdir

IF folder <> '' THEN
DO
  SAY 'Creating program object...'

  Type='WPProgram'
  Title='PM DCopy'
  Parms='MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='DestDir'\PMDcopy.exe;STARTUPDIR='DestDir';OBJECTID=<PMDCOPY>;NOPRINT=YES'
        
  rc = SysCreateObject(Type, Title, Folder, Parms)

  IF rc = 1 THEN
    SAY 'Desktop object created...'
  ELSE
    SAY 'Desktop creation failed - rc =' rc
END

SAY 'Installation complete!'


