/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public final class Transaction
implements Comparable {
    public String db_Date = "";
    public String displayDate = "";
    public String db_Number = "(new)";
    public String db_Payee = "";
    public String db_Address = "";
    public String db_Memo = "";
    public double db_Amount = 0.0;
    public boolean db_Cleared = false;
    public String db_Category = "";
    public String db_Splits = "";
    public double db_Price = 1.0;
    public double db_Shares = 0.0;
    public double db_Commission = 0.0;
    public String db_Security = "";
    private long time = -1L;
    public double balance = 0.0;
    public double shareBalance = 0.0;
    public Vector splits = null;
    public String s_cleared;
    public String srchTag = "";
    public String recipSrchTag = "";
    int acType;
    Account acc = null;
    PLCash parent = null;

    public Transaction(PLCash pLCash) {
        this.parent = pLCash;
        this.time = this.parent.commonCode.getNormalizedTime();
        this.initializeDatesFromTime();
    }

    public Transaction(PLCash pLCash, Transaction transaction) {
        this.parent = pLCash;
        this.time = this.parent.commonCode.getNormalizedTime();
        this.db_Date = String.valueOf(transaction.db_Date);
        this.displayDate = String.valueOf(transaction.displayDate);
        this.db_Number = String.valueOf(transaction.db_Number);
        this.db_Payee = String.valueOf(transaction.db_Payee);
        this.db_Address = String.valueOf(transaction.db_Address);
        this.db_Memo = String.valueOf(transaction.db_Memo);
        this.db_Amount = transaction.db_Amount;
        this.db_Cleared = transaction.db_Cleared;
        this.db_Category = String.valueOf(transaction.db_Category);
        this.db_Splits = String.valueOf(transaction.db_Splits);
        this.acc = transaction.acc;
        this.parseSplits(this.db_Splits);
        this.db_Price = transaction.db_Price;
        this.db_Shares = transaction.db_Shares;
        this.db_Commission = transaction.db_Commission;
        this.db_Security = String.valueOf(transaction.db_Security);
        this.time = transaction.time;
        this.balance = transaction.balance;
        this.shareBalance = transaction.shareBalance;
        this.s_cleared = transaction.s_cleared;
        this.srchTag = String.valueOf(transaction.srchTag);
        this.recipSrchTag = String.valueOf(transaction.recipSrchTag);
        this.acType = transaction.acType;
        this.parent = transaction.parent;
    }

    public Transaction(PLCash pLCash, Account account) {
        this.parent = pLCash;
        this.time = this.parent.commonCode.getNormalizedTime();
        this.acc = account;
    }

    public Transaction(PLCash pLCash, Account account, long l, String string, String string2, double d) {
        this.parent = pLCash;
        this.time = l;
        this.db_Amount = d;
        this.db_Category = string;
        this.db_Memo = string2;
        int n = 0;
        if (account != null) {
            n = account.type;
        }
        this.init(account, n);
    }

    public Transaction(PLCash pLCash, Account account, String string, long l, String string2, String string3, double d) {
        this.parent = pLCash;
        this.db_Payee = string;
        this.time = l;
        this.db_Amount = d;
        this.db_Category = string2;
        this.db_Memo = string3;
        int n = 0;
        if (account != null) {
            n = account.type;
        }
        this.init(account, n);
    }

    public Transaction(PLCash pLCash, Account account, int n) {
        this.parent = pLCash;
        this.time = this.parent.commonCode.getNormalizedTime();
        this.init(account, n);
    }

    public Transaction(PLCash pLCash, Account account, long l, String string) {
        this.parent = pLCash;
        this.time = l;
        String[] stringArray = string.split("\\\\t", 3);
        if (stringArray.length == 3) {
            this.db_Category = stringArray[0];
            this.db_Amount = this.parent.commonCode.getDoubleUSLocale(stringArray[1]);
            this.db_Memo = stringArray[2];
        }
        int n = account != null ? account.type : -1;
        this.init(account, n);
    }

    public Transaction(PLCash pLCash, Account account, long l, String string, double d, String string2) {
        this.parent = pLCash;
        this.time = l;
        this.db_Category = string;
        this.db_Amount = d;
        this.db_Memo = string2;
        this.init(account, account.type);
    }

    public void init(Account account, int n) {
        this.acc = account;
        this.acType = n;
        this.initializeDatesFromTime();
        this.updateKey();
        this.parseSplits(this.db_Splits);
    }

    public double getTransactionAmount() {
        return this.db_Amount;
    }

    public void setTime(long l) {
        this.time = l;
        this.initializeDatesFromTime();
    }

    public long getTime() {
        return this.time;
    }

    public String getPayee() {
        return this.db_Payee;
    }

    public Account getAccount() {
        return this.acc;
    }

    public void timeForDbDate() {
        this.time = this.parent.commonCode.timeForDbDate(this.db_Date);
    }

    public void initializeDatesFromTime() {
        this.db_Date = this.parent.commonCode.dbDateForTime(this.time);
        this.displayDate = this.parent.commonCode.displayDateForTime(this.time);
    }

    public void addSplit(Transaction transaction, boolean bl, boolean bl2) {
        if (this.splits == null) {
            this.splits = new Vector();
        }
        this.splits.add(transaction);
        if (transaction.acc == null) {
            // empty if block
        }
        if (bl2) {
            this.parent.commonCode.createRequiredLinks(this.parent.accountHandler.dataMap, this.acc, transaction);
        }
        if (bl) {
            this.recomputeSplits();
        }
    }

    public void deleteSplit(Transaction transaction, boolean bl, boolean bl2) {
        if (this.splits != null && transaction != null) {
            if (bl2) {
                this.parent.commonCode.deleteExistingLinks(this.parent.accountHandler.dataMap, this.acc, transaction);
            }
            this.splits.remove(transaction);
            if (this.splits.size() == 0) {
                this.splits = null;
            }
            if (bl) {
                this.recomputeSplits();
            }
        }
    }

    public void recomputeSplits() {
        Transaction.recomputeSumOfSplits(this);
        this.db_Splits = this.createEscapedSplitsString();
    }

    public static void recomputeSumOfSplits(Transaction transaction) {
        double d = 0.0;
        if (transaction.splits != null && transaction.splits.size() > 0) {
            for (int i = 0; i < transaction.splits.size(); ++i) {
                d += ((Transaction)transaction.splits.get((int)i)).db_Amount;
            }
        }
        transaction.db_Amount = d;
        transaction.updateKey();
    }

    public Vector getSplits() {
        return this.splits;
    }

    public String createEscapedSplitsString() {
        if (this.splits == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.splits.size();
        for (int i = 0; i < n; ++i) {
            Transaction transaction = (Transaction)this.splits.get(i);
            stringBuffer.append(transaction.makeEscapedDatabaseRecord());
            if (i >= n - 1) continue;
            stringBuffer.append("\\n");
        }
        return stringBuffer.toString();
    }

    public String makeEscapedDatabaseRecord() {
        return this.db_Category + "\\t" + this.db_Amount + "\\t" + this.db_Memo;
    }

    public String toString() {
        return this.db_Date + "\t" + this.db_Category + "\t" + this.db_Payee + "\t" + this.db_Amount + "\t" + this.db_Memo;
    }

    public void updateKey() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.db_Category);
        stringBuffer.append("_" + this.parent.commonCode.getDollarCentString(-this.db_Amount, false));
        this.srchTag = stringBuffer.toString();
        if (this.acc != null) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("[" + this.acc.db_Name + "]");
            stringBuffer2.append("_" + this.parent.commonCode.getDollarCentString(this.db_Amount, false));
            this.recipSrchTag = stringBuffer2.toString();
        }
        if (this.splits != null) {
            for (int i = 0; i < this.splits.size(); ++i) {
                Transaction transaction = (Transaction)this.splits.get(i);
                transaction.updateKey();
            }
        }
    }

    public String getSrchTag() {
        return this.srchTag;
    }

    public String getRecipSrchTag() {
        return this.recipSrchTag;
    }

    public void parseSplits(String string) {
        boolean bl = false;
        String[] stringArray = string.split("\\\\n");
        double d = 0.0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() <= 0) continue;
            Transaction transaction = new Transaction(this.parent, this.acc, this.time, stringArray[i]);
            this.addSplit(transaction, false, false);
            d += transaction.db_Amount;
            bl = true;
        }
        if (bl) {
            this.db_Amount = d;
        }
    }

    public int compareTo(Object object) {
        long l = this.time - ((Transaction)object).time;
        return l > 0L ? 1 : (l < 0L ? -1 : 0);
    }
}

