/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public final class ReconcileForm
extends JPanel {
    PLCash parent;
    Account account;
    double debits = 0.0;
    double credits = 0.0;
    long openTime;
    double openBalance = 0.0;
    long endTime = -1L;
    double endBalance = 0.0;
    double cleared;
    double diff = 0.0;
    private JPanel bottomPanel;
    private JPanel centerPanel;
    private JTextField clearedTextField;
    private JPanel creditsPanel;
    private JPanel debitsPanel;
    private JTextField diffTextField;
    private JTextField endBalanceTextField;
    private JTextField endDateTextField;
    private JButton helpButton;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JTextField openBalanceTextField;
    private JTextField openDateTextField;
    private JCheckBox showAllCheckBox;
    private JButton startButton;
    private JPanel topPanel;

    public ReconcileForm(PLCash pLCash, Account account) {
        this.parent = pLCash;
        this.account = account;
        this.initComponents();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReconcileForm.this.doFirst();
                ReconcileForm.this.startRecon();
            }
        });
    }

    private void doFirst() {
        this.timeToField(this.account.db_StatementBalanceDate, this.openDateTextField);
        this.numToField(this.account.db_StatementBalance, this.openBalanceTextField);
        this.timeToField(new Date().getTime(), this.endDateTextField);
    }

    private void refreshDisp() {
        this.numToField(this.cleared, this.clearedTextField);
        this.numToField(this.diff, this.diffTextField);
        Color color = Color.white;
        if (this.parent.commonCode.nonZero(this.diff)) {
            color = this.diff < 0.0 ? this.parent.programValues.db_LightRedColor : this.parent.programValues.db_LightGreenColor;
        }
        this.diffTextField.setBackground(color);
    }

    public void processChange() {
        boolean bl = this.getShowAllFlag();
        this.credits = ((ReconcileTable)this.creditsPanel).processChange();
        this.debits = ((ReconcileTable)this.debitsPanel).processChange();
        this.cleared = this.credits + this.debits;
        this.diff = bl ? this.endBalance - this.cleared : this.endBalance - this.openBalance - this.cleared;
        if (!this.parent.commonCode.nonZero(this.diff)) {
            this.parent.beep();
        }
        this.refreshDisp();
    }

    private void startRecon() {
        this.tableSetup();
        this.openBalance = this.fieldToNum(this.openBalanceTextField);
        this.openTime = this.fieldToTime(this.openDateTextField);
        this.endBalance = this.fieldToNum(this.endBalanceTextField);
        this.endTime = this.fieldToTime(this.endDateTextField);
        this.numToField(this.openBalance, this.openBalanceTextField);
        this.numToField(this.endBalance, this.endBalanceTextField);
        this.timeToField(this.openTime, this.openDateTextField);
        this.timeToField(this.endTime, this.endDateTextField);
        this.processChange();
    }

    private void tableSetup() {
        ((ReconcileTable)this.creditsPanel).setup();
        ((ReconcileTable)this.debitsPanel).setup();
    }

    private void cancelRecon() {
        this.parent.beep();
        int n = JOptionPane.showConfirmDialog(this.parent, "Do you want to cancel this reconciliation?", "Cancel reconciliation", 0);
        if (n == 0) {
            this.parent.displayHandler.closeTab(this);
        }
    }

    private void finishRecon() {
        if (this.parent.commonCode.nonZero(this.diff)) {
            this.parent.beep();
            JOptionPane.showMessageDialog(this.parent, "If you want to abandon an Incomplete reconciliation, press \"Cancel\"", "Not Balanced", 1);
        } else {
            ((ReconcileTable)this.creditsPanel).commitChanges();
            ((ReconcileTable)this.debitsPanel).commitChanges();
            this.account.setDataChanged();
            this.account.db_StatementBalance = this.endBalance;
            this.account.db_StatementBalanceDate = this.endTime;
            this.parent.displayHandler.closeTab(this);
        }
    }

    private double fieldToNum(JTextField jTextField) {
        return this.parent.commonCode.parseCurrencyDollarCentString(jTextField.getText());
    }

    private long fieldToTime(JTextField jTextField) {
        return this.parent.commonCode.timeForDisplayDateLenient(jTextField.getText());
    }

    private void timeToField(long l, JTextField jTextField) {
        jTextField.setText(this.parent.commonCode.displayDateForTime(l));
    }

    private void numToField(double d, JTextField jTextField) {
        jTextField.setText(this.parent.commonCode.getCurrencyDollarCentString(d, false));
    }

    public boolean getShowAllFlag() {
        return this.showAllCheckBox.isSelected();
    }

    private void watchForLF(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n') {
            this.startRecon();
        }
    }

    private void help_reconcile() {
        this.parent.launchHelp("AdvancedOperations.html#Account_Reconciliation");
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        this.centerPanel = new JPanel();
        this.debitsPanel = new ReconcileTable(this.parent, this.account, this, false);
        this.creditsPanel = new ReconcileTable(this.parent, this.account, this, true);
        this.bottomPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.openBalanceTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.endBalanceTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.openDateTextField = new JTextField();
        this.endDateTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.clearedTextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.diffTextField = new JTextField();
        this.startButton = new MyJButton();
        this.jButton2 = new MyJButton();
        this.jButton3 = new MyJButton();
        this.showAllCheckBox = new JCheckBox();
        this.helpButton = new MyJButton();
        this.setLayout(new BorderLayout());
        this.add((Component)this.topPanel, "North");
        this.centerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.centerPanel.add((Component)this.debitsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.centerPanel.add((Component)this.creditsPanel, gridBagConstraints);
        this.add((Component)this.centerPanel, "Center");
        this.bottomPanel.setLayout(new GridBagLayout());
        this.jLabel1.setText("Opening Balance");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.openBalanceTextField.setHorizontalAlignment(4);
        this.openBalanceTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                ReconcileForm.this.openBalanceTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.openBalanceTextField, gridBagConstraints);
        this.jLabel2.setText("Ending Balance");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.endBalanceTextField.setHorizontalAlignment(4);
        this.endBalanceTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                ReconcileForm.this.endBalanceTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.endBalanceTextField, gridBagConstraints);
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("Amount");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText("Date");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.jLabel4, gridBagConstraints);
        this.openDateTextField.setHorizontalAlignment(4);
        this.openDateTextField.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                ReconcileForm.this.openDateTextFieldMouseWheelMoved(mouseWheelEvent);
            }
        });
        this.openDateTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                ReconcileForm.this.openDateTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.openDateTextField, gridBagConstraints);
        this.endDateTextField.setHorizontalAlignment(4);
        this.endDateTextField.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                ReconcileForm.this.endDateTextFieldMouseWheelMoved(mouseWheelEvent);
            }
        });
        this.endDateTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                ReconcileForm.this.endDateTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.endDateTextField, gridBagConstraints);
        this.jLabel5.setText("Cleared Balance");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.jLabel5, gridBagConstraints);
        this.clearedTextField.setEditable(false);
        this.clearedTextField.setHorizontalAlignment(4);
        this.clearedTextField.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.clearedTextField, gridBagConstraints);
        this.jLabel6.setText("Difference");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.jLabel6, gridBagConstraints);
        this.diffTextField.setEditable(false);
        this.diffTextField.setHorizontalAlignment(4);
        this.diffTextField.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.diffTextField, gridBagConstraints);
        this.startButton.setText("Start");
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReconcileForm.this.startButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.bottomPanel.add((Component)this.startButton, gridBagConstraints);
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReconcileForm.this.jButton2ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        this.bottomPanel.add((Component)this.jButton2, gridBagConstraints);
        this.jButton3.setText("Done");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReconcileForm.this.jButton3ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        this.bottomPanel.add((Component)this.jButton3, gridBagConstraints);
        this.showAllCheckBox.setText("Show all transactions");
        this.showAllCheckBox.setToolTipText("Sometimes necessary to sort out difficulties");
        this.showAllCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReconcileForm.this.showAllCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.bottomPanel.add((Component)this.showAllCheckBox, gridBagConstraints);
        this.helpButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Help.png")));
        this.helpButton.setText("Help");
        this.helpButton.setToolTipText("Provide context-sensitive help");
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReconcileForm.this.helpButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.bottomPanel.add((Component)this.helpButton, gridBagConstraints);
        this.add((Component)this.bottomPanel, "South");
    }

    private void helpButtonActionPerformed(ActionEvent actionEvent) {
        this.help_reconcile();
    }

    private void endDateTextFieldKeyTyped(KeyEvent keyEvent) {
        this.watchForLF(keyEvent);
        this.parent.commonCode.handleDateFieldKey(keyEvent, true);
    }

    private void openDateTextFieldKeyTyped(KeyEvent keyEvent) {
        this.watchForLF(keyEvent);
        this.parent.commonCode.handleDateFieldKey(keyEvent, true);
    }

    private void endBalanceTextFieldKeyTyped(KeyEvent keyEvent) {
        this.watchForLF(keyEvent);
    }

    private void openBalanceTextFieldKeyTyped(KeyEvent keyEvent) {
        this.watchForLF(keyEvent);
    }

    private void showAllCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.startRecon();
    }

    private void jButton3ActionPerformed(ActionEvent actionEvent) {
        this.finishRecon();
    }

    private void jButton2ActionPerformed(ActionEvent actionEvent) {
        this.cancelRecon();
    }

    private void startButtonActionPerformed(ActionEvent actionEvent) {
        this.startRecon();
    }

    private void openDateTextFieldMouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.parent.commonCode.handleDateFieldMouseWheel(mouseWheelEvent, true);
    }

    private void endDateTextFieldMouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.parent.commonCode.handleDateFieldMouseWheel(mouseWheelEvent, true);
    }
}

