/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public final class MemorizedItem {
    public String Payee = "";
    public String Type = "";
    public double Amount = 0.0;
    public boolean Cleared = false;
    public String Memo = "";
    public String Address = "";
    public String Category = "";
    public String Splits = "";
    private Vector splits = null;
    PLCash parent;

    public MemorizedItem(PLCash pLCash) {
        this.parent = pLCash;
    }

    public MemorizedItem(PLCash pLCash, String string) {
        this.parent = pLCash;
        String[] stringArray = string.split("\\\\t", 3);
        if (stringArray.length == 3) {
            this.Category = stringArray[0];
            this.Amount = 0.0;
            try {
                this.Amount = this.parent.commonCode.getDouble(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            this.Memo = stringArray[2];
        }
    }

    public MemorizedItem(PLCash pLCash, String string, String string2, double d) {
        this.parent = pLCash;
        this.Category = string;
        this.Memo = string2;
        this.Amount = d;
    }

    public MemorizedItem(PLCash pLCash, Transaction transaction, String string) {
        this.parent = pLCash;
        this.Type = string;
        this.Payee = transaction.db_Payee;
        this.Amount = transaction.db_Amount;
        this.Cleared = transaction.db_Cleared;
        this.Memo = transaction.db_Memo;
        this.Address = transaction.db_Address;
        this.Category = transaction.db_Category;
        if (transaction.splits != null) {
            this.splits = new Vector();
            for (int i = 0; i < transaction.splits.size(); ++i) {
                Transaction transaction2 = (Transaction)transaction.splits.get(i);
                this.splits.add(new MemorizedItem(this.parent, transaction2, string));
            }
            this.Splits = this.createEscapedSplitsString();
        }
    }

    public void init() {
        this.parseSplits(this.Splits);
    }

    public boolean renameCategory(String string, String string2) {
        boolean bl = false;
        if (this.Category.equals(string)) {
            this.Category = String.valueOf(string2);
            bl = true;
        }
        if (this.splits != null) {
            boolean bl2 = false;
            for (int i = 0; i < this.splits.size(); ++i) {
                MemorizedItem memorizedItem = (MemorizedItem)this.splits.get(i);
                bl2 = bl2 || memorizedItem.renameCategory(string, string2);
            }
            if (bl2) {
                bl = bl || bl2;
                this.Splits = this.createEscapedSplitsString();
            }
        }
        return bl;
    }

    public void addSplit(MemorizedItem memorizedItem, boolean bl) {
        if (this.splits == null) {
            this.splits = new Vector();
        }
        this.splits.add(memorizedItem);
        if (bl) {
            this.Splits = this.createEscapedSplitsString();
        }
    }

    public Vector getSplits() {
        return this.splits;
    }

    public String makeEscapedDatabaseRecord() {
        return this.Category + "\\t" + this.Amount + "\\t" + this.Memo;
    }

    public String createEscapedSplitsString() {
        if (this.splits == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.splits.size();
        for (int i = 0; i < n; ++i) {
            MemorizedItem memorizedItem = (MemorizedItem)this.splits.get(i);
            stringBuffer.append(memorizedItem.makeEscapedDatabaseRecord());
            if (i >= n - 1) continue;
            stringBuffer.append("\\n");
        }
        return stringBuffer.toString();
    }

    public void parseSplits(String string) {
        boolean bl = false;
        String[] stringArray = string.split("\\\\n");
        double d = 0.0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() <= 0) continue;
            MemorizedItem memorizedItem = new MemorizedItem(this.parent, stringArray[i]);
            this.addSplit(memorizedItem, false);
            d += memorizedItem.Amount;
            bl = true;
        }
        if (bl) {
            this.Amount = d;
        }
    }
}

