/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;

public final class CurrencyValue {
    private Object valueClass;
    public double defaultLinkDouble;
    private Field value;
    private String s_value = "";
    private String s_combined;
    private String s_abs_combined;
    private String s_oppSign;
    private String s_cents = "";
    private String s_dollars = "";
    private String s_abs_dollars = "";
    DecimalFormat dollarForm;
    int places = 2;
    String decimalSep;
    String groupSep;
    double negVal = -0.01;
    PLCash parent;

    public CurrencyValue(PLCash pLCash) {
        this.parent = pLCash;
        this.init();
    }

    public CurrencyValue(PLCash pLCash, int n) {
        this.parent = pLCash;
        this.places = n;
        this.init();
    }

    public CurrencyValue(PLCash pLCash, double d) {
        this.init();
        this.setValue(d);
    }

    public CurrencyValue(PLCash pLCash, String string) {
        this.parent = pLCash;
        this.init();
        this.setValue(string);
    }

    private void init() {
        this.dollarForm = (DecimalFormat)NumberFormat.getCurrencyInstance();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormat().getDecimalFormatSymbols();
        decimalFormatSymbols.setCurrencySymbol("");
        this.decimalSep = "" + decimalFormatSymbols.getDecimalSeparator();
        this.groupSep = "" + decimalFormatSymbols.getGroupingSeparator();
        if (this.decimalSep.equals(".")) {
            this.decimalSep = "\\.";
        }
        decimalFormatSymbols.setCurrencySymbol("");
        this.dollarForm.setDecimalFormatSymbols(decimalFormatSymbols);
        this.dollarForm.setMinimumFractionDigits(this.places);
        this.link(this, "defaultLinkDouble");
    }

    public void link(Object object, String string) {
        try {
            this.valueClass = object;
            this.value = object.getClass().getField(string);
            this.setValue(this.getValue());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
    }

    public void setValue(String string) {
        if (string == null || string.equals("")) {
            string = "0";
        }
        string = string.replaceAll(this.groupSep, "");
        this.setValue(this.parent.commonCode.getDouble(string));
    }

    public void setValue(double d) {
        try {
            this.value.set(this.valueClass, new Double(d));
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        this.s_value = String.valueOf(d);
        this.s_abs_combined = this.dollarForm.format(Math.abs(d));
        this.s_oppSign = (d >= -0.005 ? "-" : "") + this.s_abs_combined;
        this.s_combined = (d < -0.005 ? "-" : "") + this.s_abs_combined;
        String[] stringArray = this.s_combined.split(this.decimalSep);
        this.s_dollars = stringArray[0].trim();
        this.s_cents = stringArray[1].trim();
        stringArray = this.s_abs_combined.split(this.decimalSep);
        this.s_abs_dollars = stringArray[0].trim();
    }

    private String addColors(String string) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = bl = this.getValue() <= this.negVal;
        if (bl) {
            stringBuffer.append("<html><font color=\"#ff0000\">");
        }
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.append("</font></html>");
        }
        return stringBuffer.toString();
    }

    public double getValue() {
        double d = 0.0;
        try {
            d = (Double)this.value.get(this.valueClass);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return d;
    }

    public boolean isNegative() {
        return this.getValue() < -0.005;
    }

    public String toString() {
        return this.s_value;
    }

    public String getDollarsCentsOppSignString() {
        return this.s_oppSign;
    }

    public String getDollarsCentsString() {
        return this.s_combined;
    }

    public String getAbsDollarsCentsString() {
        return this.s_abs_combined;
    }

    public String getCentString() {
        return this.s_cents;
    }

    public String getDollarString() {
        return this.s_dollars;
    }

    public String getAbsDollarString() {
        return this.s_abs_dollars;
    }
}

