/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.io.File;
import java.util.Date;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

public final class AccountHandler
extends EditableList {
    String fileName = "accountList.tsv";
    TreeMap fileNameMap;
    boolean[] allowEditList = new boolean[]{false, false, false, false, true, false, true, true, true, true, true, false, false, false, false, true};

    public AccountHandler(PLCash pLCash) {
        super(pLCash);
        this.fileNameMap = new TreeMap();
    }

    public void displayData() {
        this.displayMap("Accounts", this, "db_");
    }

    public void saveOpenAccountList() {
        String[] stringArray = this.parent.displayHandler.getOpenAccountList();
        this.parent.programValues.db_OpenAccounts = this.parent.commonCode.join(stringArray, "\t");
        this.parent.programValues.db_LastViewedTab = this.parent.displayHandler.getSelectedTab();
    }

    public void openSavedAccountList() {
        String[] stringArray = this.parent.programValues.db_OpenAccounts.split("\t");
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                Account account = (Account)this.dataMap.get(stringArray[i]);
                if (account == null) continue;
                this.parent.displayHandler.addTest(account);
            }
            this.parent.displayHandler.setSelectedTab(this.parent.programValues.db_LastViewedTab);
        }
    }

    public void writeAllTSV(String string) {
        this.writeAccountIndexTSV(string);
        this.parent.categoryHandler.writeTSV(string);
        this.parent.memHandler.writeTSV(string);
        this.parent.securityHandler.writeTSV(string);
        this.parent.pricesHandler.writeTSV(string);
        this.parent.securityHandler.writeTSV(string);
        this.writeAccounts();
    }

    private void writeAccounts() {
        String[] stringArray = this.getAccountFileNames();
        for (int i = 0; i < stringArray.length; ++i) {
            Account account = (Account)this.fileNameMap.get(stringArray[i]);
            if (account == null) continue;
            account.writeTSV();
        }
    }

    public int indexForAccount(Account account) {
        int n;
        String[] stringArray = this.getAccountNames();
        for (n = 0; n < stringArray.length && !account.db_Name.equals(stringArray[n]); ++n) {
        }
        if (n == stringArray.length) {
            n = -1;
        }
        return n;
    }

    public void writeAccountIndexTSV(String string) {
        this.dataChanged = true;
        this.writeTSV(string, this.fileName, this.dataMap, (Object)new Account(this.parent), "db_");
    }

    public void writeAccountIndexTSV() {
        this.dataChanged = true;
        this.writeTSV(this.parent.programValues.db_DataFilePath, this.fileName, this.dataMap, (Object)new Account(this.parent), "db_");
    }

    public double getAccountBalance(String string) {
        double d = 0.0;
        Account account = this.getAccountByFileName(string);
        if (account != null) {
            d = account.db_Balance;
        }
        return d;
    }

    public Account getAccountByName(String string) {
        return (Account)this.dataMap.get(string);
    }

    public Account getAccountByFileName(String string) {
        return (Account)this.fileNameMap.get(string);
    }

    public String[] getAccountNames() {
        return this.dataMap.keySet().toArray(new String[0]);
    }

    public String[] getAccountFileNames() {
        return this.fileNameMap.keySet().toArray(new String[0]);
    }

    public Account getAccount(int n) {
        String[] stringArray = this.getAccountNames();
        if (n < 0 || n >= stringArray.length) {
            return null;
        }
        return this.getAccountByName(stringArray[n]);
    }

    public Account[] getAccountList(boolean bl) {
        String[] stringArray = this.parent.accountHandler.getAccountFileNames();
        Vector<Account> vector = new Vector<Account>();
        for (int i = 0; i < stringArray.length; ++i) {
            Account account = this.getAccountByFileName(stringArray[i]);
            if (!bl && !account.db_ShowInList) continue;
            vector.add(account);
        }
        return vector.toArray(new Account[0]);
    }

    public void addAccount(Account account, String string) {
        account.db_Name = account.db_Name.trim();
        if (this.getAccountByName(account.db_Name) != null) {
            this.parent.beep();
            JOptionPane.showMessageDialog(this.parent, "The account name you have chosen\nis already in use. Please choose a\ndifferent name.", "Duplicate Account Names", 2);
            return;
        }
        if (account.db_Name == null || account.db_Name.length() == 0) {
            return;
        }
        account.createAccountFileName();
        this.addItem(account.db_Name, account);
        this.initializeAccount(account, string);
    }

    public void removeAccount(String string) {
        this.deleteItem(string);
    }

    @Override
    public void deleteItem(String string) {
        Object object = this.getDataObject(string);
        if (object instanceof Account) {
            Account account = (Account)object;
            super.deleteItem(string);
            this.fileNameMap.remove(account.db_FileName);
            this.parent.displayHandler.closeTab(account.accountDisplay);
            this.parent.accountPanel.setupTable();
        } else {
            super.deleteItem(string);
        }
    }

    public Account addAccount(String string, Account account, String string2) {
        string = string.trim();
        account.db_Name = account.db_Name.trim();
        Account account2 = this.getAccountByName(string);
        if (account2 != null && account2 != account) {
            account2.getTransactionList().addAll(account.getTransactionList());
            account2.whenDataChanged();
            return account2;
        }
        if (account.db_FileName == null || account.db_FileName.length() == 0) {
            if (account.type < 0 || string.length() == 0 || account.db_Name.length() == 0) {
                return null;
            }
            account.db_FileName = Account.createAccountFileName(account.type, account.db_Name);
            this.addItem(string, account);
            this.initializeAccount(account, string2);
        }
        return account;
    }

    @Override
    public void addItem(String string, Object object) {
        Account account = null;
        if (object instanceof Account) {
            account = (Account)object;
            if (account.db_Name == null || account.db_Name.length() == 0) {
                return;
            }
            if (account.db_FileName == null || account.db_FileName.length() == 0) {
                account.createAccountFileName();
            }
            this.fileNameMap.put(account.db_FileName, account);
        }
        super.addItem(string, object);
    }

    public void readAllTSV(String string) {
        String string2 = string + "/" + this.fileName;
        this.parent.dataFileManager.readDataTable(string2, this.dataMap, (Object)new Account(this.parent), "db_");
        this.initializeAccounts(string);
        this.parent.categoryHandler.readTSV(string);
        this.parent.memHandler.readTSV(string);
        this.parent.securityHandler.readTSV(string);
        this.parent.pricesHandler.readTSV(string);
        this.parent.securityHandler.readTSV(string);
    }

    private void initializeAccounts(String string) {
        String[] stringArray = this.getAccountNames();
        for (int i = 0; i < stringArray.length; ++i) {
            Account account = (Account)this.dataMap.get(stringArray[i]);
            this.initializeAccount(account, string);
            this.fileNameMap.put(account.db_FileName, account);
        }
    }

    public void initializeAccount(Account account, String string) {
        account.setParent(this.parent);
        account.filePath = string;
        if (account.db_Type.length() > 0) {
            account.setType(account.db_Type);
            account.db_FileName = Account.createAccountFileName(account.type, account.db_Name);
        }
    }

    public void crossReferenceAll() {
        String[] stringArray = this.getAccountNames();
        for (int i = 0; i < stringArray.length; ++i) {
            Account account = (Account)this.dataMap.get(stringArray[i]);
            this.crossReferenceAccount(account);
        }
    }

    public void crossReferenceAccount(Account account) {
        Vector vector = account.getTransactionList();
        for (int i = 0; i < vector.size(); ++i) {
            Transaction transaction = (Transaction)vector.get(i);
            Vector vector2 = transaction.getSplits();
            if (vector2 != null && vector2.size() > 0) {
                for (int j = 0; j < vector2.size(); ++j) {
                    Transaction transaction2 = (Transaction)vector2.get(j);
                    if (this.processTransaction(this.dataMap, account, transaction2) != null) continue;
                    this.handleError(account, transaction2);
                }
                continue;
            }
            if (this.processTransaction(this.dataMap, account, transaction) != null) continue;
            this.handleError(account, transaction);
        }
    }

    public TransactionLocation processTransaction(TreeMap treeMap, Account account, Transaction transaction) {
        if (transaction.db_Category.indexOf("[") != 0) {
            return null;
        }
        return this.parent.commonCode.locateTransaction(treeMap, account, transaction, this.parent.commonCode.ACTION_DO_NOTHING);
    }

    public void handleError(Account account, Transaction transaction) {
        String string = transaction.displayDate + ":" + transaction.db_Payee + ":" + transaction.db_Amount + ":" + transaction.db_Category;
        JOptionPane.showMessageDialog(this.parent, "Cannot find matching link in account: " + account.db_Name + " transaction: " + string, "Link resolve fail", 1);
    }

    @Override
    public void setupComboBox(JComboBox jComboBox, String string) {
        String[] stringArray = this.getAccountNames();
        for (int i = 0; i < stringArray.length; ++i) {
            jComboBox.addItem("[" + stringArray[i] + "]");
        }
        if (string != null && string.length() > 0) {
            jComboBox.setSelectedItem(string);
        }
        jComboBox.setPreferredSize(new Dimension(32, 24));
        jComboBox.setMinimumSize(new Dimension(32, 24));
    }

    @Override
    public boolean allowEditRecords(int n) {
        if (n < this.allowEditList.length) {
            return this.allowEditList[n];
        }
        return false;
    }

    @Override
    public Object getDataObject(String string) {
        return this.dataMap.get(string);
    }

    @Override
    public Object getDataObject(int n) {
        String[] stringArray = this.getAccountNames();
        return this.dataMap.get(stringArray[n]);
    }

    @Override
    public boolean allowCreateDeleteRecords() {
        return false;
    }

    public void setAccountInfoFromQIFData(Account account, TreeMap treeMap) {
        account.db_SubType = this.parent.commonCode.safeTreeGetDefault(treeMap, "T", account.db_SubType);
        account.db_Name = this.parent.commonCode.safeTreeGetDefault(treeMap, "N", account.db_Name);
        if (account.db_Name.length() > 0 && account.type >= 0) {
            account.db_FileName = Account.createAccountFileName(account.type, account.db_Name);
        }
        account.db_Description = this.parent.commonCode.safeTreeGetDefault(treeMap, "D", account.db_Description);
        account.db_CreditLimit = this.parent.commonCode.defaultFailParseDouble(this.parent.commonCode.safeTreeGet(treeMap, "L"), account.db_CreditLimit);
        account.db_StatementBalanceDate = this.parent.commonCode.defaultFailParseLong(this.parent.commonCode.safeTreeGet(treeMap, "/"), account.db_StatementBalanceDate);
        account.db_StatementBalance = this.parent.commonCode.defaultFailParseDouble(this.parent.commonCode.safeTreeGet(treeMap, "$"), account.db_StatementBalance);
        this.dataChanged = true;
    }

    public boolean deleteAccountPrompt(Account account) {
        boolean bl = false;
        long l = new Date().getTime();
        String string = "Deleting an account is a very serious action.\nIf the account to be deleted has links to other accounts,\nthose links will be removed, and the account balances\nwill therefore change. This could create a mess that might\ntake weeks to sort out. And there is no \"Undo\" for this action.\n\nThink hard before committing to this act, and note the presence of\na \"Cancel\" button below.\n\nDo you want to delete account \"" + account.db_Name + "\"?";
        Object[] objectArray = new String[]{"Yes", "No", "Do I look crazy?", "Forget it!", "Cancel"};
        int n = JOptionPane.showOptionDialog(this.parent, string, "Delete Account", -1, 2, null, objectArray, objectArray[4]);
        long l2 = new Date().getTime();
        long l3 = l2 - l;
        if (n == 0 && l3 < 10000L) {
            String string2 = this.parent.commonCode.getDollarCentString((double)l3 / 1000.0, false);
            JOptionPane.showMessageDialog(this.parent, "Whoa there! You took only " + string2 + " seconds to\ndecide to erase your \"" + account.db_Name + "\" account.\nI hate to be annoying, but could you please think\nthis momentous decision over a little longer (hint:\nat least ten seconds)? Please close this harmless dialog,\ngo back and think about your decision again.", "Haste makes waste error", 1);
            return false;
        }
        if (n == 0) {
            this.deleteAccount(account);
            bl = true;
        }
        return bl;
    }

    public boolean renameAccountPrompt(Account account) {
        boolean bl = false;
        String string = "Renaming an account is an action that should not be carried\nout lightly. All accounts are scanned for references to the old account name\nand all the references are changed. Then the account data file is renamed.\nThis is not an everyday action and not for the faint of heart, and\nthe \"Cancel\" button below is your friend.\n\nEnter a new name for account \"" + account.db_Name + "\":\n";
        String string2 = "";
        String string3 = "";
        do {
            if ((string3 = JOptionPane.showInputDialog(this.parent, string2 + string, "Rename Account", 1)) == null) continue;
            string2 = this.getDataObject(string3) != null ? "An account with the name \"" + string3 + "\"\nalready exists. Please choose another name.\n\n" : "";
        } while (!string2.equals("") && string3 != null);
        if (string3 != null && string3.length() > 0) {
            this.renameAccount(account, string3);
            bl = true;
        }
        return bl;
    }

    public void examineTransactionInRename(Transaction transaction, Account account, String string, String string2) {
        if (transaction.db_Category.equals(string)) {
            transaction.db_Category = string2;
            account.setDataChanged();
            transaction.updateKey();
        }
        if (transaction.recipSrchTag.indexOf(string) != -1) {
            transaction.updateKey();
        }
    }

    private void renameAccount(Account account, String string) {
        String string2 = account.db_Name;
        String string3 = "[" + string2 + "]";
        String string4 = "[" + string + "]";
        String[] stringArray = this.getAccountNames();
        String string5 = account.getFullFilePath();
        account.db_Name = string;
        account.createAccountFileName();
        String string6 = account.getFullFilePath();
        for (int i = 0; i < stringArray.length; ++i) {
            Account account2 = (Account)this.getDataObject(stringArray[i]);
            int n = account2.getTransactionList().size();
            for (int j = 0; j < n; ++j) {
                Transaction transaction = account2.getTransaction(j);
                this.examineTransactionInRename(transaction, account2, string3, string4);
                if (transaction.splits == null) continue;
                int n2 = transaction.splits.size();
                for (int k = 0; k < n2; ++k) {
                    Transaction transaction2 = (Transaction)transaction.splits.get(k);
                    this.examineTransactionInRename(transaction2, account2, string3, string4);
                }
            }
        }
        this.writeAccounts();
        this.renameMemorized(string3, string4);
        File file = new File(string5);
        file.renameTo(new File(string6));
        this.removeAccount(string2);
        this.addAccount(account, this.parent.programValues.db_DataFilePath);
        if (this.parent.displayHandler.hasTab(account.accountDisplay)) {
            this.parent.displayHandler.closeTab(account.accountDisplay);
            account.accountDisplay = null;
            this.parent.displayHandler.addTest(account);
        }
        this.parent.accountPanel.setupTable();
        this.writeAccountIndexTSV();
    }

    public boolean examineTransactionInDelete(Transaction transaction, String string) {
        return transaction.db_Category.equals(string);
    }

    private void deleteAccount(Account account) {
        String string = "[" + account.db_Name + "]";
        String[] stringArray = this.getAccountNames();
        String string2 = account.getFullFilePath();
        for (int i = 0; i < stringArray.length; ++i) {
            Account account2 = (Account)this.getDataObject(stringArray[i]);
            int n = account2.getTransactionList().size();
            for (int j = n - 1; j >= 0; --j) {
                Transaction transaction = account2.getTransaction(j);
                if (this.examineTransactionInDelete(transaction, string)) {
                    account2.deleteTransaction(transaction, true, false);
                    continue;
                }
                if (transaction.splits == null) continue;
                int n2 = transaction.splits.size();
                boolean bl = false;
                for (int k = n2 - 1; k >= 0; --k) {
                    Transaction transaction2 = (Transaction)transaction.splits.get(k);
                    if (!this.examineTransactionInDelete(transaction2, string)) continue;
                    transaction.deleteSplit(transaction2, true, false);
                    bl = true;
                }
                if (!bl) continue;
                account2.setDataChanged();
                account2.getBalance();
            }
        }
        File file = new File(account.getFullFilePath());
        file.delete();
        this.removeAccount(account.db_Name);
    }

    private void renameMemorized(String string, String string2) {
        this.parent.memHandler.renameLinks(string, string2);
    }
}

