/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public final class AccountDisplay
extends JPanel {
    PLCash parent = null;
    Account account = null;
    FloatingWindow floatingWindow;
    boolean oneLineMode = false;
    MyTableCellRenderer tableRenderer;
    final int MODE_BANK = 0;
    final int MODE_CCARD = 1;
    final int MODE_INVESTMENT = 2;
    int displayMode = 0;
    String[][] colNames = new String[][]{{"Date", "Num", "Payee", "Category", "Payment", "", "Deposit", "", "C", "Balance", ""}, {"Date", "Num", "Payee/cat", "Memo", "Payment", "", "Deposit", "", "C", "Balance", ""}, {"Date", "Ref", "Payee", "Category", "Charge", "", "Deposit", "", "C", "Balance", ""}, {"Date", "Ref", "Payee/cat", "Memo", "Charge", "", "Deposit", "", "C", "Balance", ""}, {"Date", "Action", "Security", "Price", "", "Shares", "", "Amount", "", "C", "Shr Bal", ""}, {"Date", "Action/memo", "Security", "Price/Xfer", "", "Shares", "", "Amount/Comm", "", "C", "Shr Bal", ""}};
    int[][] colWidths = new int[][]{{14, 11, -1, -1, 10, 2, 10, 2, 1, 11, 2}, {14, 11, -1, -1, 10, 2, 10, 2, 1, 11, 2}, {14, -1, 16, -1, 2, 10, 4, 14, 2, 1, 11, 4}};
    int[][] colJustifications = new int[][]{{2, 2, 0, 0, 2, 2, 2, 2, 1, 2, 2}, {2, 2, 0, 0, 2, 2, 2, 2, 1, 2, 2}, {2, 0, 0, 2, 2, 2, 2, 2, 2, 1, 2, 2}};
    int[] colConstants = new int[]{2, 0, 4};
    private EmptyBorder tableCellBorder;
    private Font displayFont;
    private boolean scrollToBottom = false;
    private int tableRows;
    private JTable accountTable;
    private JLabel balanceWindow;
    private JMenuItem closeAllMenuItem;
    private JMenuItem closeMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenuItem editMenuItem;
    private JMenuItem goToMenuItem;
    private JSeparator jSeparator1;
    private JCheckBoxMenuItem oneLineCheckBoxMenuItem;
    private JPopupMenu popupMenu;
    private JMenuItem printChecksMenuItem;
    private JMenuItem reconcileMenuItem;
    private JMenuItem refreshMenuItem;
    private JScrollPane scrollPane;
    private JMenuItem searchMenuItem;
    private JPanel totalPanel;
    private JCheckBoxMenuItem viewTableContentsCheckBoxMenuItem;

    public AccountDisplay(Account account, PLCash pLCash, boolean bl) {
        this.parent = pLCash;
        this.account = account;
        this.scrollToBottom = bl;
        this.setBorder(new TitledBorder("Account data table: " + this.account.db_Name));
        this.tableCellBorder = new EmptyBorder(0, 2, 0, 2);
        this.initComponents();
        this.setViewTableContents(false);
        this.displayFont = new Font("Monospaced", 0, this.parent.programValues.db_TableFontSize);
        this.accountTable.setFont(this.displayFont);
        this.accountTable.getTableHeader().setFont(this.displayFont);
        this.floatingWindow = new FloatingWindow(this.displayFont);
        this.scrollPane.getVerticalScrollBar().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                AccountDisplay.this.scrollVertMouseDragged(mouseEvent);
            }
        });
        this.scrollPane.getVerticalScrollBar().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                AccountDisplay.this.scrollVertMouseReleased(mouseEvent);
            }
        });
    }

    public void setupDisplay() {
        if (this.account == null) {
            return;
        }
        this.oneLineMode = this.account.db_OneLineMode;
        this.oneLineCheckBoxMenuItem.setSelected(this.oneLineMode);
        this.displayMode = this.account.type == 3 ? 2 : (this.account.type == 2 ? 1 : 0);
        this.setupTable();
    }

    private void setupTable() {
        Vector<String> vector = new Vector<String>(Arrays.asList(this.colNames[this.displayMode * 2 + (this.oneLineMode ? 0 : 1)]));
        int n = this.account.size() + 1;
        this.tableRows = this.oneLineMode ? n : n * 2;
        DefaultTableModel defaultTableModel = new DefaultTableModel(vector, this.tableRows){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        try {
            this.tableRenderer = new MyTableCellRenderer();
            this.accountTable.setDefaultRenderer(Class.forName("java.lang.Object"), this.tableRenderer);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        this.accountTable.setModel(defaultTableModel);
        this.setColumnWidths();
        if (this.scrollToBottom) {
            int n2 = this.accountTable.getRowCount() - 1;
            this.scrollToRow(n2, n2, false);
            this.scrollToBottom = false;
        }
        this.updateLabels();
        this.accountTable.requestFocus();
    }

    public void scrollToTransaction(int n, boolean bl) {
        int n2 = this.oneLineMode ? 1 : 2;
        this.scrollToRow(n *= n2, n + n2 - 1, bl);
    }

    public void scrollToRow(int n, int n2, boolean bl) {
        int n3 = this.accountTable.getRowCount();
        int n4 = n - 3;
        int n5 = n2 + 3;
        n4 = n4 >= n3 ? n3 - 1 : n4;
        n4 = n4 < 0 ? 0 : n4;
        n5 = n5 >= n3 ? n3 - 1 : n5;
        n5 = n5 < 0 ? 0 : n5;
        Rectangle rectangle = this.accountTable.getCellRect(n4, 0, true);
        Rectangle rectangle2 = this.accountTable.getCellRect(n5, 0, true);
        rectangle.add(rectangle2);
        final Rectangle rectangle3 = new Rectangle(rectangle);
        if (rectangle3 != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccountDisplay.this.accountTable.scrollRectToVisible(rectangle3);
                }
            });
        }
        if (bl) {
            n = n >= n3 ? n3 - 1 : n;
            n = n < 0 ? 0 : n;
            n2 = n2 >= n3 ? n3 - 1 : n2;
            n2 = n2 < 0 ? 0 : n2;
            this.accountTable.setRowSelectionInterval(n, n2);
        }
    }

    private void setColumnWidths() {
        TableColumn tableColumn = null;
        Font font = this.accountTable.getFont();
        FontMetrics fontMetrics = this.accountTable.getFontMetrics(font);
        int n = fontMetrics.charWidth('W');
        int n2 = fontMetrics.getAscent() + fontMetrics.getDescent() + fontMetrics.getLeading();
        this.accountTable.setRowHeight(n2);
        for (int i = 0; i < this.colWidths[this.displayMode].length; ++i) {
            tableColumn = this.accountTable.getColumnModel().getColumn(i);
            if (this.colWidths[this.displayMode][i] <= 0) continue;
            Insets insets = this.tableCellBorder.getBorderInsets();
            int n3 = this.colWidths[this.displayMode][i] * n + insets.left * 2 + insets.right * 2;
            tableColumn.setPreferredWidth(n3);
            tableColumn.setMaxWidth(n3);
            tableColumn.setMinWidth(n3);
        }
    }

    protected void updateLabels() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        if (this.account.type == 3) {
            stringBuffer.append("Ending Market Value: ");
            stringBuffer.append(this.parent.commonCode.wrapHTMLColorOnDouble(this.account.db_Balance, this.parent.programValues.db_BoldCurrencyColor, this.parent.programValues.db_RedColor, false));
            stringBuffer.append("\t\tEnding Share Balance: ");
            stringBuffer.append(this.parent.commonCode.wrapHTMLColorOnDouble(this.account.db_ShareBalance, this.parent.programValues.db_BoldCurrencyColor, this.parent.programValues.db_RedColor, true));
        } else {
            stringBuffer.append("Ending Balance: ");
            stringBuffer.append(this.parent.commonCode.wrapHTMLColorOnDouble(this.account.db_Balance, this.parent.programValues.db_BoldCurrencyColor, this.parent.programValues.db_RedColor, false));
        }
        stringBuffer.append("</html>");
        this.balanceWindow.setText(stringBuffer.toString());
    }

    private void setOneLineMode(boolean bl) {
        this.account.db_OneLineMode = bl;
        this.oneLineMode = bl;
        this.oneLineCheckBoxMenuItem.setSelected(bl);
        this.setupDisplay();
    }

    private void changeModes() {
        this.setOneLineMode(this.oneLineCheckBoxMenuItem.getState());
    }

    String formatDisplayRow(JLabel jLabel, int n, int n2) {
        jLabel.setBackground((n & 1) == 0 ? this.parent.programValues.db_EvenRowColor : this.parent.programValues.db_OddRowColor);
        jLabel.setForeground(this.parent.programValues.db_BlackColor);
        String string = "";
        int n3 = this.oneLineMode ? n : n / 2;
        Transaction transaction = this.account.getTransaction(n3);
        int n4 = this.oneLineMode ? 0 : n & 1;
        jLabel.setHorizontalAlignment(this.colConstants[this.colJustifications[this.displayMode][n2]]);
        string = this.displayMode == 2 ? this.formatInvestmentRow(jLabel, transaction, n2, n4) : this.formatBankRow(jLabel, transaction, n2, n4);
        return string;
    }

    String formatInvestmentRow(JLabel jLabel, Transaction transaction, int n, int n2) {
        String string = "";
        if (n2 == 0) {
            switch (n) {
                case 0: {
                    string = transaction.displayDate;
                    break;
                }
                case 1: {
                    string = transaction.db_Number;
                    break;
                }
                case 2: {
                    string = transaction.db_Security;
                    break;
                }
                case 3: {
                    if (!this.parent.commonCode.nonZero(transaction.db_Price)) break;
                    string = this.parent.commonCode.getDollarString(transaction.db_Price, false);
                    break;
                }
                case 4: {
                    if (!this.parent.commonCode.nonZero(transaction.db_Price)) break;
                    string = this.parent.commonCode.getCentString(transaction.db_Price, false);
                    break;
                }
                case 5: {
                    if (!this.parent.commonCode.nonZero(transaction.db_Shares)) break;
                    string = this.parent.commonCode.getAbsDollarString(transaction.db_Shares, true);
                    break;
                }
                case 6: {
                    if (!this.parent.commonCode.nonZero(transaction.db_Shares)) break;
                    string = this.parent.commonCode.getCentString(transaction.db_Shares, true);
                    break;
                }
                case 7: {
                    if (!this.parent.commonCode.nonZero(transaction.db_Amount)) break;
                    string = this.parent.commonCode.getAbsDollarString(transaction.db_Amount, false);
                    break;
                }
                case 8: {
                    if (!this.parent.commonCode.nonZero(transaction.db_Amount)) break;
                    string = this.parent.commonCode.getCentString(transaction.db_Amount, false);
                    break;
                }
                case 9: {
                    string = transaction.db_Cleared ? "R" : "";
                    break;
                }
                case 10: {
                    this.parent.commonCode.setTableCellTextColor(jLabel, transaction.shareBalance, this.parent.programValues.db_RedColor);
                    string = this.parent.commonCode.getDollarString(transaction.shareBalance, true);
                    break;
                }
                case 11: {
                    this.parent.commonCode.setTableCellTextColor(jLabel, transaction.shareBalance, this.parent.programValues.db_RedColor);
                    string = this.parent.commonCode.getCentString(transaction.shareBalance, true);
                }
            }
        } else {
            switch (n) {
                case 1: {
                    string = transaction.db_Memo;
                    break;
                }
                case 3: {
                    if (this.oneLineMode) break;
                    if (transaction.splits != null) {
                        string = "-Split-";
                        break;
                    }
                    string = transaction.db_Category;
                    break;
                }
                case 7: {
                    if (!this.parent.commonCode.nonZero(transaction.db_Commission)) break;
                    this.parent.commonCode.setTableCellTextColor(jLabel, transaction.db_Commission, this.parent.programValues.db_RedColor);
                    string = this.parent.commonCode.getDollarString(transaction.db_Commission, false);
                    break;
                }
                case 8: {
                    if (!this.parent.commonCode.nonZero(transaction.db_Commission)) break;
                    this.parent.commonCode.setTableCellTextColor(jLabel, transaction.db_Commission, this.parent.programValues.db_RedColor);
                    string = this.parent.commonCode.getCentString(transaction.db_Commission, false);
                }
            }
        }
        return string;
    }

    String formatBankRow(JLabel jLabel, Transaction transaction, int n, int n2) {
        String string = "";
        if (n2 == 0) {
            switch (n) {
                case 0: {
                    string = transaction.displayDate;
                    break;
                }
                case 1: {
                    string = transaction.db_Number;
                    break;
                }
                case 2: {
                    string = transaction.db_Payee;
                    break;
                }
                case 3: {
                    if (!this.oneLineMode) break;
                    if (transaction.splits != null) {
                        string = "-Split-";
                        break;
                    }
                    string = transaction.db_Category;
                    break;
                }
                case 4: {
                    if (!(transaction.db_Amount < 0.0)) break;
                    string = this.parent.commonCode.getAbsDollarString(transaction.db_Amount, false);
                    break;
                }
                case 5: {
                    if (!(transaction.db_Amount < 0.0)) break;
                    string = this.parent.commonCode.getCentString(transaction.db_Amount, false);
                    break;
                }
                case 6: {
                    if (!(transaction.db_Amount > 0.0)) break;
                    string = this.parent.commonCode.getDollarString(transaction.db_Amount, false);
                    break;
                }
                case 7: {
                    if (!(transaction.db_Amount > 0.0)) break;
                    string = this.parent.commonCode.getCentString(transaction.db_Amount, false);
                    break;
                }
                case 8: {
                    string = transaction.db_Cleared ? "R" : "";
                    break;
                }
                case 9: {
                    this.parent.commonCode.setTableCellTextColor(jLabel, transaction.balance, this.parent.programValues.db_RedColor);
                    string = this.parent.commonCode.getDollarString(transaction.balance, false);
                    break;
                }
                case 10: {
                    this.parent.commonCode.setTableCellTextColor(jLabel, transaction.balance, this.parent.programValues.db_RedColor);
                    string = this.parent.commonCode.getCentString(transaction.balance, false);
                }
            }
        } else {
            switch (n) {
                case 2: {
                    if (transaction.splits != null) {
                        string = "-Split-";
                        break;
                    }
                    string = transaction.db_Category;
                    break;
                }
                case 3: {
                    string = transaction.db_Memo;
                }
            }
        }
        return string;
    }

    private void scrollVertMouseDragged(MouseEvent mouseEvent) {
        if (!this.handleMenu(mouseEvent) && !this.parent.programValues.db_ShowTableContentsWhileScrolling) {
            this.scrollPane.getViewport().setVisible(false);
            JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
            double d = this.scrollPane.getViewport().getSize().height;
            double d2 = jScrollBar.getMaximum() - jScrollBar.getVisibleAmount();
            double d3 = jScrollBar.getValue();
            double d4 = d3 / d2;
            int n = this.accountTable.rowAtPoint(new Point(0, (int)(d3 += d4 * d)));
            if (n == -1) {
                n = this.accountTable.getRowCount() - 1;
            }
            Transaction transaction = this.account.getTransaction(n /= this.oneLineMode ? 1 : 2);
            long l = transaction.getTime();
            this.floatingWindow.setMessage(this.parent.commonCode.mediumDateForTime(l));
            Point point = jScrollBar.getLocationOnScreen();
            int n2 = point.x - (this.floatingWindow.getSize().width + 8);
            int n3 = mouseEvent.getY() + point.y - this.floatingWindow.getSize().height / 2;
            this.floatingWindow.showAt(new Point(n2, n3));
        }
    }

    private void scrollVertMouseReleased(MouseEvent mouseEvent) {
        if (!this.handleMenu(mouseEvent) && !this.parent.programValues.db_ShowTableContentsWhileScrolling) {
            this.floatingWindow.hideWindow();
            this.scrollPane.getViewport().setVisible(true);
        }
    }

    private boolean handleMenu(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.viewTableContentsCheckBoxMenuItem.setSelected(this.parent.programValues.db_ShowTableContentsWhileScrolling);
            this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            return true;
        }
        return false;
    }

    private void closeThisWindow() {
        this.account.close();
        this.parent.displayHandler.closeTab(this);
    }

    private void handleMouseClick(MouseEvent mouseEvent) {
        int n = mouseEvent.getClickCount();
        if (n == 2) {
            if (!this.parent.checkChanged()) {
                mouseEvent.consume();
                return;
            }
            this.editTransaction();
        } else if (this.parent.editorFormIsLoaded()) {
            if (!this.parent.checkChanged()) {
                mouseEvent.consume();
                return;
            }
            this.editTransaction();
        }
    }

    private void editTransaction() {
        int n = this.accountTable.getSelectedRow();
        if (!this.oneLineMode) {
            n /= 2;
        }
        this.parent.loadEditorForm(this.account, n);
    }

    public void deleteTransactions() {
        int[] nArray = this.accountTable.getSelectedRows();
        int n = this.oneLineMode ? 1 : 2;
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i] / n;
            if (n2 < 0 || n2 >= this.account.transactionList.size()) continue;
            treeSet.add(new Integer(nArray[i] / n));
        }
        Integer[] integerArray = treeSet.toArray(new Integer[0]);
        if (this.account.deleteTransactions(integerArray, true)) {
            this.parent.closeEditWindow();
        }
    }

    private void goToTransfer() {
        TransactionLocation transactionLocation;
        int n = this.getSelectedRecord();
        Transaction transaction = this.account.getTransaction(n);
        if (transaction.splits != null && transaction.splits.size() > 0) {
            transaction = (Transaction)transaction.splits.get(0);
        }
        if ((transactionLocation = this.parent.commonCode.locateTransaction(this.parent.accountHandler.dataMap, this.account, transaction, this.parent.commonCode.ACTION_DO_NOTHING)) != null) {
            int n2 = transactionLocation.a.indexOf(transactionLocation.t);
            this.parent.displayHandler.addTest(transactionLocation.a, n2);
        } else {
            this.parent.beep();
            JOptionPane.showMessageDialog(null, "Cannot jump to \"" + transaction.db_Category + "\".", "Jump to Transfer", 0);
        }
    }

    public int getSelectedRecord() {
        int n = this.accountTable.getSelectedRow();
        int n2 = this.oneLineMode ? 1 : 2;
        return n /= n2;
    }

    public void tableFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AccountDisplay.this.accountTable.requestFocus();
            }
        });
    }

    private void refreshAccountAndDisplay() {
        this.account.refreshTable();
    }

    private void processKeys(KeyEvent keyEvent) {
        if (keyEvent.isControlDown() && keyEvent.getKeyChar() != '\uffff') {
            this.popupMenu.show(this, this.getSize().width / 2, this.getSize().height / 2);
        } else if (keyEvent.getKeyCode() == 114) {
            this.parent.searchAgain(this.account);
        }
    }

    public void reconcile() {
        ReconcileForm reconcileForm = new ReconcileForm(this.parent, this.account);
        this.parent.displayHandler.addComp("Reconcile " + this.account.db_Name, reconcileForm);
    }

    private void setViewTableContents(boolean bl) {
        if (bl) {
            this.parent.programValues.db_ShowTableContentsWhileScrolling = this.viewTableContentsCheckBoxMenuItem.isSelected();
        } else {
            this.viewTableContentsCheckBoxMenuItem.setSelected(this.parent.programValues.db_ShowTableContentsWhileScrolling);
        }
    }

    private void printChecks() {
        this.parent.printChecks(this.account);
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.searchMenuItem = new JMenuItem();
        this.editMenuItem = new JMenuItem();
        this.goToMenuItem = new JMenuItem();
        this.closeMenuItem = new JMenuItem();
        this.closeAllMenuItem = new JMenuItem();
        this.reconcileMenuItem = new JMenuItem();
        this.printChecksMenuItem = new JMenuItem();
        this.refreshMenuItem = new JMenuItem();
        this.oneLineCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.viewTableContentsCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.jSeparator1 = new JSeparator();
        this.deleteMenuItem = new JMenuItem();
        this.scrollPane = new JScrollPane();
        this.accountTable = new JTable();
        this.totalPanel = new JPanel();
        this.balanceWindow = new JLabel();
        this.searchMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.searchMenuItem.setText("Find");
        this.searchMenuItem.setToolTipText("Search for specific text");
        this.searchMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountDisplay.this.searchMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.searchMenuItem);
        this.editMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.editMenuItem.setText("Edit");
        this.editMenuItem.setToolTipText("Edit this transaction (two clicks works also)");
        this.editMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountDisplay.this.editMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.editMenuItem);
        this.goToMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.goToMenuItem.setText("Go to transfer");
        this.goToMenuItem.setToolTipText("Only works for account names enclosed in [ ]");
        this.goToMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountDisplay.this.goToMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.goToMenuItem);
        this.closeMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.closeMenuItem.setText("Close");
        this.closeMenuItem.setToolTipText("Close this account");
        this.closeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountDisplay.this.closeMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.closeMenuItem);
        this.closeAllMenuItem.setText("Close All");
        this.closeAllMenuItem.setToolTipText("Close all open accounts");
        this.closeAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountDisplay.this.closeAllMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.closeAllMenuItem);
        this.reconcileMenuItem.setText("Reconcile");
        this.reconcileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountDisplay.this.reconcileMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.reconcileMenuItem);
        this.printChecksMenuItem.setText("Print Checks");
        this.printChecksMenuItem.setToolTipText("Print any pending checks");
        this.printChecksMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountDisplay.this.printChecksMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.printChecksMenuItem);
        this.refreshMenuItem.setText("Refresh");
        this.refreshMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountDisplay.this.refreshMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.refreshMenuItem);
        this.oneLineCheckBoxMenuItem.setText("One line display");
        this.oneLineCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountDisplay.this.oneLineCheckBoxMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.oneLineCheckBoxMenuItem);
        this.viewTableContentsCheckBoxMenuItem.setText("View contents while scrolling");
        this.viewTableContentsCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountDisplay.this.viewTableContentsCheckBoxMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.viewTableContentsCheckBoxMenuItem);
        this.popupMenu.add(this.jSeparator1);
        this.deleteMenuItem.setText("Delete transaction(s)");
        this.deleteMenuItem.setToolTipText("Delete selected transactions");
        this.deleteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountDisplay.this.deleteMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.deleteMenuItem);
        this.setMinimumSize(new Dimension(0, 0));
        this.setPreferredSize(new Dimension(0, 0));
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                AccountDisplay.this.formKeyPressed(keyEvent);
            }
        });
        this.setLayout(new BorderLayout());
        this.scrollPane.setBackground(new Color(255, 255, 255));
        this.scrollPane.setToolTipText("");
        this.scrollPane.setDoubleBuffered(true);
        this.scrollPane.setOpaque(false);
        this.scrollPane.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                AccountDisplay.this.scrollPaneKeyPressed(keyEvent);
            }
        });
        this.scrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                AccountDisplay.this.scrollPaneMousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                AccountDisplay.this.scrollPaneMouseReleased(mouseEvent);
            }
        });
        this.scrollPane.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                AccountDisplay.this.scrollPaneMouseDragged(mouseEvent);
            }
        });
        this.accountTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.accountTable.setToolTipText("Double-click to edit a transaction, right-click for more options");
        this.accountTable.setIntercellSpacing(new Dimension(1, 0));
        this.accountTable.setShowHorizontalLines(false);
        this.accountTable.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                AccountDisplay.this.accountTableComponentShown(componentEvent);
            }
        });
        this.accountTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                AccountDisplay.this.accountTableKeyPressed(keyEvent);
            }
        });
        this.accountTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                AccountDisplay.this.accountTableMousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                AccountDisplay.this.accountTableMouseReleased(mouseEvent);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                AccountDisplay.this.accountTableMouseClicked(mouseEvent);
            }
        });
        this.scrollPane.setViewportView(this.accountTable);
        this.add((Component)this.scrollPane, "Center");
        this.totalPanel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                AccountDisplay.this.totalPanelKeyPressed(keyEvent);
            }
        });
        this.totalPanel.setLayout(new BorderLayout());
        this.balanceWindow.setText("Ending Balance: 0.00");
        this.totalPanel.add((Component)this.balanceWindow, "East");
        this.add((Component)this.totalPanel, "South");
    }

    private void printChecksMenuItemActionPerformed(ActionEvent actionEvent) {
        this.printChecks();
    }

    private void accountTableComponentShown(ComponentEvent componentEvent) {
        this.setupDisplay();
    }

    private void viewTableContentsCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setViewTableContents(true);
    }

    private void reconcileMenuItemActionPerformed(ActionEvent actionEvent) {
        this.reconcile();
    }

    private void totalPanelKeyPressed(KeyEvent keyEvent) {
        this.processKeys(keyEvent);
    }

    private void scrollPaneKeyPressed(KeyEvent keyEvent) {
        this.processKeys(keyEvent);
    }

    private void accountTableKeyPressed(KeyEvent keyEvent) {
        this.processKeys(keyEvent);
    }

    private void formKeyPressed(KeyEvent keyEvent) {
        this.processKeys(keyEvent);
    }

    private void searchMenuItemActionPerformed(ActionEvent actionEvent) {
        this.parent.openSearchWindow(this.account);
    }

    private void scrollPaneMousePressed(MouseEvent mouseEvent) {
        this.handleMenu(mouseEvent);
    }

    private void scrollPaneMouseReleased(MouseEvent mouseEvent) {
        this.handleMenu(mouseEvent);
    }

    private void scrollPaneMouseDragged(MouseEvent mouseEvent) {
    }

    private void refreshMenuItemActionPerformed(ActionEvent actionEvent) {
        this.refreshAccountAndDisplay();
    }

    private void editMenuItemActionPerformed(ActionEvent actionEvent) {
        this.editTransaction();
    }

    private void goToMenuItemActionPerformed(ActionEvent actionEvent) {
        this.goToTransfer();
    }

    private void deleteMenuItemActionPerformed(ActionEvent actionEvent) {
        this.deleteTransactions();
    }

    private void accountTableMouseClicked(MouseEvent mouseEvent) {
        this.handleMouseClick(mouseEvent);
    }

    private void closeAllMenuItemActionPerformed(ActionEvent actionEvent) {
        this.parent.displayHandler.closeAll();
    }

    private void closeMenuItemActionPerformed(ActionEvent actionEvent) {
        this.closeThisWindow();
    }

    private void oneLineCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
        this.changeModes();
    }

    private void accountTableMouseReleased(MouseEvent mouseEvent) {
        this.handleMenu(mouseEvent);
    }

    private void accountTableMousePressed(MouseEvent mouseEvent) {
        this.handleMenu(mouseEvent);
    }

    final class MyTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public MyTableCellRenderer() {
            this.setOpaque(true);
            this.setVerticalAlignment(0);
            this.setFont(AccountDisplay.this.displayFont);
            this.setBorder(AccountDisplay.this.tableCellBorder);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = AccountDisplay.this.formatDisplayRow(this, n, n2);
            this.setText(string);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            }
            return this;
        }
    }

    class DataListener
    implements TableModelListener {
        TableModel model;

        DataListener(JTable jTable) {
            this.model = jTable.getModel();
            this.model.addTableModelListener(this);
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            int n;
            int n2 = tableModelEvent.getFirstRow();
            Object object = this.model.getValueAt(n2, n = tableModelEvent.getColumn());
            if (object != null) {
                // empty if block
            }
        }
    }
}

