(*&USE32-*)(*&DELPHI-*)(*$X-*)(*$Q-*)

(* 05.11.1998..08.11.1998 Veit Kannegieser *)
(* 1999.03.18 Fehlerbehebung,DOS+OS/2 Version *)

program binobj;

uses
  dos;

const
  titel='BINOBJ32 * Veit Kannegieser * ';
  version='1998.11.05..1999.03.18';
  vier_wenn_wahr:array[false..true] of byte=(0,4);

type
  zk2=string[2];
  zk4=string[4];

var
  d1,d2:file;
  puffer:
    record
      record_typ:byte;
      record_laenge:word;
      daten:array[1..2000] of byte;
    end;
  d1_laenge,d1_pos,d1_jetzt:longint;

  d:dirstr;
  n:namestr;
  e:extstr;

(*$IFDEF VIRTUALPASCAL*)
function word_zu_zk2(w:word):zk2;
(*$FRAME-*)(*$USES EAX,EDI*)
  asm
    mov edi,@result
    mov ax,w
    mov [edi].byte,2
    mov [edi+1],ax
  end;
(*$ELSE*)
function word_zu_zk2(w:word):zk2;
  begin
    word_zu_zk2:=chr(lo(w))+chr(hi(w));
  end;
(*$ENDIF*)

(*$IFDEF VIRTUALPASCAL*)
function longint_zu_zk4(l:longint):zk4;
(*$FRAME-*)(*$USES EAX,EDI*)
  asm
    mov edi,@result
    mov eax,l
    mov [edi].byte,4
    mov [edi+1],eax
  end;
(*$ELSE*)
function longint_zu_zk4(l:longint):zk4;
  begin
    longint_zu_zk4:=chr( l         and $ff)
                   +chr((l shr  8) and $ff)
                   +chr((l shr 16) and $ff)
                   +chr((l shr 24) and $ff);
  end;
(*$ENDIF*)

procedure schreibe;
  var
    zaehler:longint;
    summe:byte;
  begin
    with puffer do
      begin
        summe:=   record_typ
              +lo(record_laenge)
              +hi(record_laenge);

        for zaehler:=1 to record_laenge-1 do
          inc(summe,daten[zaehler]);

        daten[record_laenge]:=-summe;
      end;

    blockwrite(d2,puffer,1+2+puffer.record_laenge);
  end;

procedure schreibe_zk(rec_typ:byte;zk:string);
  begin
    puffer.record_typ:=rec_typ;
    puffer.record_laenge:=length(zk)+1;
    move(zk[1],puffer.daten,length(zk));
    schreibe;
  end;

function lstr(zk:string):string;
  begin
    lstr:=chr(length(zk))+zk;
  end;



begin
  writeln(titel,version);

  if not (paramcount in [3,4]) then
    begin
      writeln('usage:   BINOBJ <source> <target[.obj]> <symbolname> [<sybolname_length>]');
      writeln('example: BINOBJ TEST.BIN TEST.OBJ testcode testcode_length');
      halt(1);
    end;

  assign(d1,paramstr(1));
  fsplit(paramstr(2),d,n,e);
  if e='' then e:='.obj';
  assign(d2,d+n+e);

  reset(d1,1);
  rewrite(d2,1);

  d1_laenge:=filesize(d1);

  (* THEADR *)
  schreibe_zk($80,lstr(paramstr(1)));

  (* COMENT *)
  (* 0/0=translator *)
  schreibe_zk($88,#0#0+lstr(titel+version));

  (* LNAMES *)
  schreibe_zk($96,lstr('CODE32')+lstr('CODE')+lstr('FLAT'));

  (* SEGDEF32 *)
  schreibe_zk($99,chr(                  (* segment attribute bits *)
                      1 shl 5           (* 1=byte 3=para aligned  *)
                     +2 shl 2           (* public                 *)
                     +0 shl 1           (* (big)                  *)
                     +1 shl 0)          (* USE32                  *)
                 +longint_zu_zk4(d1_laenge+vier_wenn_wahr[paramcount=4])
                                        (* segment length  *)
                 (* omf.inf : 2 Byte ?? *)
                 +#1                    (* segment name index     *)
                 +#2                    (* segment class index    *)
                 +#0                    (* overlay name index     *));


  (* GROUPDEF *)
  schreibe_zk($9a,#3);                  (* FLAT *)


  (* PUBDEF *)
  schreibe_zk($91,#0                    (* (base group index)     *)
                 +#1                    (* base segment index     *)
                 +lstr(paramstr(3))
                 +longint_zu_zk4(0)     (* public offset          *)
                 +#0                    (* (type index)           *));

  if paramcount=4 then
    (* PUBDEF *)
    schreibe_zk($91,#0                  (* (base group index)     *)
                   +#1                  (* base segment index     *)
                   +lstr(paramstr(4))
                   +longint_zu_zk4(d1_laenge)  (* public offset   *)
                   +#0                  (* (type index)           *));


  (*********************************************************************)

  d1_pos:=0;
  while not eof(d1) do
    begin
      d1_jetzt:=d1_laenge-d1_pos;
      if d1_jetzt>$200 then
        d1_jetzt:=$200;

      (* LEDATA *)
      puffer.record_typ:=$a1;
      puffer.record_laenge:=1+4+d1_jetzt+1;
      mem [(*$IFNDEF VIRTUALPASCAL*)seg(puffer):(*$ENDIF*)ofs(puffer.daten[1  ])]:=1;
      meml[(*$IFNDEF VIRTUALPASCAL*)seg(puffer):(*$ENDIF*)ofs(puffer.daten[1+1])]:=d1_pos;
      blockread(d1,puffer.daten[1+1+4],d1_jetzt);
      schreibe;

      inc(d1_pos,d1_jetzt);
    end;

  if paramcount=4 then
    (* LEDATA *)
    schreibe_zk($a1,#1
                   +longint_zu_zk4(d1_laenge)
                   +longint_zu_zk4(d1_laenge));


  (* MODEND *)
  schreibe_zk($8b,#$01);

  close(d1);
  close(d2);

end.

