/******************************* REXX *********************************/
/*  This REXX program is used to sign plain text files with PGP 5.0   */
/*  for OS/2.  It can also work as a "SEND EXIT" for Southside        */
/*  Software's PlusPak:PMINews 2.0 to sign outgoing messages to       */
/*  Usenet.  This program was written by Jaime A. Cruz, Jr. and       */
/*  released to the public domain in hopes that others find it        */
/*  useful and can improve upon it.                                   */
/**********************************************************************/
'@ECHO OFF'
Parse Arg fn .
passphrase = ''              /* You can hardcode your passphrase here */
switch = 1

/**********************************************************************/
/*            Initialize REXXUtil environment (if not present)        */
/**********************************************************************/
rxload = RxFuncQuery('SysLoadFuncs')
If rxload Then
   Do
      Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
      Call sysloadfuncs
   End
 
/**********************************************************************/
/*  This program assumes you have a "SET TEMP=temporary directory"    */
/*  directive in your CONFIG.SYS (as on my system).  If you do not,   */
/*  you may want to add one, or adjust the next statement             */
/*  accordingly.                                                      */
/**********************************************************************/
tempdir = Value('TEMP', ,'OS2ENVIRONMENT')
 
/**********************************************************************/
/*        Create two temporary files in the \TEMP directory.          */
/**********************************************************************/
tmpfl.0 = 2
tmpfl.1 = SysTempFileName(tempdir || '\PGP?????.TMP')
tmpfl.1.ctr = 0
tmpfl.2 = SysTempFileName(tempdir || '\PGP?????.TMP')
tmpfl.2.ctr = 0
 
/**********************************************************************/
/*  Read in the input file until we hit the "Subject:" line.  If we   */
/*  never hit this line, continue till the end.                       */
/**********************************************************************/
input.0 = 0
Do While Lines(fn) > 0
   input.0 = input.0 + 1
   x = input.0
   input.x = Linein(fn)
   Parse Value input.x With 1 header 10 ,
                            .
   Call Lineout tmpfl.switch, input.x
   tmpfl.switch.ctr = tmpfl.switch.ctr + 1
 
/**********************************************************************/
/*  If we hit the "Subject:" line, copy it and the next (assumed to   */
/*  be blank) line to the first temporary file, and then switch over  */
/*  to the second temporary file.  It is this file which will be      */
/*  signed (don't sign the PMINews header information, it confuses    */
/*  the program).                                                     */
/**********************************************************************/
   If header = 'Subject: ' Then
      Do
         input.0 = input.0 + 1
         x = input.0
         input.x = Linein(fn)
         Call Lineout tmpfl.switch, input.x
         tmpfl.switch.ctr = tmpfl.switch.ctr + 1
         switch = 2
      End
End
 
/**********************************************************************/
/*  Close the two (possibly three) files.  Again, if we never found   */
/*  a "Subject:" line, then sign the entire document, otherwise       */
/*  we will just sign the message portion of the file.                */
/**********************************************************************/
Call Lineout fn
Call Lineout tmpfl.1
If switch = 2 Then
   Call Lineout tmpfl.2
 
/**********************************************************************/
/*  If the "passphrase" variable is left blank above, this section    */
/*  will prompt the user for his PGP passphrase.  This is the only    */
/*  section of this program that will require IBM's Visual REXX       */
/*  extensions package (VREXX2.ZIP on most OS/2 download sites).      */
/**********************************************************************/
If Length(passphrase) = 0 Then
   Do
      Call RxFuncAdd 'VInit', 'VREXX', 'VINIT'
      initcode = VInit()
      If initcode \= 'ERROR' Then
         Do
            Call VDialogPos 50, 50
            p.0 = 1                          /* Number of prompts     */
            p.1 = 'Enter your PGP Passphrase:'
            w.0 = p.0                        /* Width of each prompt  */
            w.1 = 80
            h.0 = p.0                        /* Which replies to hide */
            h.1 = 1
            r.0 = p.0                        /* Response defaults     */
            r.1 = ''
            button = VMultBox('PGPSign', p, w, h, r, 1)
            passphrase = r.1
         End
      Call VExit
   End
 
/**********************************************************************/
/*  Place the passphrase in the local OS/2 environment for PGP 5.0    */
/*  to find.                                                          */
/**********************************************************************/
Call Value 'PGPPASS', passphrase, 'OS2ENVIRONMENT'
 
/**********************************************************************/
/*  Use PGP 5.0 to sign the file.  The signed file is created in      */
/*  another temporary file.                                           */
/**********************************************************************/
sgnfull = SysTempFileName(tempdir || '\PGP?????.TMP')
'PGP s -aqt' tmpfl.switch '-o' sgnfull
 
/**********************************************************************/
/*       Read the signed file into compound variable record.x         */
/**********************************************************************/
record.0 = 0
Do While Lines(sgnfull) > 0
   record.0 = record.0 + 1
   x = record.0
   record.x = Linein(sgnfull)
End
Call Lineout sgnfull
 
/**********************************************************************/
/*  Now, overwrite the original file with the signed information.     */
/*  If the file was split, first copy in the unsigned portion of the  */
/*  data (the PMINews header information).                            */
/**********************************************************************/
Call SysFileDelete fn
If switch = 2 Then
   Do x = 1 To tmpfl.1.ctr
      Call Lineout fn, input.x
   End
 
/**********************************************************************/
/*                   Now copy in the signed file.                     */
/**********************************************************************/
Do x = 1 To record.0
   Call Lineout fn, record.x
End
Call Lineout fn
 
/**********************************************************************/
/*           Delete all of the temporary files we created.            */
/**********************************************************************/
Call SysFileDelete sgnfull
Call SysFileDelete tmpfl.1
Call SysFileDelete tmpfl.2
 
/**********************************************************************/
/*      If we loaded the REXX Utils functions, drop them here.        */
/**********************************************************************/
If rxload Then
   Call SysDropFuncs
Exit
