/*********************************************************************/
/*                                                                   */
/*  This Program Written by Paul Edwards.                            */
/*  Released to the Public Domain                                    */
/*                                                                   */
/*********************************************************************/
/*********************************************************************/
/*                                                                   */
/*  crc32gen - generate a CRC32 lookup table.  I do it the manual    */
/*  way, because the number of terms is so high that I don't think   */
/*  anything is gained by doing block shifts.                        */
/*                                                                   */
/*********************************************************************/

#include <stdio.h>

static unsigned long crc32_tab[256];

int main(void)
{
  unsigned int x;
  unsigned long y;
  unsigned int z;
  
  for (x=0;x<256;x++)
  {
    y = (unsigned long)x;
    for (z=0; z < 8; z++)
    {
      if ((y & 0x00000001UL) != 0)
      {
        y = y >> 1;
        y = y ^ 0xEDB88320UL;
      }
      else
      {
        y = y >> 1;
      }
    }
    crc32_tab[x] = y;
  }
  
  for (x=0; x < 64; x++)
  {
    printf(" ");
    for (y=0;y<4;y++)
    {
      printf("0x%0.8XUL, ",crc32_tab[x*4+y]);
    }
    printf("\n");
  }
  return (0);
}
