NAME
     cpio - copy file archives in and out

SYNOPSIS
     cpio -o[Bacv]
     cpio -i[Bcdfmrtuv] [pattern...]
     cpio -p[adlmruv] directory

DESCRIPTION
     The cpio utility produces and reads files in the format
     specified by the cpio Archive/Interchange File Format speci-
     fied in IEEE Std. 1003.1-1988.

     The cpio -i (copy in) utility extracts files from the stan-
     dard input, which is assumed to be the product of a previous
     cpio -o . Only files with names that match patterns are
     selected.  Multiple patterns may be specified and if no pat-
     terns are specified, the default for patterns is  selecting
     all files.  The extracted files are conditionally created
     and copied into the current directory, and possibly any lev-
     els below, based upon the options described below and the
     permissions of the files will be those of the previous cpio
     -o . The owner and group of the files will be that of the
     current user unless the user has appropriate privileges,
     which causes cpio to retains the owner and group of the
     files of the previous cpio -o .

     The cpio -p (pass) utility reads the standard input to
     obtain a list of path names of files that are conditionally
     created and copied into the destination directory based upon
     the options described below.

     If an error is detected, the cause is reported and the cpio
     utility will continue to copy other files.  cpio will skip
     over any unrecognized files which it encounters in the
     archive.

     The following restrictions apply to the cpio utility:

     1 Pathnames are restricted to 256 characters.

     2 Appropriate privileges are required to copy special files.

     3 Blocks are reported in 512-byte quantities.

     Options
     The following options are available:

     -B   Input/output is to be blocked 5120 bytes to the record.
          Can only be used with cpio -o or cpio -i for data that
          is directed to or from character special files.

     -a   Reset access times of input files after they have been
          copied.  When the -l option is also specified, the
          linked files do not have their access times reset.  Can
          only be used with cpio -o or cpio -i .

     -c   Write header information in ASCII character for for
          portability.  Can only be used with cpio -i or cpio -o
          . Note that this option should always be used to write
          portable files.

     -d   Creates directories as needed.  Can only be used with
          cpio -i or cpio -p .

     -f   Copy in all files except those in patterns . Can only
          be used with cpio -i .

     -l   Whenever possible, link files rather than copying them.
          Can only be used with cpio -p .

     -m   Retain previous modification times.  This option is
          ineffective on directories that are being copied.  Can
          only be used with cpio -i or cpio -p .

     -r   Interactively rename files.  The user is asked whether
          to rename pattern each invocation.  Read and write per-
          missions for /dev/tty are required for this option.  If
          the user types a null line, the file is skipped.
          Should only be used with cpio -i or cpio -o .

     -t   Print a table of contents of the input.  No files are
          created.  Can only be used with cpio -i .

     -u   Copy files unconditionally; usually an older file will
          not replace a new file with the same name.  Can only be
          used with cpio -i or cpio -p .

     -v   Verbose: cause the names of the affected files to be
          printed.  Can only be used with cpio -i . Provides a
          detailed listing when used with the -t option.

     Operands
     The following operands are available:

     patterns  Simple regular expressions given in the name-
               generating notation of the shell.

     directory The destination directory.

     Exit Status
     The cpio utility exits with one of the following values:

     0    All input files were copied.

     2    The utility encountered errors in copying or accessing
          files or directories.  An error will be reported for
          nonexistent files or directories, or permissions that
          do not allow the user to access the source or target
          files.


     It is important to use the -depth option of the find utility
     to generate pathnames for cpio . This eliminates problems
     cpio could have trying to create files under read-only
     directories.

     The following command:
          ls | cpio -o > ../newfile
     copies out the files listed by the ls utility and redirects
     them to the file newfile .

     The following command:
          cat newfile | cpio -id "memo/al" "memo/b*"
     uses the output file newfile from the cpio -o utility, takes
     those files that match the patterns memo/al and memo/b* ,
     creates the directories below the current directory, and
     places the files in the appropriate directories.

     The command
          find . -depth -print | cpio -pdlmv newdir
     takes the file names piped to it from the find utility and
     copies or links those files to another directory named
     newdir , while retaining the modification time.

FILES
     /dev/tty  used to prompt the user for information when the
               -i or -r options are specified.

SEE ALSO
     find(1), pax(1), tar(1), cpio(5), tar(5)

COPYRIGHT
     Copyright (c) 1989 Mark H. Colburn.
     All rights reserved.

     Redistribution and use in source and binary forms are per-
     mitted provided that the above copyright notice is dupli-
     cated in all such forms and that any documentation,
     advertising materials, and other materials related to such
     distribution and use acknowledge that the software was
     developed by Mark H. Colburn.

     THE SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS
     OR IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE
     IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PAR-
     TICULAR PURPOSE.

AUTHOR
     Mark H. Colburn
     Minnetech Consulting, Inc.
     3232 Aquila Lane
     St. Louis Park, MN 55426

     mark@Minnetech.MN.ORG
