import java.util.*;
import java.applet.*;
import java.awt.*;

class move //Object representation of a valid move - can be used in Vector
{
	int row,col,quality;
	public move(int r,int c,int q) {row=r; col=c; quality=q;}
	public int r() {return row;}
	public int c() {return col;}
	public int q() {return quality;}
}

class playertype
{
	static final int AI=1,human=2,inactive=0;
	int type;
	playertype(int inittype) {type=inittype;}
	int Type() {return type;}
	int Type(int newtype) {return type=newtype;}
}

public class Othello extends Applet
{
	int pos[][];
	Color col[]=new Color[3];
	int player;
	int w,h;
	boolean clear=false; //If true, update() will clear window
	Vector gamerecord; //Vector of moves (quality really means player)
	playertype p[]=new playertype[3];
	int totscore=0;
	boolean hintset=false;
	int hintr,hintc;

	public void init()
	{
		String tmp;
		tmp=getParameter("player1");
		if (tmp!=null)
		{
			System.out.println("Player 1: '"+tmp+"'");
			if (tmp.equals("AI")) p[1]=new playertype(playertype.AI);
			else if (tmp.equals("human")) p[1]=new playertype(playertype.human);
			else p[1]=new playertype(playertype.human);
		}
		else p[1]=new playertype(playertype.human);
		tmp=getParameter("player2");
		if (tmp!=null)
		{
			System.out.println("Player 2: '"+tmp+"'");
			if (tmp.equals("AI")) p[2]=new playertype(playertype.AI);
			else if (tmp.equals("human")) p[2]=new playertype(playertype.human);
			else p[2]=new playertype(playertype.AI);
		}
		else p[2]=new playertype(playertype.AI);
		col[0]=Color.black; col[1]=Color.blue; col[2]=Color.red;
		pos=new int[8][8];
		for (int r=0;r<8;++r)
			for (int c=0;c<8;++c)
				pos[r][c]=0;
		pos[3][3]=2; pos[3][4]=1;
		pos[4][3]=1; pos[4][4]=2;
		player=1;
		clear=true;
		gamerecord=new Vector();
		requestFocus();
		repaint();
		while (p[player].Type()==playertype.AI) if (!aimove()) break;
	}

	int quality(int r,int c) //Calculate the quality of move r,c - a larger number means a better move
	{
		int tmp[][]=new int[8][8];
		for (int rr=0;rr<8;++rr)
			for (int cc=0;cc<8;++cc)
				tmp[rr][cc]=pos[rr][cc];
		for (int dir=0;dir<8;++dir)
		{
			try
			{
				for (int i=0;i<8;++i)
				{
					if (tmp[r+dr(dir)*(i+1)][c+dc(dir)*(i+1)]==3-player) tmp[r+dr(dir)*(i+1)][c+dc(dir)*(i+1)]=player;
					else break;
				}
			}
			catch (ArrayIndexOutOfBoundsException e)
			{
			}
		}
		tmp[r][c]=player;
		int red=0,blue=0;
		for (int rr=0;rr<8;++rr)
			for (int cc=0;cc<8;++cc)
				switch (tmp[rr][cc])
				{
					case 1: ++blue; break;
					case 2: ++red; break;
					default: break;
				}
		int posqual=0;
		if (r==0) ++posqual; // \
		if (c==0) ++posqual; // } Edges worth 1, corners 2
		if (r==7) ++posqual; // }
		if (c==7) ++posqual; // /

		if (r==1) --posqual; // \
		if (c==1) --posqual; // } Near corner but on edge worth 0
		if (r==6) --posqual; // } but near corner and not on edge worth -2
		if (c==6) --posqual; // /
		return red-blue+posqual*1000; //posqual counts for a lot
	}

	move bestmove()
	{
		Vector validMoves=new Vector();
		for (int r=0;r<8;++r)
			for (int c=0;c<8;++c)
				if (canplace(r,c)) validMoves.addElement(new move(r,c,quality(r,c)));
		if (validMoves.size()==0) return null; //No valid moves
		Enumeration e=validMoves.elements();
		move best=null;
		while (e.hasMoreElements())
		{
			move m=(move)e.nextElement();
			//If this move is better than the current best move set best to this
			if ((best==null)||(m.q()>best.q())) best=m;
		}
		return best;
	}

	boolean aimove()
	{
		move best=bestmove();
		if (best==null) return false; //No move called best???
		if (placepiece(best.r(),best.c())) {player=3-player; checkpass(); repaint();}
		repaint();
		try wait(500); catch (Exception ex);
		return true;
	}

	public void paint(Graphics g)
	{
		Rectangle b=bounds();
		w=b.width-b.width%8+1;
		h=b.height-b.height%8+1;
		if (w>=b.width) w-=8;
		if (h>=b.height) w-=8;
		g.setColor(col[0]);
		for (int x=0;x<w;x+=w/8)
			g.drawLine(x,0,x,h);
		for (int y=0;y<h;y+=h/8)
			g.drawLine(0,y,w,y);
		for (int r=0;r<8;++r)
			for (int c=0;c<8;++c)
				if (pos[r][c]!=0)
				{
					g.setColor(col[pos[r][c]]);
					g.fillOval(c*w/8+w/64,r*h/8+h/64,w*3/32,h*3/32);
					g.setColor(col[0]);
					g.drawOval(c*w/8+w/64,r*h/8+h/64,w*3/32,h*3/32);
				}
		if (hintset&&pos[hintr][hintc]==0)
		{
			System.out.println("Starting hint display");
			g.setColor(Color.white);
			g.fillOval(hintc*w/8+w/64,hintr*h/8+h/64,w*3/32,h*3/32);
			g.setColor(col[0]);
			g.drawOval(hintc*w/8+w/64,hintr*h/8+h/64,w*3/32,h*3/32);
			System.out.println("Ending hint display");
		}
	}

	void checkpass() //Check if current player has to pass
	{
		showStatus("");
		for (int r=0;r<8;++r)
		{
			for (int c=0;c<8;++c)
			{
				if (canplace(r,c)) return;
			}
		}
		//If we get here, current player cannot place piece
		player=3-player;
		boolean gameover=true;
		try
		{
			for (int r=0;r<8;++r)
			{
				for (int c=0;c<8;++c)
				{
					if (canplace(r,c)) throw new IllegalArgumentException();
				}
			}
		}
		catch (IllegalArgumentException e)
		{
			gameover=false;
		}
		if (gameover)
		{
			int red=0,blue=0;
			for (int r=0;r<8;++r)
				for (int c=0;c<8;++c)
					switch (pos[r][c])
					{
						case 1: ++blue; break;
						case 2: ++red; break;
						default: break;
					}
			String msg="";
			if (blue>red) msg="Blue won by "+(blue-red)+".";
			if (red>blue) msg="Red won by "+(red-blue)+".";
			if (red==blue) msg="Draw!";
			totscore+=blue-red;
			showStatus("Game over! "+msg+" Total score: "+totscore);
			repaint();
		}
		else
		{
			repaint();
			showStatus("Player "+(3-player)+" must pass.");
			if (player==2) try wait(1000); catch (Exception e);
		}
	}

	boolean canplace(int r,int c)
	{
		if (pos[r][c]!=0) return false;
		boolean ok=false;
		for (int dir=0;dir<8;++dir)
		{
			try
			{
				for (int i=0;i<8;++i)
				{
					int p=pos[r+dr(dir)*(i+1)][c+dc(dir)*(i+1)];
					if (p==player)
					{
						if (i>0) ok=true;
						throw (new IllegalArgumentException());
					}
					if (p==0) throw(new ArrayIndexOutOfBoundsException());
				}
			}
			catch (ArrayIndexOutOfBoundsException e)
			{
				continue;
			}
			catch (IllegalArgumentException e)
			{
			}
		}
		return ok;
	}

	public void showmoves()
	{
		if (gamerecord.size()==0) return;
		Enumeration e=gamerecord.elements();
		while (e.hasMoreElements())
		{
			move m=(move)e.nextElement();
			System.out.println(m.q()+": ("+m.r()+","+m.c()+")");
		}
	}

	public boolean placepiece(int r,int c)
	{
		if (pos[r][c]!=0) return false;
		boolean ok=false;
		for (int dir=0;dir<8;++dir)
		{
			try
			{
				for (int i=0;i<8;++i)
				{
					int p=pos[r+dr(dir)*(i+1)][c+dc(dir)*(i+1)];
					if (p==player)
					{
						if (i>0) ok=true;
						throw (new IllegalArgumentException());
					}
					if (p==0) throw(new ArrayIndexOutOfBoundsException());
				}
			}
			catch (ArrayIndexOutOfBoundsException e)
			{
				continue;
			}
			catch (IllegalArgumentException e)
			{
			}
			try
			{
				for (int i=0;i<8;++i)
				{
					if (pos[r+dr(dir)*(i+1)][c+dc(dir)*(i+1)]==3-player) pos[r+dr(dir)*(i+1)][c+dc(dir)*(i+1)]=player;
					else break;
				}
			}
			catch (ArrayIndexOutOfBoundsException e)
			{
				continue;
			}
		}
		if (ok)
		{
			if (hintset) {hintset=false; clear=true;}
			pos[r][c]=player;
			gamerecord.addElement(new move(r,c,player));
			repaint();
		}
		return ok;
	}

	void hint()
	{
		System.out.println("Starting hint()");
		move best=bestmove();
		if (best==null) return; //No move called best???
		hintr=best.r();
		hintc=best.c();
		hintset=true;
		repaint();
		System.out.println("Finished hint()");
	}

	public void undo()
	{
		if (gamerecord.size()<2) return;
		for (int r=0;r<8;++r)
			for (int c=0;c<8;++c)
				pos[r][c]=0;
		pos[3][3]=2; pos[3][4]=1;
		pos[4][3]=1; pos[4][4]=2;
		clear=true;
		player=1;
		Vector tmp=new Vector(gamerecord.size());
		for (int i=0;i<gamerecord.size()-2;++i)
		{
			move m=(move)gamerecord.elementAt(i);
			tmp.addElement(m);
		}
		gamerecord.removeAllElements();
		for (Enumeration e=tmp.elements();e.hasMoreElements();)
		{
			move m=(move)e.nextElement();
			if (placepiece(m.r(),m.c())) {player=3-player; checkpass();}
		}
		repaint();
	}

	public boolean keyDown(Event evt,int key)
	{
		if (key==Event.F12) showmoves();
		if (key==Event.F11) undo();
		if (key==Event.F10) hint();
		if (key==Event.F9) init();
		if ((key=='N'||key=='n')&&evt.controlDown()) init(); //New game
		if ((key=='H'||key=='h')&&evt.controlDown()) hint();
		if ((key==8||key=='U'||key=='u')&&evt.metaDown()) undo();
		if ((key=='P'||key=='p')&&evt.controlDown()) {player=3-player; checkpass(); repaint(); while (p[player].Type()==playertype.AI) if (!aimove()) break;}
		return true;
	}

	public boolean mouseDown(Event evt,int x,int y)
	{
		int r=8*y/h;
		int c=8*x/w;
		if (placepiece(r,c)) {player=3-player; checkpass(); repaint();}
		while (p[player].Type()==playertype.AI) //while instead of if in case the human has to pass
		{
			if (!aimove()) break;
		}
		requestFocus();
		return true;
	}

	public void update(Graphics g)
	{
		if (clear)
		{
			g.setColor(getBackground());
			g.fillRect(0,0,bounds().width,bounds().height);
			g.setColor(getForeground());
			clear=false;
		}
		paint(g);
	}

/*************\
 * 7   0   1 *
 *   /---\   *
 * 6 | X | 2 *
 *   \---/   *
 * 5   4   3 *
\*************/

	int dr(int d)
	{
		switch (d)
		{
			case 0: return -1;
			case 1: return -1;
			case 2: return 0;
			case 3: return 1;
			case 4: return 1;
			case 5: return 1;
			case 6: return 0;
			case 7: return -1;
			default: return 0;
		}
	}
	int dc(int d)
	{
		switch (d)
		{
			case 0: return 0;
			case 1: return 1;
			case 2: return 1;
			case 3: return 1;
			case 4: return 0;
			case 5: return -1;
			case 6: return -1;
			case 7: return -1;
			default: return 0;
		}
	}
}
