/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet.editor;

import com.projity.configuration.Settings;
import com.projity.datatype.PercentFormat;
import com.projity.datatype.Rate;
import com.projity.field.Field;
import com.projity.field.Range;
import com.projity.pm.graphic.spreadsheet.editor.KeyboardFocusSpinner;
import com.projity.pm.graphic.spreadsheet.editor.SimpleEditor;
import com.projity.util.MathUtils;
import java.awt.Component;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;

public class SpinEditor
extends SimpleEditor {
    private Double defaultValue = new Double(1.0);
    private static double MAX_VALUE = 6.0E7;
    private static final String NUMBER_TEMPLATE = "#######################";
    Field field;
    KeyboardFocusSpinner spin;

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n2, int n3) {
        this.cachedTable = jTable;
        if (object == null || this.field.isPercent() && object instanceof Double && PercentFormat.isSpecialValue((Double)object)) {
            this.spin.setValue(this.defaultValue);
        } else {
            if (object instanceof Rate) {
                object = new Double(((Rate)object).getValue());
            }
            this.spin.setValue(object);
        }
        return this.spin;
    }

    public static JSpinner getJSpinnerInstance(Field field, double d2, boolean bl) {
        double d3 = 0.0;
        double d4 = MAX_VALUE;
        double d5 = 0.5;
        double d6 = d2;
        Range range = field.getRange();
        if (range != null) {
            d4 = range.getMaximum();
            d3 = range.getMinimum();
            d5 = range.getStep();
            d6 = Math.max(d3, Math.min(d2, d4));
        }
        JSpinner jSpinner = bl ? new KeyboardFocusSpinner(new SpinnerNumberModel(d6, d3, d4, d5)) : new JSpinner(new SpinnerNumberModel(d6, d3, d4, d5));
        String string = NUMBER_TEMPLATE.substring(Double.toString(d4).length());
        JSpinner.NumberEditor numberEditor = field.isPercent() ? new JSpinner.NumberEditor(jSpinner, string + Settings.PERCENT) : new JSpinner.NumberEditor(jSpinner, string);
        jSpinner.setEditor(numberEditor);
        numberEditor.getTextField().setHorizontalAlignment(4);
        return jSpinner;
    }

    public static Object getValue(JSpinner jSpinner, Field field) {
        JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)jSpinner.getEditor();
        Object object = null;
        try {
            if (field.isPercent()) {
                object = PercentFormat.getInstance().parseObject(numberEditor.getTextField().getText());
                object = new Double(MathUtils.roundToDecentPrecision(((Number)object).doubleValue()));
            } else {
                object = NumberFormat.getInstance().parseObject(numberEditor.getTextField().getText());
            }
        }
        catch (ParseException parseException) {
            return null;
        }
        if (field.isRate()) {
            object = new Rate(((Number)object).doubleValue());
        }
        return object;
    }

    public SpinEditor(Field field) {
        this.field = field;
        this.spin = (KeyboardFocusSpinner)SpinEditor.getJSpinnerInstance(field, 0.0, true);
    }

    public Object getCellEditorValue() {
        return SpinEditor.getValue(this.spin, this.field);
    }

    public void cancelCellEditing() {
        super.cancelCellEditing();
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        if (this.handledPostErrorFocus()) {
            this.spin.getTextField().setValue(this.spin.getValue());
            return false;
        }
        return true;
    }
}

