/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.model.cache;

import com.projity.pm.graphic.model.cache.VisibleElements;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;

public abstract class CellCache {
    protected ArrayList cache = new ArrayList();
    protected ArrayList visibleElements = new ArrayList();
    protected Map baseIndex = new HashMap();

    public Object getElement(Object object) {
        if (object == null) {
            return null;
        }
        return this.baseIndex.get(object);
    }

    public abstract Object getBase(Object var1);

    public Object getCacheElementAt(int n2) {
        return this.cache.get(n2);
    }

    public int getCacheSize() {
        return this.cache.size();
    }

    public ListIterator getCacheIterator() {
        return this.cache.listIterator();
    }

    public ListIterator getCacheIterator(int n2) {
        return this.cache.listIterator(n2);
    }

    public ArrayList getVisibleElements() {
        return this.visibleElements;
    }

    public void addVisibleElements(VisibleElements visibleElements) {
        this.visibleElements.add(visibleElements);
    }

    public void removeVisibleElements(VisibleElements visibleElements) {
        this.visibleElements.remove(visibleElements);
    }

    public void removeAllVisibleElements() {
        this.visibleElements.clear();
    }

    public void insertElement(Object object, Object object2) {
        this.cache.add(object);
        this.baseIndex.put(object2, object);
    }

    public void registerElement(Object object, Object object2) {
        this.baseIndex.put(object2, object);
    }

    public void deleteElement(Object object) {
        this.baseIndex.remove(this.getBase(object));
        this.cache.remove(object);
    }

    public void modifyBase(Object object, Object object2) {
        Object v2 = this.baseIndex.remove(object);
        this.baseIndex.put(object2, v2);
    }

    public void clear() {
        this.cache.clear();
        Iterator iterator = this.visibleElements.iterator();
        while (iterator.hasNext()) {
            ((VisibleElements)iterator.next()).clear();
        }
        this.baseIndex.clear();
    }

    public ArrayList getCache() {
        return this.cache;
    }

    Map getBaseIndex() {
        return this.baseIndex;
    }

    void setBaseIndex(Map map) {
        this.baseIndex = map;
    }

    void setCache(ArrayList arrayList) {
        this.cache = arrayList;
    }

    void copyContent(CellCache cellCache) {
        this.setCache(cellCache.getCache());
        this.setBaseIndex(cellCache.getBaseIndex());
    }

    public static Collection getContainsCollection(Collection collection) {
        if (collection == null || collection.size() < 10) {
            return collection;
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(collection);
        return hashSet;
    }
}

