/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.costing;

import com.projity.configuration.Settings;
import com.projity.datatype.Rate;
import com.projity.field.FieldContext;
import com.projity.interval.InvalidValueObjectForIntervalException;
import com.projity.pm.costing.Cost;
import com.projity.pm.costing.CostRate;
import com.projity.pm.costing.CostRateTable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;

public class CostRateTables
implements Cost,
Serializable,
Cloneable {
    public static final int DEFAULT = 0;
    protected CostRateTable[] costRateTableArray = new CostRateTable[Settings.NUM_COST_RATES];
    String[] names = null;

    String getName(int n2) {
        if (this.names == null) {
            this.names = Settings.COST_RATE_NAMES.split(";");
        }
        return this.names[n2];
    }

    public CostRateTable getCostRateTable(int n2) {
        if (this.costRateTableArray[n2] == null) {
            this.costRateTableArray[n2] = new CostRateTable(this.getName(n2));
        }
        return this.costRateTableArray[n2];
    }

    public Object clone() {
        try {
            int n2;
            CostRateTables costRateTables = (CostRateTables)super.clone();
            if (this.names != null) {
                costRateTables.names = new String[this.names.length];
            } else {
                for (n2 = 0; n2 < this.names.length; ++n2) {
                    costRateTables.names[n2] = this.names[n2] == null ? null : new String(this.names[n2]);
                }
            }
            if (this.costRateTableArray != null) {
                costRateTables.costRateTableArray = new CostRateTable[this.costRateTableArray.length];
                for (n2 = 0; n2 < this.costRateTableArray.length; ++n2) {
                    CostRateTable costRateTable = costRateTables.costRateTableArray[n2] = this.costRateTableArray[n2] == null ? null : (CostRateTable)this.costRateTableArray[n2].clone();
                    if (costRateTables.costRateTableArray[n2] == null) continue;
                    costRateTables.costRateTableArray[n2].initAfterCloning();
                }
            }
            return costRateTables;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void setCostRateTable(int n2, CostRateTable costRateTable) {
        this.costRateTableArray[n2] = costRateTable;
    }

    private CostRate getCurrent() {
        return (CostRate)this.costRateTableArray[0].findCurrent();
    }

    public double getCostPerUse() {
        return this.getCurrent().getCostPerUse();
    }

    public Rate getOvertimeRate() {
        return this.getCurrent().getOvertimeRate();
    }

    public Rate getStandardRate() {
        return this.getCurrent().getStandardRate();
    }

    public void setCostPerUse(double d2) {
        this.getCurrent().setCostPerUse(d2);
    }

    public void setOvertimeRate(Rate rate) {
        this.getCurrent().setOvertimeRate(rate);
    }

    public void setStandardRate(Rate rate) {
        this.getCurrent().setStandardRate(rate);
    }

    public CostRateTables() {
        this.costRateTableArray[0] = new CostRateTable(this.getName(0));
    }

    public long getEffectiveDate() {
        return this.getCurrent().getEffectiveDate();
    }

    public void setEffectiveDate(long l2) throws InvalidValueObjectForIntervalException {
        this.getCurrent().setEffectiveDate(l2);
    }

    public boolean isReadOnlyEffectiveDate(FieldContext fieldContext) {
        return this.getCurrent().isReadOnlyEffectiveDate(fieldContext);
    }

    public void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.names);
        ArrayList[] arrayListArray = new ArrayList[this.costRateTableArray.length];
        for (int i2 = 0; i2 < arrayListArray.length; ++i2) {
            arrayListArray[i2] = this.costRateTableArray[i2] == null ? null : this.costRateTableArray[i2].getValueObjects();
        }
        objectOutputStream.writeObject(arrayListArray);
    }

    public static CostRateTables deserialize(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        CostRateTables costRateTables = new CostRateTables();
        costRateTables.names = (String[])objectInputStream.readObject();
        ArrayList[] arrayListArray = (ArrayList[])objectInputStream.readObject();
        costRateTables.costRateTableArray = new CostRateTable[arrayListArray.length];
        for (int i2 = 0; i2 < arrayListArray.length; ++i2) {
            costRateTables.costRateTableArray[i2] = arrayListArray[i2] == null ? null : new CostRateTable(costRateTables.names[i2], arrayListArray[i2]);
        }
        return costRateTables;
    }

    public boolean fieldHideOvertimeRate(FieldContext fieldContext) {
        return this.getCurrent().fieldHideOvertimeRate(fieldContext);
    }
}

