/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.assignment;

import com.projity.algorithm.ReverseQuery;
import com.projity.algorithm.TimeIteratorGenerator;
import com.projity.algorithm.buffer.CalculatedValues;
import com.projity.algorithm.buffer.IntervalCallback;
import com.projity.algorithm.buffer.NonGroupedCalculatedValues;
import com.projity.association.AssociationList;
import com.projity.field.FieldContext;
import com.projity.functor.CollectionVisitor;
import com.projity.options.ScheduleOption;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.assignment.AssignmentDetail;
import com.projity.pm.assignment.HasAssignments;
import com.projity.pm.assignment.HasTimeDistributedData;
import com.projity.pm.assignment.TimeDistributedDataConsolidator;
import com.projity.pm.calendar.WorkCalendar;
import com.projity.pm.criticalpath.TaskSchedule;
import com.projity.pm.resource.Resource;
import com.projity.pm.task.Task;
import com.projity.pm.time.HasStartAndEnd;
import com.projity.pm.time.MutableInterval;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.TruePredicate;

public class HasAssignmentsImpl
implements HasAssignments,
HasTimeDistributedData,
Serializable,
Cloneable {
    transient AssociationList assignments;
    int schedulingRule = ScheduleOption.getInstance().getSchedulingRule();
    boolean effortDriven = ScheduleOption.getInstance().isEffortDriven();
    private static BarSeriesCallback barCallback = new BarSeriesCallback();

    public HasAssignmentsImpl() {
        this.assignments = new AssociationList();
    }

    public boolean isReadOnlyEffortDriven(FieldContext fieldContext) {
        return this.getSchedulingType() == 2;
    }

    private HasAssignmentsImpl(HasAssignmentsImpl hasAssignmentsImpl) {
        this();
        Iterator iterator = hasAssignmentsImpl.assignments.iterator();
        while (iterator.hasNext()) {
            this.assignments.add(new Assignment((Assignment)iterator.next()));
        }
    }

    public HasAssignmentsImpl(Collection collection) {
        this();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.assignments.add(new Assignment((AssignmentDetail)iterator.next()));
        }
    }

    public HasAssignments cloneWithSchedule(TaskSchedule taskSchedule) {
        HasAssignmentsImpl hasAssignmentsImpl = new HasAssignmentsImpl(this);
        hasAssignmentsImpl.setScheduleForAssignments(taskSchedule);
        return hasAssignmentsImpl;
    }

    private void setScheduleForAssignments(TaskSchedule taskSchedule) {
        for (Assignment assignment : this.assignments) {
            assignment.setTaskSchedule(taskSchedule);
            assignment.convertToBaselineAssignment(false);
        }
    }

    public HasAssignments deepCloneWithTask(Task task) {
        HasAssignmentsImpl hasAssignmentsImpl = (HasAssignmentsImpl)this.cloneWithTask(task);
        return hasAssignmentsImpl;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Object cloneWithTask(Task task) {
        HasAssignmentsImpl hasAssignmentsImpl = (HasAssignmentsImpl)this.clone();
        hasAssignmentsImpl.assignments = new AssociationList();
        Iterator iterator = this.assignments.iterator();
        while (iterator.hasNext()) {
            hasAssignmentsImpl.assignments.add(((Assignment)iterator.next()).cloneWithTask(task));
        }
        return hasAssignmentsImpl;
    }

    public Object cloneWithResource(Resource resource) {
        HasAssignmentsImpl hasAssignmentsImpl = (HasAssignmentsImpl)this.clone();
        hasAssignmentsImpl.assignments = new AssociationList();
        Iterator iterator = this.assignments.iterator();
        while (iterator.hasNext()) {
            hasAssignmentsImpl.assignments.add(((Assignment)iterator.next()).cloneWithResource(resource));
        }
        return hasAssignmentsImpl;
    }

    public AssociationList getAssignments() {
        return this.assignments;
    }

    public void addAssignment(Assignment assignment) {
        this.assignments.add(assignment);
    }

    public void removeAssignment(Assignment assignment) {
        this.assignments.remove(assignment);
    }

    public Assignment findAssignment(Resource resource) {
        Iterator iterator = this.assignments.iterator();
        Assignment assignment = null;
        while (iterator.hasNext()) {
            assignment = (Assignment)iterator.next();
            if (assignment.getResource() != resource) continue;
            return assignment;
        }
        return null;
    }

    public Assignment findAssignment(Task task) {
        Iterator iterator = this.assignments.iterator();
        Assignment assignment = null;
        while (iterator.hasNext()) {
            assignment = (Assignment)iterator.next();
            if (assignment.getTask() != task) continue;
            return assignment;
        }
        return null;
    }

    public int getSchedulingType() {
        return this.schedulingRule;
    }

    public void setSchedulingType(int n2) {
        this.schedulingRule = n2;
    }

    public boolean isEffortDriven() {
        return this.effortDriven;
    }

    public void setEffortDriven(boolean bl) {
        this.effortDriven = bl;
    }

    public void buildReverseQuery(ReverseQuery reverseQuery) {
        for (Assignment assignment : this.assignments) {
            if (assignment.isDefault() && !reverseQuery.isAllowDefaultAssignments()) continue;
            assignment.buildReverseQuery(reverseQuery);
        }
    }

    public void updateAssignment(Assignment assignment) {
        ListIterator listIterator = this.assignments.listIterator();
        Assignment assignment2 = null;
        while (listIterator.hasNext()) {
            assignment2 = (Assignment)listIterator.next();
            if (assignment2.getTask() != assignment.getTask() || assignment2.getResource() != assignment.getResource()) continue;
            listIterator.set(assignment);
            break;
        }
    }

    public static Closure forAllAssignments(Closure closure, Predicate predicate) {
        return new CollectionVisitor(closure, predicate){

            protected final Collection getCollection(Object object) {
                return ((HasAssignments)object).getAssignments();
            }
        };
    }

    public static Closure forAllAssignments(Closure closure) {
        return HasAssignmentsImpl.forAllAssignments(closure, TruePredicate.INSTANCE);
    }

    public void forEachInterval(Closure closure, Object object, WorkCalendar workCalendar) {
        NonGroupedCalculatedValues nonGroupedCalculatedValues = new NonGroupedCalculatedValues(false, 0L);
        ListIterator listIterator = this.assignments.listIterator();
        Assignment assignment = null;
        while (listIterator.hasNext()) {
            assignment = (Assignment)listIterator.next();
            barCallback.setWorkCalendar(assignment.getEffectiveWorkCalendar());
            assignment.calcDataBetween(object, null, nonGroupedCalculatedValues);
        }
        nonGroupedCalculatedValues.makeContiguousNonZero(barCallback, workCalendar);
    }

    public void forEachWorkingInterval(Closure closure, boolean bl, WorkCalendar workCalendar) {
        HasAssignmentsImpl.barCallback.initialize(workCalendar, closure, true);
        this.forEachInterval(closure, ACTUAL_WORK, workCalendar);
        HasAssignmentsImpl.barCallback.initialize(workCalendar, closure, true);
        this.forEachInterval(closure, REMAINING_WORK, workCalendar);
    }

    public double acwp(long l2, long l3) {
        return TimeDistributedDataConsolidator.acwp(l2, l3, this.childrenToRollup());
    }

    public double bac(long l2, long l3) {
        return TimeDistributedDataConsolidator.bac(l2, l3, this.childrenToRollup());
    }

    public double bcwp(long l2, long l3) {
        return TimeDistributedDataConsolidator.bcwp(l2, l3, this.childrenToRollup());
    }

    public double bcws(long l2, long l3) {
        return TimeDistributedDataConsolidator.bcws(l2, l3, this.childrenToRollup());
    }

    public double cost(long l2, long l3) {
        return TimeDistributedDataConsolidator.cost(l2, l3, this.childrenToRollup());
    }

    public double baselineCost(long l2, long l3) {
        return TimeDistributedDataConsolidator.baselineCost(l2, l3, this.childrenToRollup());
    }

    public long baselineWork(long l2, long l3) {
        return TimeDistributedDataConsolidator.baselineWork(l2, l3, this.childrenToRollup(), true);
    }

    public double actualCost(long l2, long l3) {
        return TimeDistributedDataConsolidator.actualCost(l2, l3, this.childrenToRollup());
    }

    public long work(long l2, long l3) {
        return TimeDistributedDataConsolidator.work(l2, l3, this.childrenToRollup(), true);
    }

    public long actualWork(long l2, long l3) {
        return TimeDistributedDataConsolidator.actualWork(l2, l3, this.childrenToRollup(), true);
    }

    public long remainingWork(long l2, long l3) {
        return TimeDistributedDataConsolidator.remainingWork(l2, l3, this.childrenToRollup(), true);
    }

    public void calcDataBetween(Object object, TimeIteratorGenerator timeIteratorGenerator, CalculatedValues calculatedValues) {
        Iterator iterator = this.getAssignments().iterator();
        while (iterator.hasNext()) {
            ((Assignment)iterator.next()).calcDataBetween(object, timeIteratorGenerator, calculatedValues);
        }
    }

    public static List extractOppositeList(List list, boolean bl) {
        Iterator iterator = list.iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof HasAssignments)) continue;
            HasAssignments hasAssignments = (HasAssignments)e2;
            arrayList.addAll(hasAssignments.getAssignments());
        }
        return AssociationList.extractDistinct(arrayList, bl);
    }

    public Collection childrenToRollup() {
        return this.assignments;
    }

    public long calcActiveAssignmentDuration(WorkCalendar workCalendar) {
        AssociationList associationList = this.getAssignments();
        if (associationList.size() == 1) {
            return ((Assignment)associationList.getFirst()).getDurationMillis();
        }
        AssignmentDurationSummer assignmentDurationSummer = new AssignmentDurationSummer(workCalendar);
        this.forEachWorkingInterval(assignmentDurationSummer, false, workCalendar);
        return assignmentDurationSummer.getSum();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.assignments = new AssociationList();
    }

    public double fixedCost(long l2, long l3) {
        return 0.0;
    }

    public double actualFixedCost(long l2, long l3) {
        return 0.0;
    }

    public boolean isLabor() {
        return false;
    }

    public boolean hasLaborAssignment() {
        Iterator iterator = this.assignments.iterator();
        while (iterator.hasNext()) {
            if (!((Assignment)iterator.next()).isLabor()) continue;
            return true;
        }
        return false;
    }

    public void invalidateAssignmentCalendars() {
        Iterator iterator = this.assignments.iterator();
        while (iterator.hasNext()) {
            ((Assignment)iterator.next()).invalidateAssignmentCalendar();
        }
    }

    public boolean hasActiveAssignment(long l2, long l3) {
        for (Assignment assignment : this.assignments) {
            if (!assignment.isActiveBetween(l2, l3)) continue;
            return true;
        }
        return false;
    }

    public long getEarliestAssignmentStart() {
        long l2 = Long.MAX_VALUE;
        Iterator iterator = this.assignments.iterator();
        while (iterator.hasNext()) {
            l2 = Math.min(l2, ((Assignment)iterator.next()).getStart());
        }
        return l2;
    }

    private class AssignmentDurationSummer
    implements Closure {
        private long sum;
        private WorkCalendar workCalendar;

        AssignmentDurationSummer(WorkCalendar workCalendar) {
            this.workCalendar = workCalendar;
            this.sum = 0L;
        }

        public void execute(Object object) {
            HasStartAndEnd hasStartAndEnd = (HasStartAndEnd)object;
            this.sum += this.workCalendar.compare(hasStartAndEnd.getEnd(), hasStartAndEnd.getStart(), false);
        }

        public long getSum() {
            return this.sum;
        }
    }

    private static class BarSeriesCallback
    implements IntervalCallback {
        long barStart = 0L;
        WorkCalendar workCalendar;
        MutableInterval interval = new MutableInterval(0L, 0L);
        Closure visitor;
        long previousEnd = 0L;
        private static double ALMOST_ZERO = 1.0E-5;

        private BarSeriesCallback() {
        }

        private void executeVisitor(long l2, long l3) {
            if ((l2 = Math.max(l2, this.previousEnd)) > l3) {
                return;
            }
            this.interval.setStart(l2);
            this.interval.setEnd(l3);
            this.previousEnd = l3;
            this.visitor.execute(this.interval);
            this.barStart = 0L;
        }

        public void setWorkCalendar(WorkCalendar workCalendar) {
            this.workCalendar = workCalendar;
        }

        public void add(int n2, long l2, long l3, double d2) {
            if (d2 <= ALMOST_ZERO) {
                if (this.workCalendar.compare(l3, l2, false) == 0L) {
                    return;
                }
                if (this.barStart > 0L) {
                    l2 = this.workCalendar.adjustInsideCalendar(l2, true);
                    this.executeVisitor(this.barStart, l2);
                }
            } else {
                if (this.barStart == 0L) {
                    this.barStart = this.workCalendar.adjustInsideCalendar(l2, false);
                }
                if (n2 == 0) {
                    l3 = this.workCalendar.adjustInsideCalendar(l3, true);
                    this.executeVisitor(this.barStart, l3);
                }
            }
        }

        private void initialize(WorkCalendar workCalendar, Closure closure, boolean bl) {
            if (bl) {
                this.previousEnd = 0L;
            }
            this.workCalendar = workCalendar;
            this.visitor = closure;
        }

        private void finish() {
            if (this.barStart != 0L) {
                this.executeVisitor(this.barStart, this.previousEnd);
            }
            this.barStart = 0L;
        }
    }
}

