/*
 * Decompiled with CFR 0.152.
 */
package com.projity.grouping.core.model;

import com.projity.document.Document;
import com.projity.grouping.core.Node;
import com.projity.grouping.core.NodeFactory;
import com.projity.grouping.core.hierarchy.MutableNodeHierarchy;
import com.projity.grouping.core.model.AssignmentNodeModel;
import com.projity.grouping.core.model.DefaultNodeModel;
import com.projity.grouping.core.model.NodeModel;
import com.projity.grouping.core.model.NodeModelDataFactory;
import com.projity.pm.task.Project;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.Transformer;

public class NodeModelFactory {
    protected static NodeModelFactory instance = null;

    protected NodeModelFactory() {
    }

    public static NodeModelFactory getInstance() {
        if (instance == null) {
            instance = new NodeModelFactory();
        }
        return instance;
    }

    public NodeModel createNodeModel() {
        return new DefaultNodeModel();
    }

    public NodeModel createNodeModel(NodeModelDataFactory nodeModelDataFactory) {
        if (nodeModelDataFactory != null && nodeModelDataFactory.containsAssignments()) {
            return new AssignmentNodeModel(nodeModelDataFactory);
        }
        return new DefaultNodeModel(nodeModelDataFactory);
    }

    public NodeModel createAssignmentNodeModel(DefaultNodeModel defaultNodeModel, Document document, boolean bl) {
        return new AssignmentNodeModel((MutableNodeHierarchy)defaultNodeModel.getHierarchy().clone(), defaultNodeModel.getDataFactory(), document, bl);
    }

    public NodeModel createNodeModelFromCollection(Collection collection, NodeModelDataFactory nodeModelDataFactory) {
        NodeModel nodeModel = this.createNodeModel(nodeModelDataFactory);
        nodeModel.addImplCollection(null, collection, 0);
        return nodeModel;
    }

    public void updateNodeModelFromCollection(NodeModel nodeModel, Collection collection, NodeModelDataFactory nodeModelDataFactory, int n2) {
        nodeModel.removeAll(0);
        nodeModel.setDataFactory(nodeModelDataFactory);
        nodeModel.addImplCollection(null, collection, 0);
        nodeModel.getHierarchy().setNbEndVoidNodes(n2);
        nodeModel.getHierarchy().checkEndVoidNodes(n2);
        nodeModel.getHierarchy().fireUpdate();
    }

    public NodeModel replicate(NodeModel nodeModel, Transformer transformer) {
        NodeModel nodeModel2 = NodeModelFactory.getInstance().createNodeModel();
        this.replicate(nodeModel, null, null, nodeModel2, transformer);
        return nodeModel2;
    }

    private void replicate(NodeModel nodeModel, Node node, Node node2, NodeModel nodeModel2, Transformer transformer) {
        List list = nodeModel.getHierarchy().getChildren(node);
        if (list != null) {
            for (Node node3 : list) {
                Object object = transformer.transform(node3.getImpl());
                if (object == null) continue;
                Node node4 = NodeFactory.getInstance().createNode(object);
                nodeModel2.add(node2, node4, 0);
                this.replicate(nodeModel, node3, node4, nodeModel2, transformer);
            }
        }
    }

    public static NodeModel createTaskModel(Project project) {
        NodeModel nodeModel = project.getTaskOutline();
        if (nodeModel instanceof AssignmentNodeModel) {
            ((AssignmentNodeModel)nodeModel).addAssignments();
        }
        return nodeModel;
    }

    public static NodeModel createResourceModel(Project project) {
        NodeModel nodeModel = project.getResourcePool().getResourceOutline();
        if (nodeModel instanceof AssignmentNodeModel) {
            ((AssignmentNodeModel)nodeModel).addAssignments();
        }
        return nodeModel;
    }
}

