/* REXX PROGRAM */
/* This REXX program expects Omnifile or CCv2 to be the host environment */
/* If you are attempting to change this file, you will normally only need to change the command in the CHANGE_REXX_VARIABLES subroutine. */


/* MAIN SUBROUTINE */
szEnvironment = address()
IF ((szEnvironment <> "Omnifile") & (szEnvironment <> "Contacts")) THEN DO
	SAY "This rexx file can only be run by Omnifile or Contact Connection, not directly."
	RETURN 1
	END

/* Load the Rexx variables based on the arguments the user passed in. */
FileOut = ARG(1)
HeaderFile = ARG(2)
Delimiter = ARG(3)
QuoteFields = ARG(4)
AddHeaderLine = ARG(5)

/* Make sure the required arguments where given. */
IF FileOut = "" THEN DO
	SAY "The following arguments are expected: FILEOUT HEADERFILE DELIMITER"
	SAY "    FILEOUT is required."
	SAY "    HEADERFILE will default to FILEOUT if not given."
	SAY "    DELIMITER will default to ',' if not given."
	SAY "    'QuoteFields' - optional argument to quote each field"
	SAY "    'AddHeaderLine' - optional argument to add header line to output file"
	RETURN 1
	END
/* Set the default header file to the output file and the default delimiter to ','. */
IF HeaderFile = "" THEN HeaderFile = FileOut
IF Delimiter = "" THEN Delimiter = ','
SetDefaultDelimiter(Delimiter)

/* Load the Header Line and pass it to Omnifile in order to initialize the import. */
HeaderLine = LINEIN(HeaderFile)
SetHeaderLine(HeaderLine)
Say "AddHeaderLine = "AddHeaderLine
IF (AddHeaderLine \= "") & (HeaderFile \= FileOut) THEN DO
	LINEOUT(FileOut, HeaderLine)
	END

/* Get each matching record and output it */
Rec = GetRec("First")
DO WHILE Rec \= 0
	SAY "Now writing rec# "Rec
	Result = SetRexxVariablesFromRec(Rec)
	CALL CHANGE_REXX_VARIABLES
	Line = MakeOutputLine(QuoteFields)
	LINEOUT(FileOut, Line)
	Rec = GetRec("Next")
	END

/* Close all the files. */
Result = stream(FileOut, 'c', 'close')
IF HeaderFile \= FileOut THEN stream(HeaderFile, 'c', 'close')
RETURN 0


/* SUBROUTINE */
CHANGE_REXX_VARIABLES:
/* If necessary, change fields from a format suitable for import. */
/* This subroutine is usually the only portion that the user needs to change. */

RETURN

