/*
 * Decompiled with CFR 0.152.
 */
package eap.fitsbrowser;

import eap.applet.DetachableApplet;
import eap.filter.AppletPasswordProvider;
import eap.filter.FilterException;
import eap.fits.FitsException;
import eap.fits.FitsFile;
import eap.fitsbrowser.FITSFileDisplay;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.net.URL;
import java.security.AccessControlException;
import javax.swing.JTextArea;

public class BrowserApplet
extends DetachableApplet {
    FITSFileDisplay display;
    private String new_password;
    private AppletPasswordProvider password;

    public void init() {
        this.new_password = null;
        this.display = new FITSFileDisplay();
        this.password = new AppletPasswordProvider(this);
        this.display.setPasswordProvider(this.password);
        this.getContentPane().add(this.display);
        String string = this.getParameter("FILE");
        new BackgroundLoader(string).start();
    }

    private void reportError(String string, String string2, Throwable throwable) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        Container container = this.getContentPane();
        container.add((Component)jTextArea, "North");
        jTextArea.append("Could not read " + string + "\n");
        if (!string2.equals("")) {
            jTextArea.append("\n");
        }
        jTextArea.append(string2);
        if (!string2.equals("") && !string2.endsWith("\n")) {
            jTextArea.append("\n");
        }
        jTextArea.append("\n" + throwable.toString() + "\n");
        try {
            for (Throwable throwable2 = throwable.getCause(); throwable2 != null; throwable2 = throwable2.getCause()) {
                jTextArea.append(throwable2.toString() + "\n");
            }
        }
        catch (Throwable throwable3) {
            // empty catch block
        }
    }

    public void forgetPassword() {
        this.password.forgetPassword();
    }

    private class BackgroundLoader
    extends Thread {
        String file;

        public BackgroundLoader(String string) {
            this.file = string;
        }

        public void run() {
            try {
                if (this.file != null) {
                    BrowserApplet.this.display.load(new URL(BrowserApplet.this.getDocumentBase(), this.file));
                } else {
                    BrowserApplet.this.display.load(FitsFile.createEmpty());
                }
                BrowserApplet.this.password.savePassword();
            }
            catch (FitsException fitsException) {
                BrowserApplet.this.reportError(this.file, "The data do not conform to the FITS standard.\nIf this is an encrypted file, then you may have entered the wrong encryption key\nOtherwise, the data may be corrupted or incorrectly formatted\n", fitsException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                BrowserApplet.this.reportError(this.file, "The FITS file is too large to view with this applet", outOfMemoryError);
            }
            catch (FilterException filterException) {
                BrowserApplet.this.reportError(this.file, "Error applying " + filterException.getFilter(), filterException);
            }
            catch (AccessControlException accessControlException) {
                String string = BrowserApplet.this.getCodeBase().getHost();
                String string2 = ".";
                if (string != null && !string.equals("")) {
                    string2 = " which in this case is " + string;
                }
                BrowserApplet.this.reportError(this.file, "Unsigned applets are usually restricted to reading data from the same server as the one on which the applet resides" + string2, accessControlException);
            }
            catch (IOException iOException) {
                BrowserApplet.this.reportError(this.file, "There was an error transferring the file to your browser. This could be due to network trouble, or to a problem on the web server. You can try again later, but if this problem persists, report it to the administrator of these web pages", iOException);
            }
            catch (Throwable throwable) {
                BrowserApplet.this.reportError(this.file, "", throwable);
            }
        }
    }
}

