/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;

public class Configuration {
    private static final String CONFIG_FILE = "config";
    private static final String CONFIG_FILE_HEADER = "ObservationManager configfile\n#Written by version: 1.321\n#If you edit this, make sure you know what you're doing...";
    private Properties persistence = null;
    private boolean changed = false;

    public Configuration() {
        this(null);
    }

    public Configuration(String path) {
        try {
            this.loadConfiguration(path);
        }
        catch (IOException ioe) {
            System.out.println("Cannot find configuration file " + path + "\n" + ioe);
            return;
        }
    }

    public void loadConfiguration(String path) throws IOException {
        this.persistence = new Properties();
        if (!new File(path = this.getConfigPath(path) + File.separatorChar + CONFIG_FILE).exists()) {
            return;
        }
        FileInputStream fis = new FileInputStream(path);
        BufferedInputStream bis = new BufferedInputStream(fis);
        try {
            this.persistence.load(bis);
        }
        catch (IOException ioe) {
            System.err.println("Cannot load configuration.\n" + ioe);
        }
    }

    public boolean saveConfiguration(String path) {
        if (!this.changed) {
            return true;
        }
        path = this.getConfigPath(path);
        new File(path).mkdirs();
        path = path + File.separatorChar + CONFIG_FILE;
        try {
            FileOutputStream fos = new FileOutputStream(path);
            this.persistence.store(new BufferedOutputStream(fos), CONFIG_FILE_HEADER);
            fos.close();
        }
        catch (IOException ioe) {
            System.err.println("Cannot save configuration file " + path);
            return false;
        }
        return true;
    }

    public void setConfig(String key, String value) {
        if (value == null || "".equals(value.trim())) {
            this.persistence.remove(key);
            this.changed = true;
            return;
        }
        this.persistence.setProperty(key, value);
        this.changed = true;
    }

    public String getConfig(String key) {
        return this.persistence.getProperty(key);
    }

    public Set getConfigKeys() {
        return this.persistence.keySet();
    }

    public String getConfig(String key, String defaultValue) {
        return this.persistence.getProperty(key, defaultValue);
    }

    public String getConfigPath(String path) {
        if (path == null) {
            path = System.getProperty("user.home");
        }
        path = path + File.separatorChar + ".observationManager";
        return path;
    }
}

