/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.statistics;

import de.lehmannet.om.IObservation;
import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.ITarget;
import de.lehmannet.om.ui.catalog.CatalogLoader;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.navigation.tableModel.AbstractSchemaTableModel;
import de.lehmannet.om.ui.panel.AbstractPanel;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class DetailPanel
extends AbstractPanel
implements ActionListener {
    private JComboBox catalogBox = new JComboBox();
    private JTable table = new JTable();
    private AbstractSchemaTableModel model = null;
    private JScrollPane scrollTable = null;
    private ObservationManager om = null;
    private CatalogLoader loader = null;
    private ITarget selectedTarget = null;

    public DetailPanel(ObservationManager om, AbstractSchemaTableModel model) {
        super(true);
        this.model = model;
        this.om = om;
        this.table.setModel(this.model);
        this.table.setSelectionMode(0);
        ListSelectionModel lsm = this.table.getSelectionModel();
        lsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int selectedRow = lsm.getMinSelectionIndex();
                    IObservation obs = (IObservation)DetailPanel.this.model.getValueAt(selectedRow, 1);
                    DetailPanel.this.om.updateUI((ISchemaElement)obs);
                }
            }
        });
        this.table.setDefaultRenderer(ITarget.class, new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                DefaultTableCellRenderer cr = new DefaultTableCellRenderer();
                cr.setHorizontalAlignment(0);
                String text = null;
                if (value != null) {
                    ITarget t = (ITarget)value;
                    text = t.getDisplayName();
                    cr.setText(text);
                    cr.setBackground(Color.LIGHT_GRAY);
                }
                return cr;
            }
        });
        this.table.setDefaultRenderer(IObservation.class, new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                DefaultTableCellRenderer cr = new DefaultTableCellRenderer();
                cr.setHorizontalAlignment(0);
                if (value != null) {
                    IObservation o = (IObservation)value;
                    DateFormat df = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
                    df.setCalendar(o.getBegin());
                    cr.setText(df.format(o.getBegin().getTime()));
                }
                if (isSelected) {
                    cr.setForeground(Color.RED);
                } else {
                    cr.setForeground(Color.BLACK);
                }
                return cr;
            }
        });
        this.table.setAutoResizeMode(0);
        TableColumn c = this.table.getColumnModel().getColumn(0);
        c.setPreferredWidth(this.model.getColumnSize(0));
        c = this.table.getColumnModel().getColumn(1);
        c.setPreferredWidth(this.model.getColumnSize(1));
        this.table.setAutoResizeMode(2);
        this.table.setDoubleBuffered(true);
        this.scrollTable = new JScrollPane(this.table);
        this.createPanel();
    }

    public void actionPerformed(ActionEvent e) {
    }

    public ISchemaElement createSchemaElement() {
        return this.model.getSchemaElement(0);
    }

    public ISchemaElement getSchemaElement() {
        return this.model.getSchemaElement(0);
    }

    public ISchemaElement updateSchemaElement() {
        return this.model.getSchemaElement(0);
    }

    private void createPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        this.setLayout(gridbag);
        ConstraintsBuilder.buildConstraints(constraints, 0, 0, 1, 1, 100, 99);
        constraints.fill = 1;
        gridbag.setConstraints(this.scrollTable, constraints);
        this.add(this.scrollTable);
    }
}

