/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.panel;

import de.lehmannet.om.GenericTarget;
import de.lehmannet.om.IObserver;
import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.ITarget;
import de.lehmannet.om.ui.container.TargetContainer;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.panel.AbstractPanel;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;

public class GenericTargetPanel
extends AbstractPanel {
    private static final long serialVersionUID = 9175024145109241504L;
    private ObservationManager observationManager = null;
    private GenericTarget target = null;
    private TargetContainer targetContainer = null;

    public GenericTargetPanel(ObservationManager om, ITarget target, Boolean editable) throws IllegalArgumentException {
        super(editable);
        if (target != null && !(target instanceof GenericTarget)) {
            throw new IllegalArgumentException("Passed ITarget must derive from de.lehmannet.om.GenericTarget\n");
        }
        this.target = (GenericTarget)target;
        this.observationManager = om;
        this.createPanel();
    }

    public ISchemaElement createSchemaElement() {
        IObserver observer;
        String name = this.targetContainer.getName();
        String datasource = this.targetContainer.getDatasource();
        if (!this.targetContainer.checkOrigin(datasource, observer = this.targetContainer.getObserver())) {
            return null;
        }
        this.target = observer != null ? new GenericTarget(name, observer) : new GenericTarget(name, datasource);
        this.targetContainer.setTarget((ITarget)this.target);
        this.updateSchemaElement();
        return this.target;
    }

    public ISchemaElement getSchemaElement() {
        return this.target;
    }

    public ISchemaElement updateSchemaElement() {
        if (this.target == null) {
            return null;
        }
        ITarget t = this.targetContainer.updateTarget();
        if (t == null) {
            return null;
        }
        this.target = (GenericTarget)t;
        return this.target;
    }

    private void createPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        this.setLayout(gridbag);
        ConstraintsBuilder.buildConstraints(constraints, 0, 0, 4, 1, 45, 1);
        constraints.fill = 2;
        this.targetContainer = new TargetContainer(this.observationManager, (ITarget)this.target, super.isEditable(), false);
        gridbag.setConstraints(this.targetContainer, constraints);
        this.add(this.targetContainer);
        ConstraintsBuilder.buildConstraints(constraints, 0, 1, 4, 1, 45, 99);
        constraints.fill = 1;
        JLabel Lfill = new JLabel("");
        gridbag.setConstraints(Lfill, constraints);
        this.add(Lfill);
    }
}

