/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.extension;

import de.lehmannet.om.ui.catalog.ICatalog;
import de.lehmannet.om.ui.extension.IExtension;
import de.lehmannet.om.ui.preferences.PreferencesPanel;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JMenu;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public abstract class AbstractExtension
implements IExtension {
    protected String OAL_EXTENSION_FILE = "noCorrectSetByExtension";
    protected HashMap panels = new HashMap();
    protected HashMap dialogs = new HashMap();

    public abstract String getName();

    public abstract float getVersion();

    public abstract JMenu getMenu();

    public abstract PreferencesPanel getPreferencesPanel();

    public abstract Set getSupportedXSITypes(int var1);

    public abstract boolean isCreationAllowed(String var1);

    public abstract String getDisplayNameForXSIType(String var1);

    public abstract ICatalog[] getCatalogs(File var1);

    public Set getAllSupportedXSITypes() {
        HashSet result = new HashSet();
        result.addAll(this.getSupportedXSITypes(10));
        result.addAll(this.getSupportedXSITypes(7));
        return result;
    }

    public String getPanelForXSIType(String xsiType, int schemaElementConstant) {
        Object o = this.panels.get(new Integer(schemaElementConstant));
        if (o == null) {
            return null;
        }
        HashMap hm = (HashMap)o;
        return (String)hm.get(xsiType);
    }

    public String getDialogForXSIType(String xsiType, int schemaElementConstant) {
        Object o = this.dialogs.get(new Integer(schemaElementConstant));
        if (o == null) {
            return null;
        }
        HashMap hm = (HashMap)o;
        return (String)hm.get(xsiType);
    }

    public boolean equals(Object o) {
        IExtension ext;
        return o instanceof IExtension && (ext = (IExtension)o).getName().equals(this.getName()) && ext.getVersion() == this.getVersion();
    }

    public boolean addOALExtensionElement(Element docElement) {
        NodeList list = docElement.getElementsByTagName("xsd:include");
        NamedNodeMap attributes = null;
        for (int i = 0; i < list.getLength(); ++i) {
            attributes = list.item(i).getAttributes();
            if (!this.OAL_EXTENSION_FILE.equals(attributes.getNamedItem("schemaLocation").getNodeValue())) continue;
            return true;
        }
        Document doc = docElement.getOwnerDocument();
        Element e = doc.createElement("xsd:include");
        e.setAttribute("schemaLocation", this.OAL_EXTENSION_FILE);
        docElement.appendChild(e);
        return true;
    }
}

