/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.dialog;

import de.lehmannet.om.ui.navigation.ObservationManager;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.JDialog;

public class OMDialog
extends JDialog {
    private static final long serialVersionUID = -304493814237276957L;
    public static final String DIALOG_SIZE_KEY = "dialog.size.";
    private ObservationManager observationManager = null;
    private long dialogID = -1L;

    public OMDialog(ObservationManager om) {
        super((Frame)om, true);
        this.observationManager = om;
    }

    public void setSize(long uniqueDialogID, int width, int height) {
        this.dialogID = uniqueDialogID;
        String sizeString = this.observationManager.getConfiguration().getConfig(DIALOG_SIZE_KEY + this.dialogID);
        if (sizeString != null) {
            String x = sizeString.substring(0, sizeString.indexOf("x"));
            String y = sizeString.substring(sizeString.indexOf("x") + 1);
            try {
                int w = Integer.parseInt(x);
                int h = Integer.parseInt(y);
                super.setSize(w, h);
            }
            catch (NumberFormatException nfe) {
                super.setSize(width, height);
            }
        } else {
            super.setSize(width, height);
        }
    }

    public void dispose() {
        this.saveWindowSize();
        super.dispose();
    }

    private void saveWindowSize() {
        if (this.dialogID != -1L) {
            Dimension size = super.getSize();
            this.observationManager.getConfiguration().setConfig(DIALOG_SIZE_KEY + this.dialogID, size.width + "x" + size.height);
        }
    }
}

