/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.dialog;

import de.lehmannet.om.IEquipment;
import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.ui.dialog.EquipmentLeaf;
import de.lehmannet.om.ui.dialog.UnavailableEquipmentDialog;
import java.awt.EventQueue;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTree;

class CheckBoxEquipmentNode
extends Vector {
    private String text = null;
    private boolean selected = false;
    private Icon expandedIcon = null;
    private Icon collapsedIcon = null;
    private UnavailableEquipmentDialog dialog = null;
    private int selectedChildren = 0;

    public CheckBoxEquipmentNode(UnavailableEquipmentDialog dialog, String text, ISchemaElement[] elements, Icon expanded, Icon collapsed) {
        this.dialog = dialog;
        this.text = text;
        this.expandedIcon = expanded;
        this.collapsedIcon = collapsed;
        int noAvailable = 0;
        if (elements != null) {
            for (int i = 0; i < elements.length; ++i) {
                super.add(new EquipmentLeaf(this.dialog, this, elements[i]));
                if (!((IEquipment)elements[i]).isAvailable()) continue;
                ++noAvailable;
            }
            if (elements.length > 0) {
                this.selectedChildren = noAvailable;
                if (noAvailable > 0) {
                    this.selected = true;
                }
            }
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean newValue) {
        this.selected = newValue;
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            ((EquipmentLeaf)iterator.next()).setSelected(newValue);
        }
        this.selectedChildren = newValue ? super.size() : 0;
        final JTree tree = this.dialog.getTree();
        if (tree != null) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    tree.updateUI();
                }
            });
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String newValue) {
        this.text = newValue;
    }

    public String toString() {
        return this.text;
    }

    public Icon getExpandedIcon() {
        return this.expandedIcon;
    }

    public Icon getCollapsedIcon() {
        return this.collapsedIcon;
    }

    public void childChangedToSelected() {
        ++this.selectedChildren;
        this.selected = this.selectedChildren != 0;
    }

    public void childChangedToUnselected() {
        --this.selectedChildren;
        this.selected = this.selectedChildren != 0;
    }
}

