/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.container;

import de.lehmannet.om.Constellation;
import de.lehmannet.om.EquPosition;
import de.lehmannet.om.IObserver;
import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.ITarget;
import de.lehmannet.om.ui.box.ConstellationBox;
import de.lehmannet.om.ui.box.ObserverBox;
import de.lehmannet.om.ui.container.EquPositionContainer;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import de.lehmannet.om.ui.util.EditPopupHandler;
import de.lehmannet.om.ui.util.OMLabel;
import de.lehmannet.om.util.AtlasUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class TargetContainer
extends Container
implements MouseListener {
    private static final long serialVersionUID = -9052717626196198395L;
    final PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private ObservationManager observationManager = null;
    private ITarget target = null;
    private boolean editable = false;
    private boolean positionDisabled = false;
    private JTextField targetName = null;
    private JTextField targetAliasNames = null;
    private EquPositionContainer equPosition = null;
    private JTextField targetConstellation = new JTextField();
    private ConstellationBox constellationBox = null;
    private JTextField targetDatasource = null;
    private ObserverBox sourceObserverBox = null;
    private JTextArea notes = null;

    public TargetContainer(ObservationManager om, ITarget target, boolean editable, boolean positionDisabled) {
        this.target = target;
        this.observationManager = om;
        this.editable = editable;
        this.positionDisabled = positionDisabled;
        this.constellationBox = new ConstellationBox(Boolean.valueOf(this.observationManager.getConfiguration().getConfig("om.constellation.useI18N", "true")));
        this.createPanel();
        if (target != null) {
            this.loadSchemaElement();
        }
    }

    public ITarget updateTarget() {
        String name = this.getName();
        if (name == null || "".equals(name.trim())) {
            this.createWarning(this.bundle.getString("target.warning.noName"));
            return null;
        }
        this.target.setName(name);
        IObserver observer = this.getObserver();
        if (observer == null) {
            this.createWarning(this.bundle.getString("target.warning.noObserver"));
            return null;
        }
        this.target.setObserver(observer);
        String[] aliasNames = this.getAliasNames();
        this.target.setAliasNames(aliasNames);
        EquPosition pos = this.getPosition();
        this.target.setPosition(pos);
        Constellation constellation = this.getConstellation();
        this.target.setConstellation(constellation);
        this.target.setNotes(this.notes.getText().trim());
        return this.target;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            new EditPopupHandler(e.getX(), e.getY(), this.notes);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public String getDatasource() {
        return this.targetDatasource.getText();
    }

    public IObserver getObserver() {
        return (IObserver)this.sourceObserverBox.getSelectedSchemaElement();
    }

    public Constellation getConstellation() {
        if (!this.editable) {
            String c = this.targetConstellation.getText();
            Constellation constelltion = Constellation.getInstance((String)c);
            if (constelltion != null) {
                return constelltion;
            }
            return null;
        }
        return this.constellationBox.getSelectedConstellation();
    }

    public EquPosition getPosition() {
        return this.equPosition.getEquPosition();
    }

    public void setPosition(EquPosition equPos) {
        this.equPosition.setEquPosition(equPos);
    }

    public void setTarget(ITarget target) {
        this.target = target;
    }

    public String getName() {
        return this.targetName.getText();
    }

    public String getNotes() {
        return this.notes.getText().trim();
    }

    public String[] getAliasNames() {
        ArrayList<String> list = new ArrayList<String>();
        String aliasNames = this.targetAliasNames.getText();
        if (aliasNames != null && !"".equals(aliasNames)) {
            StringTokenizer tokenizer = new StringTokenizer(aliasNames, ";");
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken().trim());
            }
            return list.toArray(new String[0]);
        }
        return null;
    }

    public boolean checkOrigin(String datasource, IObserver observer) {
        if ((datasource == null || "".equals(datasource)) && observer == null) {
            this.createWarning(this.bundle.getString("target.warning.datasourceOrObserver"));
            return false;
        }
        if (datasource != null && !"".equals(datasource) && observer != null) {
            this.createWarning(this.bundle.getString("target.warning.datasourceOrObserverBoth"));
            return false;
        }
        return true;
    }

    private void loadSchemaElement() {
        this.targetName.setText(this.target.getDisplayName());
        this.targetName.setEditable(this.editable);
        String[] aliasNames = this.target.getAliasNames();
        StringBuffer buffer = new StringBuffer();
        if (aliasNames != null) {
            for (int i = 0; i < aliasNames.length; ++i) {
                buffer.append(aliasNames[i]);
                if (i >= aliasNames.length - 1) continue;
                buffer.append("; ");
            }
            this.targetAliasNames.setText(buffer.toString());
        }
        this.targetAliasNames.setEditable(this.editable);
        Constellation c = this.target.getConstellation();
        if (c != null) {
            this.constellationBox.setSelectedConstellation(c);
            String cName = null;
            boolean i18N = Boolean.valueOf(this.observationManager.getConfiguration().getConfig("om.constellation.useI18N", "true"));
            cName = i18N ? c.getDisplayName() : c.getName();
            this.targetConstellation.setText(cName);
        }
        if (this.positionDisabled) {
            this.targetConstellation.setEditable(false);
        } else {
            this.targetConstellation.setEditable(this.editable);
        }
        if (this.target.getPosition() != null) {
            this.equPosition.setEquPosition(this.target.getPosition());
        }
        if (this.positionDisabled) {
            this.equPosition.setEditable(false);
        } else {
            this.equPosition.setEditable(this.editable);
        }
        if (this.target.getDatasource() != null && !"".equals(this.target.getDatasource())) {
            this.targetDatasource.setText(this.target.getDatasource());
            this.targetDatasource.setEditable(this.editable);
        } else if (!this.editable) {
            IObserver observer = this.target.getObserver();
            this.targetDatasource.setText(observer.getDisplayName());
            this.targetDatasource.setEditable(this.editable);
        }
        if (this.target.getNotes() != null) {
            this.notes.setText(this.target.getNotes());
        }
        this.notes.setEditable(this.editable);
    }

    private void createPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        this.setLayout(gridbag);
        ConstraintsBuilder.buildConstraints(constraints, 0, 0, 1, 1, 5, 1);
        OMLabel LtargetName = new OMLabel(this.bundle.getString("target.label.name"), true);
        LtargetName.setToolTipText(this.bundle.getString("target.tooltip.name"));
        gridbag.setConstraints(LtargetName, constraints);
        this.add(LtargetName);
        ConstraintsBuilder.buildConstraints(constraints, 1, 0, 1, 1, 45, 1);
        constraints.fill = 2;
        this.targetName = new JTextField();
        this.targetName.setEditable(this.editable);
        this.targetName.setToolTipText(this.bundle.getString("target.tooltip.name"));
        gridbag.setConstraints(this.targetName, constraints);
        this.add(this.targetName);
        ConstraintsBuilder.buildConstraints(constraints, 2, 0, 1, 1, 5, 1);
        constraints.fill = 0;
        constraints.anchor = 13;
        OMLabel LAliasName = new OMLabel(this.bundle.getString("target.label.aliasNames"), 4, false);
        LAliasName.setToolTipText(this.bundle.getString("target.tooltip.aliasNames"));
        gridbag.setConstraints(LAliasName, constraints);
        this.add(LAliasName);
        ConstraintsBuilder.buildConstraints(constraints, 3, 0, 5, 1, 45, 1);
        constraints.fill = 2;
        constraints.anchor = 17;
        this.targetAliasNames = new JTextField();
        this.targetAliasNames.setToolTipText(this.bundle.getString("target.tooltip.aliasNames"));
        this.targetAliasNames.setEditable(this.editable);
        gridbag.setConstraints(this.targetAliasNames, constraints);
        this.add(this.targetAliasNames);
        ConstraintsBuilder.buildConstraints(constraints, 0, 1, 2, 3, 100, 1);
        constraints.fill = 2;
        this.equPosition = new EquPositionContainer(null, this.editable);
        gridbag.setConstraints(this.equPosition, constraints);
        if (this.positionDisabled) {
            this.equPosition.setEditable(false);
        } else {
            this.equPosition.setEditable(this.editable);
        }
        this.add(this.equPosition);
        ConstraintsBuilder.buildConstraints(constraints, 0, 4, 1, 1, 4, 1);
        OMLabel LConstallation = new OMLabel(this.bundle.getString("target.label.constellation"), false);
        LConstallation.setToolTipText(this.bundle.getString("target.tooltip.constellation"));
        gridbag.setConstraints(LConstallation, constraints);
        this.add(LConstallation);
        OMLabel targetDatasourceLabel = null;
        if (this.target != null && !this.editable) {
            ConstraintsBuilder.buildConstraints(constraints, 1, 4, 1, 1, 45, 1);
            constraints.fill = 2;
            this.targetConstellation.setToolTipText(this.bundle.getString("target.tooltip.constellation"));
            this.targetConstellation.setEditable(this.editable);
            gridbag.setConstraints(this.targetConstellation, constraints);
            this.add(this.targetConstellation);
            targetDatasourceLabel = new OMLabel(this.bundle.getString("target.label.datasource"), 4, true);
            targetDatasourceLabel.setToolTipText(this.bundle.getString("target.tooltip.datasource"));
            ConstraintsBuilder.buildConstraints(constraints, 2, 4, 1, 1, 5, 1);
            constraints.fill = 0;
            constraints.anchor = 13;
            gridbag.setConstraints(targetDatasourceLabel, constraints);
            this.targetDatasource = new JTextField();
            this.targetDatasource.setToolTipText(this.bundle.getString("target.tooltip.datasource"));
            this.targetDatasource.setEditable(this.editable);
            this.add(targetDatasourceLabel);
            this.createObserverDropDownBox();
            ConstraintsBuilder.buildConstraints(constraints, 3, 4, 5, 1, 45, 1);
            constraints.fill = 2;
            gridbag.setConstraints(this.targetDatasource, constraints);
            this.add(this.targetDatasource);
            ConstraintsBuilder.buildConstraints(constraints, 0, 5, 1, 1, 100, 1);
            OMLabel Lnotes = new OMLabel(this.bundle.getString("target.label.notes"), false);
            Lnotes.setToolTipText(this.bundle.getString("target.tooltip.notes"));
            gridbag.setConstraints(Lnotes, constraints);
            this.add(Lnotes);
            ConstraintsBuilder.buildConstraints(constraints, 0, 6, 8, 2, 100, 45);
            constraints.fill = 2;
            this.notes = new JTextArea(10, 40);
            this.notes.setToolTipText(this.bundle.getString("target.tooltip.notes"));
            this.notes.setEditable(this.editable);
            this.notes.setLineWrap(true);
            this.notes.addMouseListener(this);
            if (this.target != null) {
                this.notes.setText(this.target.getNotes());
            }
            if (!this.editable) {
                if (this.observationManager.isNightVisionEnabled()) {
                    this.notes.setBackground(new Color(255, 175, 175));
                } else {
                    this.notes.setBackground(Color.WHITE);
                }
            }
            JScrollPane descriptionScroll = new JScrollPane(this.notes);
            descriptionScroll.setMinimumSize(new Dimension(300, 60));
            gridbag.setConstraints(descriptionScroll, constraints);
            this.add(descriptionScroll);
            EquPosition pos = this.target.getPosition();
            if (pos != null) {
                JLabel LAtlas = new JLabel(this.bundle.getString("target.label.atlas"));
                ConstraintsBuilder.buildConstraints(constraints, 0, 8, 8, 1, 100, 1);
                gridbag.setConstraints(LAtlas, constraints);
                this.add(LAtlas);
                JLabel LUranometeria = new JLabel(this.bundle.getString("target.label.uranometeria"));
                JTextField uranometeria = new JTextField("" + AtlasUtil.getUranometriaPage((EquPosition)pos), 4);
                uranometeria.setEditable(false);
                ConstraintsBuilder.buildConstraints(constraints, 0, 9, 1, 1, 45, 1);
                constraints.fill = 0;
                constraints.anchor = 13;
                gridbag.setConstraints(LUranometeria, constraints);
                this.add(LUranometeria);
                ConstraintsBuilder.buildConstraints(constraints, 1, 9, 1, 1, 45, 1);
                constraints.fill = 2;
                gridbag.setConstraints(uranometeria, constraints);
                this.add(uranometeria);
                JLabel LUranometeria2 = new JLabel(this.bundle.getString("target.label.uranometeria2"));
                JTextField uranometeria2 = new JTextField("" + AtlasUtil.getUranometria2000Page((EquPosition)pos), 4);
                uranometeria2.setEditable(false);
                ConstraintsBuilder.buildConstraints(constraints, 2, 9, 1, 1, 45, 1);
                constraints.fill = 0;
                constraints.anchor = 13;
                gridbag.setConstraints(LUranometeria2, constraints);
                this.add(LUranometeria2);
                ConstraintsBuilder.buildConstraints(constraints, 3, 9, 1, 1, 45, 1);
                constraints.fill = 2;
                gridbag.setConstraints(uranometeria2, constraints);
                this.add(uranometeria2);
                JLabel LMillenium = new JLabel(this.bundle.getString("target.label.milleniumStarAtlas"));
                JTextField millenium = new JTextField("" + AtlasUtil.getMilleniumStarAtlasPage((EquPosition)pos), 4);
                millenium.setEditable(false);
                ConstraintsBuilder.buildConstraints(constraints, 4, 9, 1, 1, 45, 1);
                constraints.fill = 0;
                constraints.anchor = 13;
                gridbag.setConstraints(LMillenium, constraints);
                this.add(LMillenium);
                ConstraintsBuilder.buildConstraints(constraints, 5, 9, 1, 1, 45, 1);
                constraints.fill = 2;
                gridbag.setConstraints(millenium, constraints);
                this.add(millenium);
                JLabel LStarAtlas200 = new JLabel(this.bundle.getString("target.label.skyAtlas2000"));
                JTextField startAtlas = new JTextField("" + AtlasUtil.getSkyAtlas2000Page((EquPosition)pos), 4);
                startAtlas.setEditable(false);
                ConstraintsBuilder.buildConstraints(constraints, 6, 9, 1, 1, 45, 1);
                constraints.fill = 0;
                constraints.anchor = 13;
                gridbag.setConstraints(LStarAtlas200, constraints);
                this.add(LStarAtlas200);
                ConstraintsBuilder.buildConstraints(constraints, 7, 9, 1, 1, 45, 1);
                constraints.fill = 2;
                gridbag.setConstraints(startAtlas, constraints);
                this.add(startAtlas);
            }
        } else {
            ConstraintsBuilder.buildConstraints(constraints, 1, 4, 1, 1, 45, 1);
            this.constellationBox.setToolTipText(this.bundle.getString("target.tooltip.constellation"));
            gridbag.setConstraints(this.constellationBox, constraints);
            if (this.positionDisabled) {
                this.constellationBox.setEnabled(false);
            } else {
                this.constellationBox.setEnabled(this.editable);
            }
            this.add(this.constellationBox);
            targetDatasourceLabel = new OMLabel(this.bundle.getString("target.label.datasourceObserver"), 4, true);
            targetDatasourceLabel.setToolTipText(this.bundle.getString("target.tooltip.datasourceObserver"));
            ConstraintsBuilder.buildConstraints(constraints, 2, 4, 1, 1, 5, 1);
            gridbag.setConstraints(targetDatasourceLabel, constraints);
            this.add(targetDatasourceLabel);
            this.targetDatasource = new JTextField();
            this.targetDatasource.setToolTipText(this.bundle.getString("target.tooltip.datasourceObserver"));
            this.targetDatasource.setEditable(this.editable);
            ConstraintsBuilder.buildConstraints(constraints, 3, 4, 1, 1, 45, 1);
            this.createObserverDropDownBox();
            gridbag.setConstraints(this.sourceObserverBox, constraints);
            this.add(this.sourceObserverBox);
            ConstraintsBuilder.buildConstraints(constraints, 0, 5, 1, 1, 100, 1);
            OMLabel Lnotes = new OMLabel(this.bundle.getString("target.label.notes"), false);
            Lnotes.setToolTipText(this.bundle.getString("target.tooltip.notes"));
            gridbag.setConstraints(Lnotes, constraints);
            this.add(Lnotes);
            ConstraintsBuilder.buildConstraints(constraints, 0, 6, 8, 3, 100, 45);
            constraints.fill = 2;
            this.notes = new JTextArea(10, 40);
            this.notes.setToolTipText(this.bundle.getString("target.tooltip.notes"));
            this.notes.setEditable(this.editable);
            this.notes.setLineWrap(true);
            this.notes.addMouseListener(this);
            if (this.target != null) {
                this.notes.setText(this.target.getNotes());
            }
            if (!this.editable) {
                this.notes.setBackground(Color.WHITE);
            }
            JScrollPane descriptionScroll = new JScrollPane(this.notes);
            descriptionScroll.setMinimumSize(new Dimension(300, 60));
            gridbag.setConstraints(descriptionScroll, constraints);
            this.add(descriptionScroll);
        }
    }

    private void createObserverDropDownBox() {
        this.sourceObserverBox = new ObserverBox();
        this.sourceObserverBox.setToolTipText(this.bundle.getString("target.dropdown.selectObserver"));
        IObserver[] observer = this.observationManager.getXmlCache().getObservers();
        if (observer != null) {
            for (int x = 0; x < observer.length; ++x) {
                this.sourceObserverBox.addItem((ISchemaElement)observer[x]);
            }
        } else {
            this.sourceObserverBox.addEmptyItem();
        }
        if (this.target != null && this.target.getObserver() != null) {
            this.sourceObserverBox.setSelectedItem((ISchemaElement)this.target.getObserver());
        } else {
            this.sourceObserverBox.setSelectedItem(null);
        }
    }

    protected void createWarning(String message) {
        JOptionPane.showMessageDialog(this, message, this.bundle.getString("target.warning.title"), 2);
    }
}

