/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.container;

import de.lehmannet.om.Angle;
import de.lehmannet.om.EquPosition;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class AngleContainer
extends Container {
    private static final String UNIT_KEY_PREFIX = "Angle.Unit.";
    final PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private double angleValue = Double.NaN;
    private String angleUnit = "deg";
    private boolean editable = false;
    private String[] units = null;
    private boolean useArc = false;
    private JLabel unit = null;
    private AngleUnitBox unitBox = new AngleUnitBox();
    private JTextField decValue = new JTextField();
    private JTextField arcDegreeValue = new JTextField();
    private JTextField arcMinValue = new JTextField();
    private JTextField arcSecValue = new JTextField();
    private Map unitI18Nmap = new HashMap();

    public AngleContainer(Angle angle, boolean editable) {
        this.setAngle(angle);
        this.editable = editable;
        this.createContainer();
    }

    public AngleContainer(String angleUnit, boolean editable) {
        if (!Angle.isValidUnit((String)angleUnit)) {
            throw new IllegalArgumentException("Invalid angle unit. Use de.lehmannet.om.Angle constants.\n");
        }
        this.angleUnit = angleUnit;
        this.editable = editable;
        this.createContainer();
    }

    public Angle getAngle() throws NumberFormatException {
        if (!this.useArc) {
            if (this.decValue.getText() != null && !"".equals(this.decValue.getText())) {
                try {
                    this.angleValue = Double.parseDouble(this.decValue.getText());
                }
                catch (NumberFormatException nfe) {
                    throw new NumberFormatException("Given DEC value " + this.decValue.getText() + " cannot be parsed");
                }
                if (this.editable && this.units != null) {
                    this.angleUnit = this.getUnitFromI18NString((String)this.unitBox.getSelectedItem());
                }
                return new Angle(this.angleValue, this.angleUnit);
            }
        } else if (this.arcDegreeValue.getText() != null && !"".equals(this.arcDegreeValue.getText().trim())) {
            int deg;
            try {
                deg = Integer.parseInt(this.arcDegreeValue.getText());
            }
            catch (NumberFormatException nfe) {
                throw new NumberFormatException("Given arc degree value " + this.arcDegreeValue.getText() + " cannot be parsed");
            }
            int min = 0;
            if (this.arcMinValue.getText() != null && !"".equals(this.arcMinValue.getText().trim())) {
                try {
                    min = Integer.parseInt(this.arcMinValue.getText());
                }
                catch (NumberFormatException nfe) {
                    throw new NumberFormatException("Given arc min value " + this.arcMinValue.getText() + " cannot be parsed");
                }
            }
            int sec = 0;
            if (this.arcSecValue.getText() != null && !"".equals(this.arcSecValue.getText().trim())) {
                try {
                    String secString = this.arcSecValue.getText();
                    secString.replace('.', ' ');
                    secString.replace(',', ' ');
                    sec = Integer.parseInt(secString);
                }
                catch (NumberFormatException nfe) {
                    throw new NumberFormatException("Given arc sec value " + this.arcSecValue.getText() + " cannot be parsed");
                }
            }
            String arcString = EquPosition.getDecString((int)deg, (int)min, (int)sec);
            EquPosition eq = new EquPosition("0h0m0s", arcString);
            Angle decAngle = eq.getDecAngle();
            this.angleValue = decAngle.getValue();
            this.angleUnit = decAngle.getUnit();
            return decAngle;
        }
        return null;
    }

    public void setAngle(Angle angle) {
        if (angle != null) {
            this.angleUnit = angle.getUnit();
            this.angleValue = angle.getValue();
            this.decValue.setText(this.getValue());
            this.unit.setText(this.getI18NUnit(this.angleUnit));
            this.unitBox.addItem(this.getI18NUnit(this.angleUnit));
        }
    }

    public void setToolTipText(String text) {
        this.decValue.setToolTipText(text);
        this.unit.setToolTipText(text);
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.decValue.setEditable(this.editable);
    }

    public void setUnits(String[] units) {
        int i;
        if (!this.editable) {
            return;
        }
        if (units == null || units.length == 0) {
            this.units = null;
            return;
        }
        int[] checkedOK = new int[units.length];
        Arrays.fill(checkedOK, -1);
        int x = 0;
        for (i = 0; i < units.length; ++i) {
            if (!Angle.isValidUnit((String)units[i])) continue;
            checkedOK[x++] = i;
        }
        this.units = new String[x];
        x = 0;
        for (i = 0; i < checkedOK.length; ++i) {
            if (checkedOK[i] == -1) continue;
            this.units[x++] = units[checkedOK[i]];
        }
        super.removeAll();
        this.createContainer();
    }

    public void setArcDecTransformation(boolean enabled) {
        if (!this.editable) {
            return;
        }
        this.setArcValues();
        this.useArc = enabled;
        super.removeAll();
        this.createContainer();
    }

    public void createContainer() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        super.setLayout(gridbag);
        if (this.editable && this.useArc) {
            ConstraintsBuilder.buildConstraints(constraints, 0, 0, 1, 1, 28, 100);
            constraints.fill = 2;
            this.arcDegreeValue.setEditable(this.editable);
            gridbag.setConstraints(this.arcDegreeValue, constraints);
            super.add(this.arcDegreeValue);
            ConstraintsBuilder.buildConstraints(constraints, 1, 0, 1, 1, 5, 100);
            constraints.fill = 2;
            JLabel arcDegreeLabel = new JLabel("\u00b0");
            gridbag.setConstraints(arcDegreeLabel, constraints);
            super.add(arcDegreeLabel);
            ConstraintsBuilder.buildConstraints(constraints, 2, 0, 1, 1, 28, 100);
            this.arcMinValue.setEditable(this.editable);
            gridbag.setConstraints(this.arcMinValue, constraints);
            super.add(this.arcMinValue);
            ConstraintsBuilder.buildConstraints(constraints, 3, 0, 1, 1, 5, 100);
            constraints.fill = 2;
            JLabel arcMinLabel = new JLabel("'");
            gridbag.setConstraints(arcMinLabel, constraints);
            super.add(arcMinLabel);
            ConstraintsBuilder.buildConstraints(constraints, 4, 0, 1, 1, 28, 100);
            this.arcSecValue.setEditable(this.editable);
            gridbag.setConstraints(this.arcSecValue, constraints);
            super.add(this.arcSecValue);
            ConstraintsBuilder.buildConstraints(constraints, 5, 0, 1, 1, 5, 100);
            constraints.fill = 2;
            JLabel arcSecLabel = new JLabel("\"");
            gridbag.setConstraints(arcSecLabel, constraints);
            super.add(arcSecLabel);
        } else {
            ConstraintsBuilder.buildConstraints(constraints, 0, 0, 6, 1, 90, 100);
            constraints.fill = 2;
            if (!Double.isNaN(this.angleValue)) {
                this.decValue.setText(this.getValue());
            }
            this.decValue.setEditable(this.editable);
            gridbag.setConstraints(this.decValue, constraints);
            super.add(this.decValue);
            ConstraintsBuilder.buildConstraints(constraints, 6, 0, 1, 1, 10, 100);
            constraints.fill = 2;
            if (this.editable && this.units != null && !this.useArc) {
                for (int i = 0; i < this.units.length; ++i) {
                    this.unitBox.addItem(this.getI18NUnit(this.units[i]));
                }
                gridbag.setConstraints(this.unitBox, constraints);
                super.add(this.unitBox);
            } else {
                this.unit = new JLabel(this.getI18NUnit(this.angleUnit));
                gridbag.setConstraints(this.unit, constraints);
                super.add(this.unit);
            }
        }
    }

    private String getValue() {
        DecimalFormat df = new DecimalFormat("0.00");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        return df.format(this.angleValue);
    }

    private void setArcValues() {
        Angle angle = this.getAngle();
        if (angle == null) {
            return;
        }
        EquPosition ep = new EquPosition(new Angle(0.0, "deg"), angle);
        String arcString = ep.getDec();
        String deg = arcString.substring(0, arcString.indexOf("\u00b0"));
        String min = arcString.substring(arcString.indexOf("\u00b0") + 1, arcString.indexOf("'"));
        String sec = arcString.substring(arcString.indexOf("'") + 1, arcString.indexOf("\""));
        this.arcDegreeValue.setText(deg);
        this.arcMinValue.setText(min);
        this.arcSecValue.setText(sec);
    }

    private String getI18NUnit(String unit) {
        String result = this.bundle.getString(UNIT_KEY_PREFIX + unit);
        if (result == null) {
            return unit;
        }
        this.unitI18Nmap.put(result, unit);
        return result;
    }

    private String getUnitFromI18NString(String I18N) {
        return (String)this.unitI18Nmap.get(I18N);
    }

    private class AngleUnitBox
    extends JComboBox {
        private ArrayList list = new ArrayList();

        private AngleUnitBox() {
        }

        public void addItem(String angleUnit) {
            if (this.list.contains(angleUnit)) {
                super.setSelectedItem(angleUnit);
                return;
            }
            this.list.add(angleUnit);
            super.addItem(angleUnit);
            super.setSelectedItem(angleUnit);
        }
    }
}

