/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.util;

import de.lehmannet.om.util.ConfigException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ConfigLoader {
    private static final String MANIFEST_FILENAME = "META-INF/SCHEMATYPE";
    private static final String CONFIG_FILE_TARGETENTRY_TYPE_ENDING = "XSI_Relation_Type";
    private static final String CONFIG_FILE_TARGETENTRY_CLASSNAME_ENDING = "XSI_Relation_Class";
    private static final String CONFIG_FILE_FINDINGENTRY_TYPE_ENDING = "XSI_Relation_Finding_Type";
    private static final String CONFIG_FILE_FINDINGENTRY_CLASSNAME_ENDING = "XSI_Relation_Finding_Class";
    private static HashMap targets = new HashMap();
    private static HashMap findings = new HashMap();
    private static HashMap target_findings = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTargetClassnameFromType(String type) throws ConfigException {
        String classname;
        if (type == null) {
            return null;
        }
        HashMap hashMap = targets;
        synchronized (hashMap) {
            if (targets.isEmpty()) {
                ConfigLoader.loadConfig();
            }
        }
        type = ConfigLoader.checkAncestorTypes(type);
        if (!targets.containsKey(type)) {
            Set c = target_findings.keySet();
            Iterator i = c.iterator();
            String currentKey = null;
            String currentValue = null;
            while (i.hasNext()) {
                currentKey = (String)i.next();
                currentValue = (String)target_findings.get(currentKey);
                if (!type.equals(currentValue)) continue;
                type = currentKey;
                break;
            }
        }
        if ((classname = (String)targets.get(type)) == null || "".equals(classname.trim())) {
            throw new ConfigException("No target class defined for target type: " + type + ". Please check plugin Manifest files, or download new extension. ");
        }
        return classname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFindingClassnameFromType(String type) throws ConfigException {
        String classname;
        if (type == null) {
            return null;
        }
        HashMap hashMap = findings;
        synchronized (hashMap) {
            if (findings.isEmpty()) {
                ConfigLoader.loadConfig();
            }
        }
        type = ConfigLoader.checkAncestorTypes(type);
        if (!findings.containsKey(type)) {
            Set c = target_findings.keySet();
            Iterator i = c.iterator();
            String currentKey = null;
            String currentValue = null;
            while (i.hasNext()) {
                currentKey = (String)i.next();
                currentValue = (String)target_findings.get(currentKey);
                if (!type.equals(currentKey)) continue;
                type = currentValue;
                break;
            }
        }
        if ((classname = (String)findings.get(type)) == null || "".equals(classname.trim())) {
            throw new ConfigException("No findings class defined for findings type: " + type + ". Please check plugin Manifest files, or download new extension. ");
        }
        return classname;
    }

    public static void reloadConfig() throws ConfigException {
        targets.clear();
        findings.clear();
        target_findings.clear();
        ConfigLoader.loadConfig();
    }

    private static void loadConfig() throws ConfigException {
        File[] jars;
        ConfigLoader.addGenericElements();
        String sep = System.getProperty("path.separator");
        String path = System.getProperty("java.class.path");
        StringTokenizer tokenizer = new StringTokenizer(path, sep);
        File token = null;
        while (tokenizer.hasMoreTokens()) {
            token = new File(tokenizer.nextToken());
            if (!token.isFile() || !token.getName().endsWith(".jar")) continue;
            ConfigLoader.scanJarFile(token);
        }
        String extPath = System.getProperty("java.ext.dirs");
        File ext = new File(extPath);
        if (ext.exists() && (jars = ext.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jar");
            }
        })) != null) {
            for (int i = 0; i < jars.length; ++i) {
                ConfigLoader.scanJarFile(jars[i]);
            }
        }
    }

    private static void scanJarFile(File jar) throws ConfigException {
        ZipFile archive = null;
        try {
            archive = new ZipFile(jar);
        }
        catch (ZipException zipEx) {
            throw new ConfigException("Error while accessing JAR file. ", zipEx);
        }
        catch (IOException ioe) {
            throw new ConfigException("Error while accessing JAR file. ", ioe);
        }
        Enumeration<? extends ZipEntry> enu = archive.entries();
        while (enu.hasMoreElements()) {
            ZipEntry entry = enu.nextElement();
            String name = entry.getName();
            if (!name.toUpperCase().equals(MANIFEST_FILENAME)) continue;
            InputStream in = null;
            try {
                in = archive.getInputStream(entry);
                Properties prop = new Properties();
                prop.load(in);
                ConfigLoader.addConfig(prop);
            }
            catch (IOException ioe) {
                throw new ConfigException("Error while accessing entry from JAR file. ", ioe);
            }
            finally {
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addConfig(Properties newProperties) throws ConfigException {
        Iterator<Object> keys = newProperties.keySet().iterator();
        String currentKey = null;
        String prefix = null;
        String target_classname = null;
        String target_type = null;
        String finding_classname = null;
        String finding_type = null;
        while (keys.hasNext()) {
            currentKey = (String)keys.next();
            if (!currentKey.endsWith(CONFIG_FILE_TARGETENTRY_TYPE_ENDING)) continue;
            target_type = newProperties.getProperty(currentKey);
            prefix = currentKey.substring(0, currentKey.lastIndexOf(CONFIG_FILE_TARGETENTRY_TYPE_ENDING));
            target_classname = newProperties.getProperty(prefix + CONFIG_FILE_TARGETENTRY_CLASSNAME_ENDING);
            finding_type = newProperties.getProperty(prefix + CONFIG_FILE_FINDINGENTRY_TYPE_ENDING);
            finding_classname = newProperties.getProperty(prefix + CONFIG_FILE_FINDINGENTRY_CLASSNAME_ENDING);
            HashMap hashMap = targets;
            synchronized (hashMap) {
                targets.put(target_type, target_classname);
            }
            hashMap = findings;
            synchronized (hashMap) {
                findings.put(finding_type, finding_classname);
            }
            hashMap = target_findings;
            synchronized (hashMap) {
                target_findings.put(target_type, finding_type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addGenericElements() {
        String target_type = "oal:observationTargetType";
        String target_classname = "de.lehmannet.om.GenericTarget";
        String finding_type = "oal:findingsType";
        String finding_classname = "de.lehmannet.om.GenericFinding";
        HashMap hashMap = targets;
        synchronized (hashMap) {
            targets.put("oal:observationTargetType", "de.lehmannet.om.GenericTarget");
        }
        hashMap = findings;
        synchronized (hashMap) {
            findings.put("oal:findingsType", "de.lehmannet.om.GenericFinding");
        }
        hashMap = target_findings;
        synchronized (hashMap) {
            target_findings.put("oal:observationTargetType", "oal:findingsType");
        }
        String starTarget_type = "oal:starTargetType";
        String starTarget_classname = "de.lehmannet.om.TargetStar";
        String starTarget_finding_type = "oal:findingsType";
        String starTarget_finding_classname = "de.lehmannet.om.GenericFinding";
        HashMap hashMap2 = targets;
        synchronized (hashMap2) {
            targets.put("oal:starTargetType", "de.lehmannet.om.TargetStar");
        }
        hashMap2 = findings;
        synchronized (hashMap2) {
            findings.put("oal:findingsType", "de.lehmannet.om.GenericFinding");
        }
        hashMap2 = target_findings;
        synchronized (hashMap2) {
            target_findings.put("oal:starTargetType", "oal:findingsType");
        }
    }

    private static String checkAncestorTypes(String type) {
        if (type.startsWith("fgca")) {
            type = type.replaceAll("fgca", "oal");
        }
        return type;
    }
}

