/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om;

import de.lehmannet.om.IObserver;
import de.lehmannet.om.ITarget;
import de.lehmannet.om.Target;
import de.lehmannet.om.util.FloatUtil;
import de.lehmannet.om.util.SchemaException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TargetStar
extends Target {
    public static final String XML_XSI_TYPE_VALUE = "oal:starTargetType";
    private static final String XML_ELEMENT_MAG_APPARENT = "apparentMag";
    private static final String XML_ELEMENT_CLASSIFICATION = "classification";
    private float magnitudeApparent = Float.NaN;
    private String stellarClassification = null;

    public TargetStar(Node targetElement, IObserver[] observers) throws SchemaException {
        super(targetElement, observers);
        String value;
        Element target = (Element)targetElement;
        Element child = null;
        NodeList children = null;
        children = target.getElementsByTagName(XML_ELEMENT_MAG_APPARENT);
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                value = child.getFirstChild().getNodeValue();
                this.setMagnitudeApparent(FloatUtil.parseFloat((String)value));
            } else if (children.getLength() > 1) {
                throw new SchemaException("TargetStar can only have one apparent magnitude. (ID: " + super.getID() + ")");
            }
        }
        if ((children = target.getElementsByTagName(XML_ELEMENT_CLASSIFICATION)) != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                value = child.getFirstChild().getNodeValue();
                this.setStellarClassification(value);
            } else if (children.getLength() > 1) {
                throw new SchemaException("TargetStar can only have one stellar classification. (ID: " + super.getID() + ")");
            }
        }
    }

    public TargetStar(String starName, String datasource) {
        super(starName, datasource);
    }

    public TargetStar(String starName, IObserver observer) {
        super(starName, observer);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("TargetStar Name=");
        buffer.append(super.getName());
        if (super.getPosition() != null) {
            buffer.append("\nPosition:");
            buffer.append(super.getPosition());
        }
        if (super.getDatasource() != null) {
            buffer.append("\nDatasource:");
            buffer.append(super.getDatasource());
        } else {
            buffer.append("\nObserver:");
            buffer.append(super.getObserver());
        }
        if (super.getConstellation() != null) {
            buffer.append("\nConstellation:");
            buffer.append(super.getConstellation());
        }
        if (super.getAliasNames() != null) {
            buffer.append("\nAlias Names: ");
            String[] an = super.getAliasNames();
            for (int i = 0; i < an.length; ++i) {
                buffer.append(an[i] + "  ");
            }
        }
        if (!Float.isNaN(this.magnitudeApparent)) {
            buffer.append("\nApparent magnitude=");
            buffer.append(this.magnitudeApparent);
        }
        if (this.stellarClassification != null) {
            buffer.append("\nStellar Classification=");
            buffer.append(this.stellarClassification);
        }
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ITarget)) {
            return false;
        }
        ITarget target = (ITarget)obj;
        String targetName = target.getName();
        if (targetName == null) {
            return false;
        }
        return super.getName().toLowerCase().equals(targetName.toLowerCase()) && this.getXSIType().equals(target.getXSIType());
    }

    public Element addToXmlElement(Element element) {
        return this.createXmlTargetStarElement(element, this.getXSIType());
    }

    public String getXSIType() {
        return XML_XSI_TYPE_VALUE;
    }

    public float getMagnitudeApparent() {
        return this.magnitudeApparent;
    }

    public void setMagnitudeApparent(float magnitudeApparent) {
        this.magnitudeApparent = magnitudeApparent;
    }

    public String getStellarClassification() {
        return this.stellarClassification;
    }

    public void setStellarClassification(String stellarClassification) {
        if (stellarClassification != null && "".equals(stellarClassification = stellarClassification.trim())) {
            stellarClassification = null;
        }
        this.stellarClassification = stellarClassification;
    }

    protected Element createXmlTargetStarElement(Element element, String xsiType) {
        if (element == null) {
            return null;
        }
        Document ownerDoc = element.getOwnerDocument();
        Element e_Targets = null;
        boolean created = false;
        NodeList nodeList = ownerDoc.getElementsByTagName("targets");
        if (nodeList.getLength() == 0) {
            e_Targets = ownerDoc.createElement("targets");
            created = true;
        } else {
            e_Targets = (Element)nodeList.item(0);
        }
        nodeList = e_Targets.getElementsByTagName("target");
        if (nodeList.getLength() > 0) {
            Node currentNode = null;
            NamedNodeMap attributes = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                currentNode = nodeList.item(i);
                attributes = currentNode.getAttributes();
                Node idAttribute = attributes.getNamedItem("id");
                if (idAttribute == null || !idAttribute.getNodeValue().trim().equals(super.getID().trim())) continue;
                return null;
            }
        }
        Element e_Target = super.createXmlTargetElement(e_Targets);
        e_Targets.appendChild(e_Target);
        e_Target.setAttribute("xsi:type", this.getXSIType());
        if (!Float.isNaN(this.magnitudeApparent)) {
            Element e_MagnitudeApp = ownerDoc.createElement(XML_ELEMENT_MAG_APPARENT);
            Text n_MagnitudeAppText = ownerDoc.createTextNode(Float.toString(this.magnitudeApparent));
            e_MagnitudeApp.appendChild(n_MagnitudeAppText);
            e_Target.appendChild(e_MagnitudeApp);
        }
        if (this.stellarClassification != null) {
            Element e_Classfication = ownerDoc.createElement(XML_ELEMENT_CLASSIFICATION);
            Text n_ClassificationText = ownerDoc.createTextNode(this.stellarClassification);
            e_Classfication.appendChild(n_ClassificationText);
            e_Target.appendChild(e_Classfication);
        }
        if (created) {
            ownerDoc.getDocumentElement().appendChild(e_Targets);
        }
        return e_Target;
    }
}

