/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om;

import de.lehmannet.om.IEyepiece;
import de.lehmannet.om.IFilter;
import de.lehmannet.om.IFinding;
import de.lehmannet.om.IImager;
import de.lehmannet.om.ILens;
import de.lehmannet.om.IObservation;
import de.lehmannet.om.IObserver;
import de.lehmannet.om.IScope;
import de.lehmannet.om.ISession;
import de.lehmannet.om.ISite;
import de.lehmannet.om.ITarget;
import de.lehmannet.om.SchemaElement;
import de.lehmannet.om.SurfaceBrightness;
import de.lehmannet.om.util.DateConverter;
import de.lehmannet.om.util.FloatUtil;
import de.lehmannet.om.util.SchemaException;
import de.lehmannet.om.util.SchemaLoader;
import java.io.File;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Observation
extends SchemaElement
implements IObservation {
    private Calendar begin = null;
    private Calendar end = null;
    private float faintestStar = Float.NaN;
    private SurfaceBrightness sqmValue = null;
    private float magnification = Float.NaN;
    private int seeing = -1;
    private List images = new LinkedList();
    private IImager imager = null;
    private ISession session = null;
    private String accessories = null;
    private ITarget target = null;
    private IObserver observer = null;
    private ISite site = null;
    private IScope scope = null;
    private IEyepiece eyepiece = null;
    private IFilter filter = null;
    private ILens lens = null;
    private List results = new LinkedList();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Observation(Node observation, ITarget[] targets, IObserver[] observers, ISite[] sites, IScope[] scopes, ISession[] sessions, IEyepiece[] eyepieces, IFilter[] filters, IImager[] imagers, ILens[] lenses) throws SchemaException, IllegalArgumentException {
        int j;
        boolean found;
        int j2;
        boolean found2;
        int j3;
        if (observation == null) {
            throw new IllegalArgumentException("Parameter observation node cannot be NULL. ");
        }
        Element observationElement = (Element)observation;
        Element child = null;
        NodeList children = null;
        NamedNodeMap attributes = observationElement.getAttributes();
        if (attributes == null || attributes.getLength() == 0) {
            throw new SchemaException("Observation must have a unique ID. ");
        }
        String ID = observationElement.getAttribute("id");
        super.setID(ID);
        children = observationElement.getElementsByTagName("begin");
        if (children == null || children.getLength() != 1) {
            throw new SchemaException("Observation must have exact one begin date. ");
        }
        child = (Element)children.item(0);
        Calendar begin = null;
        if (child == null) {
            throw new SchemaException("Observation must have begin date. ");
        }
        String ISO8601Begin = null;
        if (child.getFirstChild() == null) {
            throw new SchemaException("Begin date is empty. ");
        }
        ISO8601Begin = child.getFirstChild().getNodeValue();
        try {
            begin = DateConverter.toDate((String)ISO8601Begin);
            this.setBegin(begin);
        }
        catch (NumberFormatException nfe) {
            throw new SchemaException("Begin date is malformed. ", (Throwable)nfe);
        }
        child = null;
        children = observationElement.getElementsByTagName("target");
        if (children == null || children.getLength() != 1) {
            throw new SchemaException("Observation must have exact one target. ");
        }
        child = (Element)children.item(0);
        if (child == null) {
            throw new SchemaException("Observation must have target. ");
        }
        String targetID = child.getFirstChild().getNodeValue();
        if (targets == null || targets.length <= 0) throw new IllegalArgumentException("Parameter ITarget array cannot be NULL or empty. ");
        boolean found3 = false;
        for (j3 = 0; j3 < targets.length; ++j3) {
            if (!targets[j3].getID().equals(targetID)) continue;
            found3 = true;
            this.setTarget(targets[j3]);
            break;
        }
        if (!found3) {
            throw new SchemaException("Observation " + super.getID() + " links to not existing target element!");
        }
        child = null;
        children = observationElement.getElementsByTagName("observer");
        if (children == null || children.getLength() != 1) {
            throw new SchemaException("Observation must have exact one observer. ");
        }
        child = (Element)children.item(0);
        if (child == null) {
            throw new SchemaException("Observation must have observer. ");
        }
        String observerID = child.getFirstChild().getNodeValue();
        if (observers == null || observers.length <= 0) throw new IllegalArgumentException("Parameter IObserver array cannot be NULL or empty. ");
        found3 = false;
        for (j3 = 0; j3 < observers.length; ++j3) {
            if (!observers[j3].getID().equals(observerID)) continue;
            found3 = true;
            this.setObserver(observers[j3]);
            break;
        }
        if (!found3) {
            throw new SchemaException("Observation observer links to not existing observer element. ");
        }
        child = null;
        children = observationElement.getElementsByTagName("result");
        if (children == null || children.getLength() == 0) {
            throw new SchemaException("Observation must have one or more results. ");
        }
        IFinding[] results = new IFinding[children.getLength()];
        for (int j4 = 0; j4 < children.getLength(); ++j4) {
            results[j4] = this.createFindingElements(children.item(j4));
        }
        this.setResults(Arrays.asList(results));
        child = null;
        children = observationElement.getElementsByTagName("end");
        Calendar end = null;
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) {
                    throw new SchemaException("Problem retrieving observations end date. ");
                }
                String ISO8601End = child.getFirstChild().getNodeValue();
                try {
                    end = DateConverter.toDate((String)ISO8601End);
                    this.setEnd(end);
                }
                catch (NumberFormatException nfe) {
                    throw new SchemaException("End date is malformed. ", (Throwable)nfe);
                }
            } else if (children.getLength() > 1) {
                throw new SchemaException("Observation can have exact one end date. ");
            }
        }
        child = null;
        children = observationElement.getElementsByTagName("site");
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem retrieving site from observation. ");
                String siteID = child.getFirstChild().getNodeValue();
                if (sites == null || sites.length <= 0) throw new IllegalArgumentException("Parameter ISite array cannot be NULL or empty. ");
                found2 = false;
                for (j2 = 0; j2 < sites.length; ++j2) {
                    if (!sites[j2].getID().equals(siteID)) continue;
                    found2 = true;
                    this.setSite(sites[j2]);
                    break;
                }
                if (!found2) {
                    throw new SchemaException("Observation site links to not existing site element. ");
                }
            } else if (children.getLength() > 1) {
                throw new SchemaException("Observation can have only one site. (Or none at all)");
            }
        }
        child = null;
        children = observationElement.getElementsByTagName("scope");
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem retrieving scope from observation. ");
                String scopeID = child.getFirstChild().getNodeValue();
                if (scopes == null || scopes.length <= 0) throw new IllegalArgumentException("Parameter IScope array cannot be NULL or empty. ");
                found2 = false;
                for (j2 = 0; j2 < scopes.length; ++j2) {
                    if (!scopes[j2].getID().equals(scopeID)) continue;
                    found2 = true;
                    this.setScope(scopes[j2]);
                    break;
                }
                if (!found2) {
                    throw new SchemaException("Observation scope links to not existing scope element. ");
                }
            } else if (children.getLength() > 1) {
                throw new SchemaException("Observation can have only one scope. (Or none at all)");
            }
        }
        child = null;
        children = observationElement.getElementsByTagName("image");
        String image = "";
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                child = (Element)children.item(i);
                if (child == null) throw new SchemaException("Problem while retrieving image of observation. ");
                NodeList textElements = child.getChildNodes();
                if (textElements == null || textElements.getLength() <= 0) continue;
                for (int te = 0; te < textElements.getLength(); ++te) {
                    image = image + textElements.item(te).getNodeValue();
                }
                image = image.replace('/', File.separatorChar);
                image = image.replace('\\', File.separatorChar);
                this.addImage(image);
                image = "";
            }
        }
        child = null;
        children = observationElement.getElementsByTagName("faintestStar");
        String faintestStar = null;
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem while retrieving faintest star of observation. ");
                faintestStar = child.getFirstChild().getNodeValue();
                this.setFaintestStar(FloatUtil.parseFloat((String)faintestStar));
            } else if (children.getLength() > 1) {
                throw new SchemaException("Observation can have only one faintest star. ");
            }
        }
        child = null;
        children = observationElement.getElementsByTagName("sqm");
        String sqm = null;
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem while retrieving sky quality meter value of observation. ");
                sqm = child.getFirstChild().getNodeValue();
                this.setSkyQuality(new SurfaceBrightness(FloatUtil.parseFloat((String)sqm), "mags-per-squarearcsec"));
            } else if (children.getLength() > 1) {
                throw new SchemaException("Observation can have only one sky quality meter value. ");
            }
        }
        child = null;
        children = observationElement.getElementsByTagName("sky-quality");
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem while retrieving sky quality meter value of observation. ");
                sqm = child.getFirstChild().getNodeValue();
                String unit = child.getAttribute("unit");
                this.setSkyQuality(new SurfaceBrightness(FloatUtil.parseFloat((String)sqm), unit));
            } else if (children.getLength() > 1) {
                throw new SchemaException("Observation can have only one sky quality meter value. ");
            }
        }
        child = null;
        children = observationElement.getElementsByTagName("magnification");
        String mag = null;
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem while retrieving magnification of observation. ");
                mag = child.getFirstChild().getNodeValue();
                this.setMagnification(FloatUtil.parseFloat((String)mag));
            } else if (children.getLength() > 1) {
                throw new SchemaException("Observation can have only one magnification value. ");
            }
        }
        child = null;
        children = observationElement.getElementsByTagName("accessories");
        String accessories = "";
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem while retrieving accessories of observation. ");
                NodeList textElements = child.getChildNodes();
                if (textElements != null && textElements.getLength() > 0) {
                    for (int te = 0; te < textElements.getLength(); ++te) {
                        accessories = accessories + textElements.item(te).getNodeValue();
                    }
                    this.setAccessories(accessories);
                }
            } else if (children.getLength() > 1) {
                throw new SchemaException("Observation can have only one accessories entry. ");
            }
        }
        child = null;
        children = observationElement.getElementsByTagName("seeing");
        String seeing = null;
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem while retrieving seeing of observation. ");
                seeing = child.getFirstChild().getNodeValue();
                this.setSeeing(Integer.parseInt(seeing));
            } else if (children.getLength() > 1) {
                throw new SchemaException("Observation can have only one seeing value. ");
            }
        }
        child = null;
        children = observationElement.getElementsByTagName("session");
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem retrieving session from observation. ");
                String sessionID = child.getFirstChild().getNodeValue();
                if (sessions == null || sessions.length <= 0) throw new IllegalArgumentException("Parameter ISession array cannot be NULL or empty. ");
                found = false;
                for (j = 0; j < sessions.length; ++j) {
                    if (!sessions[j].getID().equals(sessionID)) continue;
                    found = true;
                    try {
                        this.setSession(sessions[j]);
                        break;
                    }
                    catch (IllegalArgumentException iae) {
                        throw new SchemaException("Problem while setting session: " + sessions[j].getDisplayName() + " to observation: " + this.getDisplayName() + ".\n" + "Nested Exception is: " + iae);
                    }
                }
                if (!found) {
                    throw new SchemaException("Observation session links to not existing session element. ");
                }
            } else if (children.getLength() > 1) {
                throw new SchemaException("Observation can have only one session. ");
            }
        }
        child = null;
        children = observationElement.getElementsByTagName("eyepiece");
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem retrieving eyepiece from observation. ");
                String eyepieceID = child.getFirstChild().getNodeValue();
                if (eyepieces == null || eyepieces.length <= 0) throw new IllegalArgumentException("Parameter IEyepiece array cannot be NULL or empty. ");
                found = false;
                for (j = 0; j < eyepieces.length; ++j) {
                    if (!eyepieces[j].getID().equals(eyepieceID)) continue;
                    found = true;
                    this.setEyepiece(eyepieces[j]);
                    break;
                }
                if (!found) {
                    throw new SchemaException("Observation eyepiece links to not existing eyepiece element. ");
                }
            } else if (children.getLength() > 1) {
                throw new SchemaException("Observation can have exact one eyepiece. ");
            }
        }
        child = null;
        children = observationElement.getElementsByTagName("lens");
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem retrieving lens from observation. ");
                String lensID = child.getFirstChild().getNodeValue();
                if (lenses == null || lenses.length <= 0) throw new IllegalArgumentException("Parameter ILens array cannot be NULL or empty. ");
                found = false;
                for (j = 0; j < lenses.length; ++j) {
                    if (!lenses[j].getID().equals(lensID)) continue;
                    found = true;
                    this.setLens(lenses[j]);
                    break;
                }
                if (!found) {
                    throw new SchemaException("Observation lens links to not existing lens element. ");
                }
            } else if (children.getLength() > 1) {
                throw new SchemaException("Observation can have exact one lens. ");
            }
        }
        child = null;
        children = observationElement.getElementsByTagName("filter");
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem retrieving filter from observation. ");
                String filterID = child.getFirstChild().getNodeValue();
                if (filters == null || filters.length <= 0) throw new IllegalArgumentException("Parameter IFilter array cannot be NULL or empty. ");
                found = false;
                for (j = 0; j < filters.length; ++j) {
                    if (!filters[j].getID().equals(filterID)) continue;
                    found = true;
                    this.setFilter(filters[j]);
                    break;
                }
                if (!found) {
                    throw new SchemaException("Observation filter links to not existing filter element. ");
                }
            } else if (children.getLength() > 1) {
                throw new SchemaException("Observation can have exact one filter. ");
            }
        }
        child = null;
        children = observationElement.getElementsByTagName("imager");
        if (children == null) return;
        if (children.getLength() == 1) {
            child = (Element)children.item(0);
            if (child == null) throw new SchemaException("Problem retrieving imager from observation. ");
            String imagerID = child.getFirstChild().getNodeValue();
            if (imagers == null || imagers.length <= 0) throw new IllegalArgumentException("Parameter IImager array cannot be NULL or empty. ");
            found = false;
            for (j = 0; j < imagers.length; ++j) {
                if (!imagers[j].getID().equals(imagerID)) continue;
                found = true;
                this.setImager(imagers[j]);
                break;
            }
            if (found) return;
            throw new SchemaException("Observation imager links to not existing imager element. ");
        }
        if (children.getLength() <= 1) return;
        throw new SchemaException("Observation can have exact one imager. ");
    }

    public Observation(Calendar begin, ITarget target, IObserver observer, IFinding result) throws IllegalArgumentException {
        if (begin == null) {
            throw new IllegalArgumentException("Begin date cannot be null. ");
        }
        this.begin = begin;
        if (target == null) {
            throw new IllegalArgumentException("Target cannot be null. ");
        }
        this.target = target;
        if (observer == null) {
            throw new IllegalArgumentException("Observer cannot be null. ");
        }
        this.observer = observer;
        if (result == null) {
            throw new IllegalArgumentException("Result cannot be null. ");
        }
        this.addResult(result);
    }

    public Observation(Calendar begin, ITarget target, IObserver observer, List results) throws IllegalArgumentException {
        if (begin == null) {
            throw new IllegalArgumentException("Begin date cannot be null. ");
        }
        this.begin = begin;
        if (target == null) {
            throw new IllegalArgumentException("Target cannot be null. ");
        }
        this.target = target;
        if (observer == null) {
            throw new IllegalArgumentException("Observer cannot be null. ");
        }
        this.observer = observer;
        if (results == null || results.isEmpty()) {
            throw new IllegalArgumentException("Result list cannot be null or empty. ");
        }
        this.addResults(results);
    }

    public Observation(Calendar begin, Calendar end, ITarget target, IObserver observer, List results) throws IllegalArgumentException {
        this(begin, target, observer, results);
        this.end = end;
    }

    public Observation(Calendar begin, Calendar end, ITarget target, IObserver observer, IFinding result) throws IllegalArgumentException {
        this(begin, target, observer, result);
        this.end = end;
    }

    public Observation(Calendar begin, Calendar end, float faintestStar, SurfaceBrightness sq, int seeing, float magnification, ITarget target, IObserver observer, ISite site, IScope scope, String accessories, IEyepiece eyepiece, IFilter filter, IImager imager, ILens lens, ISession session, IFinding result) throws IllegalArgumentException {
        this(begin, end, target, observer, result);
        this.setFaintestStar(faintestStar);
        this.setMagnification(magnification);
        this.setSite(site);
        this.setScope(scope);
        this.setEyepiece(eyepiece);
        this.setFilter(filter);
        this.setSession(session);
        this.setSeeing(seeing);
        this.setAccessories(accessories);
        this.setImager(imager);
        this.setLens(lens);
        this.setSkyQuality(sq);
    }

    public Observation(Calendar begin, Calendar end, float faintestStar, SurfaceBrightness sq, int seeing, float magnification, ITarget target, IObserver observer, ISite site, IScope scope, String accessories, IEyepiece eyepiece, IFilter filter, IImager imager, ILens lens, ISession session, List results) throws IllegalArgumentException {
        this(begin, end, target, observer, results);
        this.setFaintestStar(faintestStar);
        this.setMagnification(magnification);
        this.setSite(site);
        this.setScope(scope);
        this.setEyepiece(eyepiece);
        this.setFilter(filter);
        this.setSession(session);
        this.setSeeing(seeing);
        this.setAccessories(accessories);
        this.setImager(imager);
        this.setLens(lens);
        this.setSkyQuality(sq);
    }

    public String getDisplayName() {
        DateFormat format = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
        format.setCalendar(this.begin);
        return format.format(this.begin.getTime()) + " - " + this.target.getDisplayName();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Observation: Begin Date=");
        buffer.append(DateConverter.toISO8601((Calendar)this.begin));
        if (this.end != null) {
            buffer.append(" End date=");
            buffer.append(DateConverter.toISO8601((Calendar)this.end));
        }
        buffer.append(" Target=");
        buffer.append(this.target);
        buffer.append(" Observer=");
        buffer.append(this.observer);
        buffer.append(" Results=");
        ListIterator iterator = this.results.listIterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buffer.append(" --- ");
        }
        if (this.images != null && this.images.size() > 0) {
            buffer.append(" Images=");
            ListIterator imageIterator = this.images.listIterator();
            while (imageIterator.hasNext()) {
                buffer.append(imageIterator.next());
                if (!imageIterator.hasNext()) continue;
                buffer.append(", ");
            }
        }
        if (!Float.isNaN(this.faintestStar)) {
            buffer.append(" Faintest star=");
            buffer.append(this.faintestStar);
        }
        if (this.sqmValue != null) {
            buffer.append(" Sky quality meter value=");
            buffer.append(this.sqmValue);
        }
        if (!Float.isNaN(this.magnification)) {
            buffer.append(" Magnification=");
            buffer.append(this.magnification);
        }
        if (this.seeing != -1) {
            buffer.append(" Seeing=");
            buffer.append(this.seeing);
        }
        if (this.accessories != null) {
            buffer.append(" Accessories=");
            buffer.append(this.accessories);
        }
        if (this.session != null) {
            buffer.append(" Session=");
            buffer.append(this.session);
        }
        if (this.site != null) {
            buffer.append(" Site=");
            buffer.append(this.site);
        }
        if (this.scope != null) {
            buffer.append(" Scope=");
            buffer.append(this.scope);
        }
        if (this.eyepiece != null) {
            buffer.append(" Eyepiece=");
            buffer.append(this.eyepiece);
        }
        if (this.filter != null) {
            buffer.append(" Filter=");
            buffer.append(this.filter);
        }
        if (this.imager != null) {
            buffer.append(" Imager=");
            buffer.append(this.imager);
        }
        if (this.lens != null) {
            buffer.append(" Lens=");
            buffer.append(this.lens);
        }
        return buffer.toString();
    }

    public Element addToXmlElement(Element parent) {
        if (parent == null) {
            return null;
        }
        Document ownerDoc = parent.getOwnerDocument();
        Element e_Observation = ownerDoc.createElement("observation");
        e_Observation.setAttribute("id", super.getID());
        e_Observation = this.observer.addAsLinkToXmlElement(e_Observation, "observer");
        if (this.site != null) {
            e_Observation = this.site.addAsLinkToXmlElement(e_Observation);
        }
        if (this.session != null) {
            e_Observation = this.session.addAsLinkToXmlElement(e_Observation);
        }
        e_Observation = this.target.addAsLinkToXmlElement(e_Observation, null);
        Element e_Begin = ownerDoc.createElement("begin");
        Text n_BeginText = ownerDoc.createTextNode(DateConverter.toISO8601((Calendar)this.begin));
        e_Begin.appendChild(n_BeginText);
        e_Observation.appendChild(e_Begin);
        if (this.end != null) {
            Element e_End = ownerDoc.createElement("end");
            Text n_EndText = ownerDoc.createTextNode(DateConverter.toISO8601((Calendar)this.end));
            e_End.appendChild(n_EndText);
            e_Observation.appendChild(e_End);
        }
        if (!Float.isNaN(this.faintestStar)) {
            Element e_FaintestStar = ownerDoc.createElement("faintestStar");
            Text n_FaintestStarText = ownerDoc.createTextNode(String.valueOf(this.faintestStar));
            e_FaintestStar.appendChild(n_FaintestStarText);
            e_Observation.appendChild(e_FaintestStar);
        }
        if (this.sqmValue != null) {
            Element e_SQMValue = ownerDoc.createElement("sky-quality");
            e_SQMValue = this.sqmValue.setToXmlElement(e_SQMValue);
            e_Observation.appendChild(e_SQMValue);
        }
        if (this.seeing != -1) {
            Element e_Seeing = ownerDoc.createElement("seeing");
            Text n_SeeingText = ownerDoc.createTextNode(String.valueOf(this.seeing));
            e_Seeing.appendChild(n_SeeingText);
            e_Observation.appendChild(e_Seeing);
        }
        if (this.scope != null) {
            e_Observation = this.scope.addAsLinkToXmlElement(e_Observation);
        }
        if (this.accessories != null) {
            Element e_Accessories = ownerDoc.createElement("accessories");
            CDATASection n_AccessoriesText = ownerDoc.createCDATASection(String.valueOf(this.accessories));
            e_Accessories.appendChild(n_AccessoriesText);
            e_Observation.appendChild(e_Accessories);
        }
        if (this.eyepiece != null) {
            e_Observation = this.eyepiece.addAsLinkToXmlElement(e_Observation);
        }
        if (this.lens != null) {
            e_Observation = this.lens.addAsLinkToXmlElement(e_Observation);
        }
        if (this.filter != null) {
            e_Observation = this.filter.addAsLinkToXmlElement(e_Observation);
        }
        if (!Float.isNaN(this.magnification)) {
            Element e_Magnification = ownerDoc.createElement("magnification");
            Text n_MagnificationText = ownerDoc.createTextNode(String.valueOf(this.magnification));
            e_Magnification.appendChild(n_MagnificationText);
            e_Observation.appendChild(e_Magnification);
        }
        if (this.imager != null) {
            e_Observation = this.imager.addAsLinkToXmlElement(e_Observation);
        }
        ListIterator iterator = this.results.listIterator();
        IFinding result = null;
        while (iterator.hasNext()) {
            result = (IFinding)iterator.next();
            e_Observation = result.addToXmlElement(e_Observation);
        }
        if (this.images != null && !this.images.isEmpty()) {
            ListIterator imagesIterator = this.images.listIterator();
            Element e_currentImage = null;
            CDATASection n_ImageText = null;
            String path = null;
            while (imagesIterator.hasNext()) {
                e_currentImage = ownerDoc.createElement("image");
                path = (String)imagesIterator.next();
                path = path.replace('\\', '/');
                n_ImageText = ownerDoc.createCDATASection(path);
                e_currentImage.appendChild(n_ImageText);
                e_Observation.appendChild(e_currentImage);
            }
        }
        parent.appendChild(e_Observation);
        return parent;
    }

    public Calendar getBegin() {
        return (Calendar)this.begin.clone();
    }

    public String getAccessories() {
        return this.accessories;
    }

    public Calendar getEnd() {
        if (this.end != null) {
            return (Calendar)this.end.clone();
        }
        return null;
    }

    public IEyepiece getEyepiece() {
        return this.eyepiece;
    }

    public ILens getLens() {
        return this.lens;
    }

    public IFilter getFilter() {
        return this.filter;
    }

    public IImager getImager() {
        return this.imager;
    }

    public float getMagnification() {
        return this.magnification;
    }

    public float getFaintestStar() {
        return this.faintestStar;
    }

    public SurfaceBrightness getSkyQuality() {
        return this.sqmValue;
    }

    public List getImages() {
        if (this.images == null || this.images.isEmpty()) {
            return null;
        }
        return this.images;
    }

    public int getSeeing() {
        return this.seeing;
    }

    public IObserver getObserver() {
        return this.observer;
    }

    public boolean setResult(IFinding result) throws IllegalArgumentException {
        if (this.results == null) {
            throw new IllegalArgumentException("Result cannot be null. ");
        }
        this.results = new LinkedList();
        this.results.add(result);
        return true;
    }

    public boolean setResults(List results) throws IllegalArgumentException {
        if (results == null || results.isEmpty()) {
            throw new IllegalArgumentException("Result list cannot be null or empty. ");
        }
        ListIterator iterator = results.listIterator();
        IFinding current = null;
        if (iterator.hasNext()) {
            try {
                current = (IFinding)iterator.next();
            }
            catch (ClassCastException cce) {
                return false;
            }
        }
        this.results = results;
        return true;
    }

    public void setAccessories(String accessories) {
        if (accessories != null && "".equals(accessories.trim())) {
            this.accessories = null;
            return;
        }
        this.accessories = accessories;
    }

    public boolean setImages(List imagesList) throws IllegalArgumentException {
        if (imagesList == null) {
            throw new IllegalArgumentException("Images list cannot be null. ");
        }
        if (imagesList.isEmpty()) {
            this.images.clear();
            return true;
        }
        ListIterator iterator = imagesList.listIterator();
        String current = null;
        if (iterator.hasNext()) {
            try {
                current = (String)iterator.next();
            }
            catch (ClassCastException cce) {
                return false;
            }
        }
        this.images = imagesList;
        return true;
    }

    public void setImager(IImager imager) {
        this.imager = imager;
    }

    public boolean addResults(List results) {
        if (results == null || results.isEmpty()) {
            return false;
        }
        ListIterator iterator = results.listIterator();
        IFinding current = null;
        while (iterator.hasNext()) {
            try {
                current = (IFinding)iterator.next();
            }
            catch (ClassCastException cce) {
                return false;
            }
        }
        this.results.addAll(results);
        return true;
    }

    public void addResult(IFinding result) {
        if (result == null) {
            return;
        }
        this.results.add(result);
    }

    public boolean addImages(List images) {
        if (images == null || images.isEmpty()) {
            return false;
        }
        ListIterator iterator = images.listIterator();
        String current = null;
        while (iterator.hasNext()) {
            try {
                current = (String)iterator.next();
            }
            catch (ClassCastException cce) {
                return false;
            }
        }
        this.images.addAll(images);
        return true;
    }

    public void addImage(String imagePath) {
        if (imagePath == null) {
            return;
        }
        this.images.add(imagePath);
    }

    public List getResults() {
        return this.results;
    }

    public IScope getScope() {
        return this.scope;
    }

    public ISession getSession() {
        return this.session;
    }

    public ISite getSite() {
        return this.site;
    }

    public ITarget getTarget() {
        return this.target;
    }

    public void setBegin(Calendar begin) throws IllegalArgumentException {
        if (begin == null) {
            throw new IllegalArgumentException("Begin date cannot be null. ");
        }
        this.begin = (Calendar)begin.clone();
    }

    public void setEnd(Calendar end) {
        if (end == null) {
            this.end = null;
            return;
        }
        this.end = (Calendar)end.clone();
    }

    public void setEyepiece(IEyepiece eyepiece) {
        this.eyepiece = eyepiece;
    }

    public void setLens(ILens lens) {
        this.lens = lens;
    }

    public void setFilter(IFilter filter) {
        this.filter = filter;
    }

    public void setFaintestStar(float faintestStar) {
        this.faintestStar = faintestStar;
    }

    public void setMagnification(float magnification) {
        this.magnification = magnification;
    }

    public void setSkyQuality(SurfaceBrightness sq) {
        this.sqmValue = sq;
    }

    public void setSeeing(int seeing) throws IllegalArgumentException {
        if (seeing == -1) {
            this.seeing = -1;
            return;
        }
        if (seeing < 1 || seeing > 5) {
            throw new IllegalArgumentException("Seeing must be 1,2,3,4 or 5, but was: " + seeing + "\nIf you wanna clear the entry, please pass -1 as parameter.");
        }
        this.seeing = seeing;
    }

    public void setObserver(IObserver observer) throws IllegalArgumentException {
        if (observer == null) {
            throw new IllegalArgumentException("Observer cannot be null. ");
        }
        this.observer = observer;
    }

    public void setScope(IScope scope) {
        this.scope = scope;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSession(ISession session) throws IllegalArgumentException {
        if (session == null) {
            this.session = null;
            return;
        }
        Calendar sessionStart = session.getBegin();
        Calendar sessionEnd = session.getEnd();
        if (this.begin.before(sessionStart)) throw new IllegalArgumentException("Session start date if after observations start date. ");
        if (this.end != null) {
            if (this.end.after(sessionEnd)) throw new IllegalArgumentException("Session end date if before observations end date. ");
            this.session = session;
        }
        this.session = session;
    }

    public void setSite(ISite site) {
        this.site = site;
    }

    public void setTarget(ITarget target) throws IllegalArgumentException {
        if (target == null) {
            throw new IllegalArgumentException("Target cannot be null. ");
        }
        this.target = target;
    }

    private IFinding createFindingElements(Node result) throws SchemaException {
        Element finding = (Element)result;
        String xsiType = this.target.getXSIType();
        IFinding object = SchemaLoader.getFindingFromXSIType((String)xsiType, (Node)finding);
        if (object != null) {
            IFinding currentFinding = null;
            if (object instanceof IFinding) {
                currentFinding = object;
                return currentFinding;
            }
            throw new SchemaException("Unable to load class of type: " + xsiType + "\nClass seems not to be of type IFinding. ");
        }
        throw new SchemaException("Unable to load class of type: " + xsiType);
    }

    private List sortResultList(List results) {
        Collections.sort(results, new Comparator(){

            public int compare(Object o1, Object o2) {
                IFinding f1 = (IFinding)o1;
                IFinding f2 = (IFinding)o2;
                return f1.getDescription().compareTo(f2.getDescription());
            }

            public boolean equals(Object obj) {
                return false;
            }
        });
        return results;
    }
}

