/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om;

import de.lehmannet.om.IImager;
import de.lehmannet.om.SchemaElement;
import de.lehmannet.om.util.SchemaException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class Imager
extends SchemaElement
implements IImager {
    private String model = new String();
    private String vendor = null;
    private String remarks = null;
    private boolean available = true;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Imager(Node imager) throws SchemaException, IllegalArgumentException {
        if (imager == null) {
            throw new IllegalArgumentException("Parameter imager node cannot be NULL. ");
        }
        Element imagerElement = (Element)imager;
        NodeList children = null;
        Element child = null;
        String ID = imagerElement.getAttribute("id");
        if (ID != null && "".equals(ID.trim())) {
            throw new SchemaException("Imager must have a ID. ");
        }
        super.setID(ID);
        children = imagerElement.getElementsByTagName("model");
        if (children == null || children.getLength() != 1) {
            throw new SchemaException("Imager must have exact one model name. ");
        }
        child = (Element)children.item(0);
        String model = "";
        if (child == null) {
            throw new SchemaException("Imager must have a model name. ");
        }
        if (child.getFirstChild() == null) throw new SchemaException("Imager cannot have an empty model name. ");
        NodeList textElements = child.getChildNodes();
        if (textElements != null && textElements.getLength() > 0) {
            for (int te = 0; te < textElements.getLength(); ++te) {
                model = model + textElements.item(te).getNodeValue();
            }
            this.setModel(model);
        }
        NodeList list = imagerElement.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node c = list.item(i);
            if (c.getNodeType() != 8 || !"Element no longer available".equals(c.getNodeValue())) continue;
            this.available = false;
            break;
        }
        child = null;
        children = imagerElement.getElementsByTagName("vendor");
        String vendor = "";
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem while retrieving vendor from imager. ");
                NodeList textElements2 = child.getChildNodes();
                if (textElements2 != null && textElements2.getLength() > 0) {
                    for (int te = 0; te < textElements2.getLength(); ++te) {
                        vendor = vendor + textElements2.item(te).getNodeValue();
                    }
                    this.setVendor(vendor);
                }
            } else if (children.getLength() > 1) {
                throw new SchemaException("Imager can have only one vendor. ");
            }
        }
        child = null;
        children = imagerElement.getElementsByTagName("remarks");
        String remarks = "";
        if (children == null) return;
        if (children.getLength() == 1) {
            child = (Element)children.item(0);
            if (child == null) throw new SchemaException("Problem while retrieving remarks from imager. ");
            NodeList textElements3 = child.getChildNodes();
            if (textElements3 == null || textElements3.getLength() <= 0) return;
            for (int te = 0; te < textElements3.getLength(); ++te) {
                remarks = remarks + textElements3.item(te).getNodeValue();
            }
            this.setRemarks(remarks);
            return;
        } else {
            if (children.getLength() <= 1) return;
            throw new SchemaException("Imager can have only one remark element. ");
        }
    }

    protected Imager(String model) throws IllegalArgumentException {
        this.setModel(model);
    }

    public String getDisplayName() {
        String dn = this.getModel();
        if (this.vendor != null && !"".equals(this.vendor.trim())) {
            dn = this.getVendor() + " " + dn;
        }
        return dn;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailability(boolean available) {
        this.available = available;
    }

    public abstract Element addToXmlElement(Element var1);

    public Element addAsLinkToXmlElement(Element parent, boolean addElementToContainer) {
        if (parent == null) {
            return null;
        }
        Document ownerDoc = parent.getOwnerDocument();
        Element e_Link = ownerDoc.createElement("imager");
        Text n_LinkText = ownerDoc.createTextNode(super.getID());
        e_Link.appendChild(n_LinkText);
        parent.appendChild(e_Link);
        if (addElementToContainer) {
            Element e_Imagers = null;
            NodeList nodeList = ownerDoc.getElementsByTagName("imagers");
            if (nodeList.getLength() == 0) {
                e_Imagers = ownerDoc.createElement("imagers");
                ownerDoc.getDocumentElement().appendChild(e_Imagers);
            } else {
                e_Imagers = (Element)nodeList.item(0);
            }
            this.addToXmlElement(e_Imagers);
        }
        return parent;
    }

    public Element addAsLinkToXmlElement(Element element) {
        return this.addAsLinkToXmlElement(element, false);
    }

    public String getModel() {
        return this.model;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setModel(String modelname) throws IllegalArgumentException {
        if (modelname == null || "".equals(modelname)) {
            throw new IllegalArgumentException("Model name cannot be NULL or empty string.S\n");
        }
        this.model = modelname;
    }

    public void setVendor(String vendor) {
        if (vendor != null && "".equals(vendor.trim())) {
            this.vendor = null;
            return;
        }
        this.vendor = vendor;
    }

    public void setRemarks(String remarks) {
        if (remarks != null && "".equals(remarks.trim())) {
            this.remarks = null;
            return;
        }
        this.remarks = remarks;
    }

    protected Element createXmlImagerElement(Element parent) {
        if (parent == null) {
            return null;
        }
        Document ownerDoc = parent.getOwnerDocument();
        NodeList nodeList = parent.getElementsByTagName("imager");
        if (nodeList.getLength() > 0) {
            Node currentNode = null;
            NamedNodeMap attributes = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                currentNode = nodeList.item(i);
                attributes = currentNode.getAttributes();
                Node idAttribute = attributes.getNamedItem("id");
                if (idAttribute == null || !idAttribute.getNodeValue().trim().equals(super.getID().trim())) continue;
                return parent;
            }
        }
        Element e_Imager = ownerDoc.createElement("imager");
        e_Imager.setAttribute("id", super.getID());
        parent.appendChild(e_Imager);
        if (!this.isAvailable()) {
            Comment comment = ownerDoc.createComment("Element no longer available");
            e_Imager.appendChild(comment);
        }
        Element e_Model = ownerDoc.createElement("model");
        CDATASection n_ModelText = ownerDoc.createCDATASection(this.model);
        e_Model.appendChild(n_ModelText);
        e_Imager.appendChild(e_Model);
        if (this.vendor != null) {
            Element e_Vendor = ownerDoc.createElement("vendor");
            CDATASection n_VendorText = ownerDoc.createCDATASection(this.vendor);
            e_Vendor.appendChild(n_VendorText);
            e_Imager.appendChild(e_Vendor);
        }
        if (this.remarks != null) {
            Element e_Remarks = ownerDoc.createElement("remarks");
            CDATASection n_RemarksText = ownerDoc.createCDATASection(this.remarks);
            e_Remarks.appendChild(n_RemarksText);
            e_Imager.appendChild(e_Remarks);
        }
        return e_Imager;
    }
}

