#ifndef _DBRECORD_H_
#define _DBRECORD_H_

#ifndef _DBFILE_H_
#include "DBFile.h"
#endif

@interface DBRecord : Object
{
  DBFile   *entity;
  long      recNo;
  id        fieldList;
  BOOL      changed;
}

- initForEntity: (DBFile *) anEntity;
- free;

- replace;

- saveChanges: sender;

- setChanged: (BOOL) value;
- (BOOL) changed;

-field: (int) fieldNumber;
-(int) fieldCount;

- (long) recNo;
- copyToDB;
- copyFromDB;

-setFieldData: (unsigned long) field withString: (char *) aString;
-(char *) fieldData: (unsigned long) field;

@end

#endif
