@echo off
:: os2traceenv - Set up Dave Blaschke's os2 trace environment

:: -f force update
:: -q force quiet mode
:: -z zap setup
:: ? show current settings

:: Copyright (c) 2006-2020 Steven Levine and Associates, Inc.
:: All rights reserved.

:: This program is free software licensed under the terms of the GNU
:: General Public License.  The GPL Software License can be found in
:: gnugpl2.txt or at http://www.gnu.org/licenses/licenses.html#GPL

:: 2006-01-05 SHL Baseline
:: 2011-03-02 SHL Support cmd.exe
:: 2011-03-02 SHL Support more known locations
:: 2014-11-09 SHL Switch to standard template
:: 2014-11-09 SHL Support ? to show settings
:: 2020-04-01 SHL Look in %_BOOT and %UNIXROOT for \devtools\os2trace
:: 2020-08-21 SHL Warn if running from os2trace app directory - not sure it really needed

if "%@eval[0]" == "0" goto is4xxx
  goto UsingCmdExe
  goto eof
:is4xxx


loadbtm on
on errormsg pause
:: setlocal - do later maybe

if "%_DOS%" != "OS2" ( echo Must run in 4OS2 session %+ beep %+ cancel )

:: Try to be low impact on environment since we can not setlocal yet

for %X in ( F Q Z ) set %X=
do while %# != 0
  set A=%1
  set X=%@substr[%A,0,1]
  iff "%X" eq "/" .or. "%X" eq "-" then
    :: Got switch
    set X=%@lower[%@substr[%A,1,1]]
    if "%X" == "h" .or. "%X" == "?" goto UsageHelp
    iff "%X" == "f" then
      set F=-f
    elseiff "%X" == "q" then
      set Q=-q
    elseiff "%X" == "z" then
      set Z=-z
    elseiff "%X" == "-" then
      :: End of local args
      shift /1
      leave
    else
      echo Switch %A unexpected
      goto UsageError
    endiff
    shift /1
    iterate
  endiff
  if "%A" == "?" ( gosub ShowSettings %+ goto Quit )
  :: Use remaining args for command line
  leave
enddo

iff defined Z then
  :: Zap setup
  iff not defined _OS2TRACEDIR .and. not defined F then
    echo _OS2TRACEDIR not set
  else
    if defined _OS2TRACEDIR call delpath -q ALL %_OS2TRACEDIR\*
    for %X in ( _OS2TRACEDIR ) do set %X=
    if %@index[%_WINTITLE,os2trace] gt -1 title %@name[%OS2_SHELL]
    echo os2trace setup deleted from environment
  endiff
  goto Quit
endiff

iff defined _OS2TRACEDIR .and. not defined F then
  echo _OS2TRACEDIR already set to %_OS2TRACEDIR
  goto Quit
endiff

:: If have args preserve local environment
if %# != 0 setlocal

set _OS2TRACEDIR=

do 1
  set D=%_CWD
  if exist %D\os2trace.exe leave

  set D=%@lower[%_DISK]:\devtools\os2trace
  if exist %D\os2trace.exe leave
  set D=%@lower[%_BOOT]:\devtools\os2trace
  if exist %D\os2trace.exe leave
  set D=%@lower[%UNIXROOT]:\devtools\os2trace
  if exist %D\os2trace.exe leave

  set D=%@lower[%_BOOT]:\programs\os2trace
  if exist %D\os2trace.exe leave
  set D=%@lower[%UNIXROOT]:\programs\os2trace
  if exist %D\os2trace.exe leave

  set D=d:\devtools\os2trace
  if %@ready[%D] == 1 if exist %D\os2trace.exe leave

  echo Can not locate os2trace.exe in well known locations
  beep
  cancel
enddo

set _OS2TRACEDIR=%D

:: Augment paths
set PATH=%D;%PATH
set DPATH=.;%D;%DPATH
set HELP=.;%D;%HELP
set BEGINLIBPATH=%D;%BEGINLIBPATH

:: If no args
iff %# == 0 then
  :: No args - configure user interface unless suppressed
  iff %_PTYPE == AVIO .or. %_PTYPE == FS .and. not defined Q then
    iff %_BATCH == 1 then
      :: not nested ...
      title os2trace %@name[%OS2_SHELL] Shell
      echo.
      echo on
      history /a pmos2trc
      history /a os2trace
      @echo off
    endiff
    iff %_BATCH == 1 then
      echo.
      echo Environment prepared for os2trace found at %_OS2TRACEDIR
      if %_OS2TRACEDIR eq %_CWD ( echo Warning: running from os2trace application directory %+ beep )
      echo Run pmos2trc to trace enable applications
    endiff
  endiff

  goto Quit
endiff

:: Got args - pass to shell
%$

:: Drop thru to Quit
:: end main

::=== Quit() Clean up and exit ===

:Quit
  gosub Clean
  quit

::=== Clean() Clean up ===

:Clean
  for %X in ( A F Q Z ) set %X=
  set X=
  return

::=== ShowSettings () Show current settings ===

:ShowSettings
  for %X in ( PATH ) echo %X=%@substr[%[%X],0,70]...
  for %X in ( BEGINLIBPATH _OS2TRACEDIR ) echo %X=%[%X]
  return

::=== UsageError() Report usage error ===

:UsageError
  beep
  echo Usage: %@lower[%0] `[-f] [-h] [-q] [-z] [--] [?] [cmd [args...]]`
  gosub Clean
  cancel

::=== UsageHelp() Display usage help ===

:UsageHelp
  echo.
  echo Set up os2trace environment
  echo.
  echo Usage: %@lower[%0] `[-f] [-h] [-q] [-z] [--] [?] [cmd [args...]]`
  echo.
  echo `  -f    Force setup`
  echo `  -h    Display this message`
  echo `  -q    Quiet`
  echo `  -z    Zap setup`
  echo `  ?     Show settings`
  echo `  --    End of` %@name[%0] args
  echo.
  echo `  cmd   Command to run`
  echo `  args  Arguments for cmd`
  gosub Clean
  cancel

::====================
::=== Using cmd.exe ==
::====================

:UsingCmdExe

set D=d:\devtools\os2trace
if exist %D%\os2trace.exe goto gotexe
set D=d:\os2trace
if exist %D%\os2trace.exe goto gotexe
echo Can not locate os2trace.exe
goto eof
:gotexe

:: Augment paths
set PATH=%D%;%PATH%
set DPATH=.;%D%;%DPATH%
set HELP=.;%D%;%HELP%
set BEGINLIBPATH=%D%;%BEGINLIBPATH%

echo.
echo environment prepared for os2trace found at %D%
set D=
echo Run pmos2trc to trace enable applications

goto eof

:: end UsingCmdExe

:eof
