/****************************************************************************
 * Copyright Notice:														*
 *  (c) Copyright 1996 by Stardock Systems.  ALL RIGHTS RESERVED.           *
 *      This work protected by US Copyright Law.                            *
 *	You may not create derived works from this material.					*
 ****************************************************************************
 * Name:            COMPPAK.CMD                                             *
 *																			*
 * Description:     REXX script to install RAR and TAR plug-ins for the     *
 *                  Object Archive feature in Object Desktop and Object     *
 *                  Desktop Professional.                                   *
 ****************************************************************************/

/* Load system functions. */
Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs

/* Get arguments. */
Parse Upper Arg Command szParams
If Command = '' Then Do
    Say
    Say 'Usage:     COMPPAK [I|U] [Options]'
    Say
    Say 'Specify:   "I" to install.'
    Say '           "U" to un-install.'
    Say
    '@pause'
    Exit
End

/* Setup globals. */
fJustCreate = 0
fNoCopy = 0
fNoRegistration = 0
fKillFirst = 0
fNoCreate = 0
fNoUpdate = 0
szInstallPath = ''
CreateDisposition = 'UpdateIfExists'

/* Parse parameters. */
If Pos( '/NR', szParams ) > 0 Then fNoRegistration = 1
If Pos( '/JC', szParams ) > 0 Then fJustCreate = 1
If Pos( '/NC', szParams ) > 0 Then fNoCreate = 1
If Pos( '/K', szParams ) > 0 Then fKillFirst = 1
If Pos( '/I',  szParams ) > 0 Then Parse Value szParams With . '/I'szInstallPath' ' .
If Pos( '/NU', szParams ) > 0 Then fNoUpdate = 1

Classes.0 = 2

Classes.1.szClassNames  = 'TSRarMgr,TSRarElem'
Classes.1.szDLLBase     = 'objdarar'
Classes.1.szObjectID    = '<OBJD_EMPTYRAR>'
Classes.1.szObjectTitle = 'Empty.Rar'
Classes.1.szSetupString = 'TEMPLATE=YES'
Classes.1.szParentObj   = ''

Classes.2.szClassNames  = 'TSTarMgr,TSTarElem'
Classes.2.szDLLBase     = 'objdatar'
Classes.2.szObjectID    = '<OBJD_EMPTYTAR>'
Classes.2.szObjectTitle = 'Empty.Tar'
Classes.2.szSetupString = 'TEMPLATE=YES'
Classes.2.szParentObj	= ''

/* Get path to install directory */
If szInstallPath = '' Then Do
    szInstallPath = SysIni( , 'WPTS', 'InstallDir' )

    /*
     * Get rid of trailing '00'x, which is usually the case in NULL
     * terminated strings written by a C or C++ program.
     */
    If Right( szInstallPath, 1 ) = '00'x Then
        szInstallPath = Left( szInstallPath, Length( szInstallPath ) - 1 )
End
If szInstallPath = '' | szInstallPath = 'ERROR:' Then GetOut( 'Could not find installation dir.' )
rc = SysMkDir( szInstallPath )
Say 'Installation directory is ['szInstallPath']'

/* Uninstall? */
If Command = 'I' Then Do

    /* Do readmes. */
    Call DoReadmes

    /* Not just creating? */
    If \fJustCreate Then Do

        /* Register the classes */
        If \fNoRegistration Then Do

            /* Register classes. */
            Do i = 1 To Classes.0

                /* First copy the DLL (if necessary). */
                If \fNoUpdate & Translate( Directory() ) <> Translate( szInstallPath ) Then Do
                    Say 'Copying file 'Classes.i.szDLLBase'.dll'
                    '@copy 'Classes.i.szDLLBase'.dll 'szInstallPath' 1>nul 2>nul'
                    If rc <> 0 Then GetOut( 'Could not copy file 'Classes.i.szDLLBase'.dll to installation directory.' )
                End

                /* This class in effect? */
                If Classes.i.szDLLBase <> '' Then Do

                    /* For each class. */
                    pszClassNames = Classes.i.szClassNames
                    Do Forever
                        /* Get next class. */
                        Parse Value pszClassNames With pszClassName','pszClassNames
                        If pszClassName = '' Then Leave

                        /* Register this class. */
                        Say 'Registering class "'pszClassName'" with DLL "'Classes.i.szDLLBase'".'
                        rc = SysRegisterObjectClass( pszClassName, Classes.i.szDLLBase )

                        /* Check for errors. */
                        If rc <> 1 Then GetOut( 'Could not register the object class 'pszClassName' with DLL 'Classes.i.szDLLBase'.' )
                    End
                End
            End
        End
    End

    /* Create instance objects. */
    If \fNoCreate Then Do
        Do i = 1 To Classes.0

            /* This class in effect? */
            If Classes.i.szObjectID <> '' Then Do

                /* Get next class. */
                Parse Value Classes.i.szClassNames With pszClassName','pszClassNames

                /* Get parent. */
                ParentObj = '<OBJD_FOLDER>'
                if Classes.i.szParentObj <> '' Then
                    ParentObj = Classes.i.szParentObj

                /* Kill first? */
                If fKillFirst & Length( Classes.i.szObjectID ) > 0 Then Do
                    Say 'Destroying object "'Classes.i.szObjectID'".'
                    rc = SysDestroyObject( Classes.i.szObjectID )
                    rc = SysIni( USER, "PM_Workplace:Location", Classes.i.szObjectID, 'DELETE:' )
                End

                /* Create the button object. */
                Say 'Creating object "'Classes.i.szObjectTitle'" with class "'pszClassName'" in object "'ParentObj'".'
                Say ' > OBJECTID='Classes.i.szObjectID';'Classes.i.szSetupString';'
                rc = SysCreateObject(   pszClassName,,
                                        Classes.i.szObjectTitle,,
                                        ParentObj,,
                                        'OBJECTID='Classes.i.szObjectID';'Classes.i.szSetupString';',,
                                        CreateDisposition )
                If rc <> 1 Then Do
                    rc = SysCreateObject(   pszClassName,,
                                            Classes.i.szObjectTitle,,
                                            '<WP_DESKTOP>',,
                                            Classes.i.szSetupString';',,
                                            CreateDisposition )
                    If rc <> 1 Then Do
                        If fAutoFail Then Say 'Could not create new object.'
                        Else rc = GetOut( 'Could not create new object.' )
                    End
                End
            End
        End
    End

    '@cls'
    Say 'Installation successful.'
    Call SysSetObjectData '<OBJD_FOLDER>', 'OPEN=DEFAULT;'
End
Else If Command = 'U' Then Do

    '@cls'
    Call CharOut, 'Are you sure you want to uninstall? (y or N)  '
    AKey = Translate( SysGetKey( 'NOECHO' ) )
    If AKey <> Y Then Exit
    Say
    Say

    Do i = 1 To Classes.0

        /* Destroy RAR template. */
        rc = SysDestroyObject( Classes.i.szObjectID )
        If \rc Then Say 'Could not destroy template.'

        /* For each class. */
        pszClassNames = Classes.i.szClassNames
        Do Forever
            /* Get next class. */
            Parse Value pszClassNames With pszClassName','pszClassNames
            If pszClassName = '' Then Leave

            /* Register this class. */
            Say 'Deregistering class "'pszClassName'".'
            rc = SysDeRegisterObjectClass( pszClassName )

            /* Check for errors. */
            If rc <> 1 Then Say 'Could not de-register the object class 'pszClassName'.'
        End
    End
End
Else
    Say 'Unrecognized argument "'Command'".'

Exit


GetOut:
    Parse Arg String
    Say String
    Exit


DoReadmes:
    Do i = 1 To 6
        '@cls'
        '@type Comppak'i' 2>nul'
        If rc <> 0 Then GetOut( 'Error!  Could not find readme banner file Comppak'i'.' )

        Say
        Call CharOut, '    Type "Y" to continue. or any other key to quit.'
        AKey = Translate( SysGetKey( 'NOECHO' ) )
        If AKey <> Y Then Exit
    End
    '@cls'
    return
