/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.HashMap;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.IPolyExpression;
import org.eclipse.jdt.internal.compiler.ast.Invocation;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ImplicitNullAnnotationVerifier;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolyTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticFactoryMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;

public class AllocationExpression
extends Expression
implements IPolyExpression,
Invocation {
    public TypeReference type;
    public Expression[] arguments;
    public MethodBinding binding;
    MethodBinding syntheticAccessor;
    public TypeReference[] typeArguments;
    public TypeBinding[] genericTypeArguments;
    public FieldDeclaration enumConstant;
    protected TypeBinding typeExpected;
    public boolean inferredReturnType;
    public FakedTrackingVariable closeTracker;
    public ExpressionContext expressionContext = ExpressionContext.VANILLA_CONTEXT;
    private SimpleLookupTable inferenceContexts;
    public HashMap<TypeBinding, MethodBinding> solutionsPerTargetType;
    private InferenceContext18 outerInferenceContext;
    public boolean argsContainCast;
    public TypeBinding[] argumentTypes = Binding.NO_PARAMETERS;
    public boolean argumentsHaveErrors = false;

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.checkCapturedLocalInitializationIfNecessary((ReferenceBinding)this.binding.declaringClass.erasure(), blockScope, flowInfo);
        if (this.arguments != null) {
            boolean bl = blockScope.compilerOptions().analyseResourceLeaks;
            boolean bl2 = bl && this.resolvedType instanceof ReferenceBinding && ((ReferenceBinding)this.resolvedType).hasTypeBit(4);
            int n = this.arguments.length;
            for (int i = 0; i < n; ++i) {
                flowInfo = this.arguments[i].analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
                if (bl && !bl2) {
                    flowInfo = FakedTrackingVariable.markPassedToOutside(blockScope, this.arguments[i], flowInfo, flowContext, false);
                }
                this.arguments[i].checkNPEbyUnboxing(blockScope, flowContext, flowInfo);
            }
            this.analyseArguments(blockScope, flowContext, flowInfo, this.binding, this.arguments);
        }
        TypeBinding[] typeBindingArray = this.binding.thrownExceptions;
        if (this.binding.thrownExceptions.length != 0) {
            if ((this.bits & 0x10000) != 0 && this.genericTypeArguments == null) {
                typeBindingArray = blockScope.environment().convertToRawTypes(this.binding.thrownExceptions, true, true);
            }
            flowContext.checkExceptionHandlers(typeBindingArray, (ASTNode)this, (FlowInfo)flowInfo.unconditionalCopy(), blockScope);
        }
        if (blockScope.compilerOptions().analyseResourceLeaks && FakedTrackingVariable.isAnyCloseable(this.resolvedType)) {
            FakedTrackingVariable.analyseCloseableAllocation(blockScope, flowInfo, this);
        }
        ReferenceBinding referenceBinding = this.binding.declaringClass;
        MethodScope methodScope = blockScope.methodScope();
        if (referenceBinding.isMemberType() && !referenceBinding.isStatic() || referenceBinding.isLocalType() && !methodScope.isStatic && methodScope.isLambdaScope()) {
            blockScope.tagAsAccessingEnclosingInstanceStateOf(this.binding.declaringClass.enclosingType(), false);
        }
        this.manageEnclosingInstanceAccessIfNecessary(blockScope, flowInfo);
        this.manageSyntheticAccessIfNecessary(blockScope, flowInfo);
        flowContext.recordAbruptExit();
        return flowInfo;
    }

    public void checkCapturedLocalInitializationIfNecessary(ReferenceBinding referenceBinding, BlockScope blockScope, FlowInfo flowInfo) {
        NestedTypeBinding nestedTypeBinding;
        SyntheticArgumentBinding[] syntheticArgumentBindingArray;
        if ((referenceBinding.tagBits & 0x834L) == 2068L && !blockScope.isDefinedInType(referenceBinding) && (syntheticArgumentBindingArray = (nestedTypeBinding = (NestedTypeBinding)referenceBinding).syntheticOuterLocalVariables()) != null) {
            for (SyntheticArgumentBinding syntheticArgumentBinding : syntheticArgumentBindingArray) {
                LocalVariableBinding localVariableBinding = syntheticArgumentBinding.actualOuterLocalVariable;
                if (localVariableBinding == null || localVariableBinding.declaration == null || flowInfo.isDefinitelyAssigned(localVariableBinding)) continue;
                blockScope.problemReporter().uninitializedLocalVariable(localVariableBinding, this, blockScope);
            }
        }
    }

    public Expression enclosingInstance() {
        return null;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        boolean bl2;
        this.cleanUpInferenceContexts();
        if (!bl) {
            blockScope.problemReporter().unusedObjectAllocation(this);
        }
        int n = codeStream.position;
        MethodBinding methodBinding = this.binding.original();
        ReferenceBinding referenceBinding = methodBinding.declaringClass;
        codeStream.new_(this.type, referenceBinding);
        boolean bl3 = bl2 = (this.implicitConversion & 0x400) != 0;
        if (bl || bl2) {
            codeStream.dup();
        }
        if (this.type != null) {
            codeStream.recordPositionsFrom(n, this.type.sourceStart);
        } else {
            codeStream.ldc(String.valueOf(this.enumConstant.name));
            codeStream.generateInlinedValue(this.enumConstant.binding.id);
        }
        if (referenceBinding.isNestedType()) {
            codeStream.generateSyntheticEnclosingInstanceValues(blockScope, referenceBinding, this.enclosingInstance(), this);
        }
        this.generateArguments(this.binding, this.arguments, blockScope, codeStream);
        if (referenceBinding.isNestedType()) {
            codeStream.generateSyntheticOuterArgumentValues(blockScope, referenceBinding, this);
        }
        if (this.syntheticAccessor == null) {
            codeStream.invoke((byte)-73, methodBinding, null, this.typeArguments);
        } else {
            int n2 = this.syntheticAccessor.parameters.length - methodBinding.parameters.length;
            for (int i = 0; i < n2; ++i) {
                codeStream.aconst_null();
            }
            codeStream.invoke((byte)-73, this.syntheticAccessor, null, this.typeArguments);
        }
        if (bl) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else if (bl2) {
            codeStream.generateImplicitConversion(this.implicitConversion);
            switch (this.postConversionType((Scope)blockScope).id) {
                case 7: 
                case 8: {
                    codeStream.pop2();
                    break;
                }
                default: {
                    codeStream.pop();
                }
            }
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    @Override
    public TypeBinding[] genericTypeArguments() {
        return this.genericTypeArguments;
    }

    @Override
    public boolean isSuperAccess() {
        return false;
    }

    @Override
    public boolean isTypeAccess() {
        return true;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding.declaringClass.erasure();
        if (referenceBinding.isNestedType() && (blockScope.enclosingSourceType().isLocalType() || blockScope.isLambdaSubscope())) {
            if (referenceBinding.isLocalType()) {
                ((LocalTypeBinding)referenceBinding).addInnerEmulationDependent(blockScope, false);
            } else {
                blockScope.propagateInnerEmulation(referenceBinding, false);
            }
        }
    }

    public void manageSyntheticAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
        MethodBinding methodBinding = this.binding.original();
        if (methodBinding.isPrivate() && !blockScope.enclosingSourceType().isNestmateOf(this.binding.declaringClass)) {
            ReferenceBinding referenceBinding = methodBinding.declaringClass;
            if (TypeBinding.notEquals(blockScope.enclosingSourceType(), referenceBinding)) {
                if ((referenceBinding.tagBits & 0x10L) != 0L && blockScope.compilerOptions().complianceLevel >= 0x300000L) {
                    methodBinding.tagBits |= 0x200L;
                } else {
                    this.syntheticAccessor = ((SourceTypeBinding)referenceBinding).addSyntheticMethod(methodBinding, this.isSuperAccess());
                    blockScope.problemReporter().needToEmulateMethodAccess(methodBinding, this);
                }
            }
        }
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        int n2;
        if (this.type != null) {
            stringBuffer.append("new ");
        }
        if (this.typeArguments != null) {
            stringBuffer.append('<');
            n2 = this.typeArguments.length - 1;
            for (int i = 0; i < n2; ++i) {
                this.typeArguments[i].print(0, stringBuffer);
                stringBuffer.append(", ");
            }
            this.typeArguments[n2].print(0, stringBuffer);
            stringBuffer.append('>');
        }
        if (this.type != null) {
            this.type.printExpression(0, stringBuffer);
        }
        stringBuffer.append('(');
        if (this.arguments != null) {
            for (n2 = 0; n2 < this.arguments.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[n2].printExpression(0, stringBuffer);
            }
        }
        return stringBuffer.append(')');
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        boolean bl = this.type != null && (this.type.bits & 0x80000) != 0;
        CompilerOptions compilerOptions = blockScope.compilerOptions();
        long l = compilerOptions.sourceLevel;
        if (this.constant != Constant.NotAConstant) {
            int n;
            this.constant = Constant.NotAConstant;
            this.resolvedType = this.type == null ? blockScope.enclosingReceiverType() : this.type.resolveType(blockScope, true);
            if (this.type != null) {
                this.checkIllegalNullAnnotation(blockScope, this.resolvedType);
                if (this.type instanceof ParameterizedQualifiedTypeReference) {
                    ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
                    if (referenceBinding == null) {
                        return referenceBinding;
                    }
                    block0: while ((referenceBinding.modifiers & 8) == 0 && !referenceBinding.isRawType()) {
                        if ((referenceBinding = referenceBinding.enclosingType()) != null) continue;
                        ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference = (ParameterizedQualifiedTypeReference)this.type;
                        for (n = parameterizedQualifiedTypeReference.typeArguments.length - 2; n >= 0; --n) {
                            if (parameterizedQualifiedTypeReference.typeArguments[n] == null) continue;
                            blockScope.problemReporter().illegalQualifiedParameterizedTypeAllocation(this.type, this.resolvedType);
                            break block0;
                        }
                    }
                }
            }
            if (this.typeArguments != null) {
                int n2;
                int n3 = this.typeArguments.length;
                this.argumentsHaveErrors = l < 0x310000L;
                this.genericTypeArguments = new TypeBinding[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    TypeReference typeReference = this.typeArguments[n2];
                    this.genericTypeArguments[n2] = typeReference.resolveType(blockScope, true);
                    if (this.genericTypeArguments[n2] == null) {
                        this.argumentsHaveErrors = true;
                    }
                    if (!this.argumentsHaveErrors || !(typeReference instanceof Wildcard)) continue;
                    blockScope.problemReporter().illegalUsageOfWildcard(typeReference);
                }
                if (bl) {
                    blockScope.problemReporter().diamondNotWithExplicitTypeArguments(this.typeArguments);
                    return null;
                }
                if (this.argumentsHaveErrors) {
                    if (this.arguments != null) {
                        n = this.arguments.length;
                        for (n2 = 0; n2 < n; ++n2) {
                            this.arguments[n2].resolveType(blockScope);
                        }
                    }
                    return null;
                }
            }
            if (this.arguments != null) {
                this.argumentsHaveErrors = false;
                int n4 = this.arguments.length;
                this.argumentTypes = new TypeBinding[n4];
                for (int i = 0; i < n4; ++i) {
                    Expression expression = this.arguments[i];
                    if (expression instanceof CastExpression) {
                        expression.bits |= 0x20;
                        this.argsContainCast = true;
                    }
                    expression.setExpressionContext(ExpressionContext.INVOCATION_CONTEXT);
                    if (this.arguments[i].resolvedType != null) {
                        blockScope.problemReporter().genericInferenceError("Argument was unexpectedly found resolved", this);
                    }
                    if ((this.argumentTypes[i] = expression.resolveType(blockScope)) != null) continue;
                    this.argumentsHaveErrors = true;
                }
                if (this.argumentsHaveErrors) {
                    if (bl) {
                        return null;
                    }
                    if (this.resolvedType instanceof ReferenceBinding) {
                        MethodBinding methodBinding;
                        TypeBinding[] typeBindingArray = new TypeBinding[n4];
                        n = n4;
                        while (--n >= 0) {
                            typeBindingArray[n] = this.argumentTypes[n] == null ? TypeBinding.NULL : this.argumentTypes[n];
                        }
                        this.binding = blockScope.findMethod((ReferenceBinding)this.resolvedType, TypeConstants.INIT, typeBindingArray, this, false);
                        if (this.binding != null && !this.binding.isValidBinding() && (methodBinding = ((ProblemMethodBinding)this.binding).closestMatch) != null) {
                            if (methodBinding.original().typeVariables != Binding.NO_TYPE_VARIABLES) {
                                methodBinding = blockScope.environment().createParameterizedGenericMethod(methodBinding.original(), (RawTypeBinding)null);
                            }
                            this.binding = methodBinding;
                            MethodBinding methodBinding2 = methodBinding.original();
                            if (methodBinding2.isOrEnclosedByPrivateType() && !blockScope.isDefinedInMethod(methodBinding2)) {
                                methodBinding2.modifiers |= 0x8000000;
                            }
                        }
                    }
                    return this.resolvedType;
                }
            }
            if (this.resolvedType == null || !this.resolvedType.isValidBinding()) {
                return null;
            }
            if (this.type != null && !this.resolvedType.canBeInstantiated()) {
                blockScope.problemReporter().cannotInstantiate(this.type, this.resolvedType);
                return this.resolvedType;
            }
        }
        if (bl) {
            TypeBinding typeBinding;
            this.binding = this.inferConstructorOfElidedParameterizedType(blockScope);
            if (this.binding == null || !this.binding.isValidBinding()) {
                blockScope.problemReporter().cannotInferElidedTypes(this);
                this.resolvedType = null;
                return null;
            }
            if (this.typeExpected == null && compilerOptions.sourceLevel >= 0x340000L && this.expressionContext.definesTargetType()) {
                return new PolyTypeBinding(this);
            }
            this.resolvedType = this.type.resolvedType = this.binding.declaringClass;
            if (this.binding.isVarargs() && !(typeBinding = this.binding.parameters[this.binding.parameters.length - 1].leafComponentType()).erasure().canBeSeenBy(blockScope)) {
                blockScope.problemReporter().invalidType(this, new ProblemReferenceBinding(new char[][]{typeBinding.readableName()}, (ReferenceBinding)typeBinding, 2));
                this.resolvedType = null;
                return null;
            }
            this.binding = AllocationExpression.resolvePolyExpressionArguments(this, this.binding, this.argumentTypes, blockScope);
        } else {
            this.binding = this.findConstructorBinding(blockScope, this, (ReferenceBinding)this.resolvedType, this.argumentTypes);
        }
        if (!this.binding.isValidBinding()) {
            if (this.binding.declaringClass == null) {
                this.binding.declaringClass = (ReferenceBinding)this.resolvedType;
            }
            if (this.type != null && !this.type.resolvedType.isValidBinding()) {
                return null;
            }
            blockScope.problemReporter().invalidConstructor(this, this.binding);
            return this.resolvedType;
        }
        if ((this.binding.tagBits & 0x80L) != 0L) {
            blockScope.problemReporter().missingTypeInConstructor(this, this.binding);
        }
        if (this.isMethodUseDeprecated(this.binding, blockScope, true, this)) {
            blockScope.problemReporter().deprecatedMethod(this.binding, this);
        }
        if (AllocationExpression.checkInvocationArguments(blockScope, null, this.resolvedType, this.binding, this.arguments, this.argumentTypes, this.argsContainCast, this)) {
            this.bits |= 0x10000;
        }
        if (this.typeArguments != null && this.binding.original().typeVariables == Binding.NO_TYPE_VARIABLES) {
            blockScope.problemReporter().unnecessaryTypeArgumentsForMethodInvocation(this.binding, this.genericTypeArguments, this.typeArguments);
        }
        if (!bl && this.resolvedType.isParameterizedTypeWithActualArguments()) {
            this.checkTypeArgumentRedundancy((ParameterizedTypeBinding)this.resolvedType, blockScope);
        }
        if (compilerOptions.isAnnotationBasedNullAnalysisEnabled) {
            ImplicitNullAnnotationVerifier.ensureNullnessIsKnown(this.binding, blockScope);
            if (blockScope.environment().usesNullTypeAnnotations()) {
                if (this.binding instanceof ParameterizedGenericMethodBinding && this.typeArguments != null) {
                    TypeBinding[] typeBindingArray = this.binding.original().typeVariables();
                    for (int i = 0; i < this.typeArguments.length; ++i) {
                        this.typeArguments[i].checkNullConstraints(blockScope, (ParameterizedGenericMethodBinding)this.binding, typeBindingArray, i);
                    }
                }
                this.resolvedType = blockScope.environment().createAnnotatedType(this.resolvedType, new AnnotationBinding[]{blockScope.environment().getNonNullAnnotation()});
            }
        }
        if (compilerOptions.sourceLevel >= 0x340000L && this.binding.getTypeAnnotations() != Binding.NO_ANNOTATIONS) {
            this.resolvedType = blockScope.environment().createAnnotatedType(this.resolvedType, this.binding.getTypeAnnotations());
        }
        return this.resolvedType;
    }

    void checkIllegalNullAnnotation(BlockScope blockScope, TypeBinding typeBinding) {
        Annotation annotation;
        long l;
        if (typeBinding != null && (l = typeBinding.tagBits & 0x180000000000000L) != 0L && (annotation = this.type.findAnnotation(l)) != null) {
            blockScope.problemReporter().nullAnnotationUnsupportedLocation(annotation);
        }
    }

    @Override
    public boolean isBoxingCompatibleWith(TypeBinding typeBinding, Scope scope) {
        if (this.isPolyExpression()) {
            return false;
        }
        if (this.argumentsHaveErrors || this.binding == null || !this.binding.isValidBinding() || typeBinding == null || scope == null) {
            return false;
        }
        return this.isBoxingCompatible(this.resolvedType, typeBinding, this, scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCompatibleWith(TypeBinding typeBinding, Scope scope) {
        if (this.argumentsHaveErrors || this.binding == null || !this.binding.isValidBinding() || typeBinding == null || scope == null) {
            return false;
        }
        TypeBinding typeBinding2 = this.resolvedType;
        if (this.isPolyExpression()) {
            TypeBinding typeBinding3 = this.typeExpected;
            try {
                MethodBinding methodBinding;
                MethodBinding methodBinding2 = methodBinding = this.solutionsPerTargetType != null ? this.solutionsPerTargetType.get(typeBinding) : null;
                if (methodBinding == null) {
                    this.typeExpected = typeBinding;
                    methodBinding = this.inferConstructorOfElidedParameterizedType(scope);
                    if (methodBinding == null || !methodBinding.isValidBinding()) {
                        boolean bl = false;
                        return bl;
                    }
                }
                typeBinding2 = methodBinding.declaringClass;
            }
            finally {
                this.typeExpected = typeBinding3;
            }
        }
        return typeBinding2 != null && typeBinding2.isCompatibleWith(typeBinding, scope);
    }

    public MethodBinding inferConstructorOfElidedParameterizedType(Scope scope) {
        MethodBinding methodBinding;
        Object object;
        if (this.typeExpected != null && this.binding != null) {
            object = this.solutionsPerTargetType != null ? this.solutionsPerTargetType.get(this.typeExpected) : null;
            Object object2 = object;
            if (object != null) {
                return object;
            }
        }
        if ((methodBinding = AllocationExpression.inferDiamondConstructor(scope, this, this.resolvedType, this.argumentTypes, object = new boolean[1])) != null) {
            this.inferredReturnType = object[0];
            if (methodBinding instanceof ParameterizedGenericMethodBinding && scope.compilerOptions().sourceLevel >= 0x340000L && this.expressionContext == ExpressionContext.INVOCATION_CONTEXT && this.typeExpected == null) {
                methodBinding = ParameterizedGenericMethodBinding.computeCompatibleMethod18(methodBinding.shallowOriginal(), this.argumentTypes, scope, this);
            }
            if (this.typeExpected != null && this.typeExpected.isProperType(true)) {
                this.registerResult(this.typeExpected, methodBinding);
            }
        }
        return methodBinding;
    }

    public static MethodBinding inferDiamondConstructor(Scope scope, InvocationSite invocationSite, TypeBinding typeBinding, TypeBinding[] typeBindingArray, boolean[] blArray) {
        ReferenceBinding referenceBinding = ((ParameterizedTypeBinding)typeBinding).genericType();
        ReferenceBinding referenceBinding2 = typeBinding.enclosingType();
        ParameterizedTypeBinding parameterizedTypeBinding = scope.environment().createParameterizedType(referenceBinding, referenceBinding.typeVariables(), referenceBinding2);
        MethodBinding methodBinding = scope.getStaticFactory(parameterizedTypeBinding, referenceBinding2, typeBindingArray, invocationSite);
        if (methodBinding instanceof ParameterizedGenericMethodBinding && methodBinding.isValidBinding()) {
            TypeBinding[] typeBindingArray2;
            ParameterizedGenericMethodBinding parameterizedGenericMethodBinding = (ParameterizedGenericMethodBinding)methodBinding;
            blArray[0] = parameterizedGenericMethodBinding.inferredReturnType;
            SyntheticFactoryMethodBinding syntheticFactoryMethodBinding = (SyntheticFactoryMethodBinding)methodBinding.original();
            TypeVariableBinding[] typeVariableBindingArray = syntheticFactoryMethodBinding.getConstructor().typeVariables();
            TypeBinding[] typeBindingArray3 = typeBindingArray2 = typeVariableBindingArray != null ? new TypeBinding[typeVariableBindingArray.length] : Binding.NO_TYPES;
            if (typeBindingArray2.length > 0) {
                System.arraycopy(((ParameterizedGenericMethodBinding)methodBinding).typeArguments, syntheticFactoryMethodBinding.typeVariables().length - typeBindingArray2.length, typeBindingArray2, 0, typeBindingArray2.length);
            }
            if (parameterizedTypeBinding.isInterface()) {
                ParameterizedTypeBinding parameterizedTypeBinding2 = (ParameterizedTypeBinding)methodBinding.returnType;
                return new ParameterizedMethodBinding(parameterizedTypeBinding2, syntheticFactoryMethodBinding.getConstructor());
            }
            return syntheticFactoryMethodBinding.applyTypeArgumentsOnConstructor(((ParameterizedTypeBinding)methodBinding.returnType).arguments, typeBindingArray2, parameterizedGenericMethodBinding.inferredWithUncheckedConversion, invocationSite.invocationTargetType());
        }
        return null;
    }

    public TypeBinding[] inferElidedTypes(Scope scope) {
        return this.inferElidedTypes((ParameterizedTypeBinding)this.resolvedType, scope);
    }

    public TypeBinding[] inferElidedTypes(ParameterizedTypeBinding parameterizedTypeBinding, Scope scope) {
        ReferenceBinding referenceBinding = parameterizedTypeBinding.genericType();
        ReferenceBinding referenceBinding2 = parameterizedTypeBinding.enclosingType();
        ParameterizedTypeBinding parameterizedTypeBinding2 = scope.environment().createParameterizedType(referenceBinding, referenceBinding.typeVariables(), referenceBinding2);
        MethodBinding methodBinding = scope.getStaticFactory(parameterizedTypeBinding2, referenceBinding2, this.argumentTypes, this);
        if (methodBinding instanceof ParameterizedGenericMethodBinding && methodBinding.isValidBinding()) {
            ParameterizedGenericMethodBinding parameterizedGenericMethodBinding = (ParameterizedGenericMethodBinding)methodBinding;
            this.inferredReturnType = parameterizedGenericMethodBinding.inferredReturnType;
            return ((ParameterizedTypeBinding)methodBinding.returnType).arguments;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTypeArgumentRedundancy(ParameterizedTypeBinding parameterizedTypeBinding, BlockScope blockScope) {
        int n;
        TypeBinding[] typeBindingArray;
        if (blockScope.problemReporter().computeSeverity(16778100) == 256 || blockScope.compilerOptions().sourceLevel < 0x330000L) {
            return;
        }
        if (parameterizedTypeBinding.arguments == null) {
            return;
        }
        if (this.genericTypeArguments != null) {
            return;
        }
        if (this.type == null) {
            return;
        }
        if (this.argumentTypes == Binding.NO_PARAMETERS && this.typeExpected instanceof ParameterizedTypeBinding) {
            typeBindingArray = (TypeBinding[])this.typeExpected;
            if (typeBindingArray.arguments != null && parameterizedTypeBinding.arguments.length == typeBindingArray.arguments.length) {
                for (n = 0; n < parameterizedTypeBinding.arguments.length && !TypeBinding.notEquals(parameterizedTypeBinding.arguments[n], typeBindingArray.arguments[n]); ++n) {
                }
                if (n == parameterizedTypeBinding.arguments.length) {
                    blockScope.problemReporter().redundantSpecificationOfTypeArguments(this.type, parameterizedTypeBinding.arguments);
                    return;
                }
            }
        }
        n = this.type.bits;
        try {
            this.type.bits |= 0x80000;
            typeBindingArray = this.inferElidedTypes(parameterizedTypeBinding, blockScope);
        }
        finally {
            this.type.bits = n;
        }
        if (typeBindingArray == null) {
            return;
        }
        for (int i = 0; i < typeBindingArray.length; ++i) {
            if (!TypeBinding.notEquals(typeBindingArray[i], parameterizedTypeBinding.arguments[i])) continue;
            return;
        }
        blockScope.problemReporter().redundantSpecificationOfTypeArguments(this.type, parameterizedTypeBinding.arguments);
    }

    @Override
    public void setActualReceiverType(ReferenceBinding referenceBinding) {
    }

    @Override
    public void setDepth(int n) {
    }

    @Override
    public void setFieldIndex(int n) {
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            int n2;
            if (this.typeArguments != null) {
                n2 = this.typeArguments.length;
                for (n = 0; n < n2; ++n) {
                    this.typeArguments[n].traverse(aSTVisitor, blockScope);
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, blockScope);
            }
            if (this.arguments != null) {
                n2 = this.arguments.length;
                for (n = 0; n < n2; ++n) {
                    this.arguments[n].traverse(aSTVisitor, blockScope);
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public void setExpectedType(TypeBinding typeBinding) {
        this.typeExpected = typeBinding;
    }

    @Override
    public void setExpressionContext(ExpressionContext expressionContext) {
        this.expressionContext = expressionContext;
    }

    @Override
    public boolean isPolyExpression() {
        return this.isPolyExpression(this.binding);
    }

    @Override
    public boolean isPolyExpression(MethodBinding methodBinding) {
        return (this.expressionContext == ExpressionContext.ASSIGNMENT_CONTEXT || this.expressionContext == ExpressionContext.INVOCATION_CONTEXT) && this.type != null && (this.type.bits & 0x80000) != 0;
    }

    @Override
    public TypeBinding invocationTargetType() {
        return this.typeExpected;
    }

    @Override
    public boolean statementExpression() {
        return (this.bits & 0x1FE00000) == 0;
    }

    @Override
    public MethodBinding binding() {
        return this.binding;
    }

    @Override
    public Expression[] arguments() {
        return this.arguments;
    }

    @Override
    public void registerInferenceContext(ParameterizedGenericMethodBinding parameterizedGenericMethodBinding, InferenceContext18 inferenceContext18) {
        if (this.inferenceContexts == null) {
            this.inferenceContexts = new SimpleLookupTable();
        }
        this.inferenceContexts.put(parameterizedGenericMethodBinding, inferenceContext18);
    }

    @Override
    public void registerResult(TypeBinding typeBinding, MethodBinding methodBinding) {
        if (methodBinding != null && methodBinding.isConstructor()) {
            if (this.solutionsPerTargetType == null) {
                this.solutionsPerTargetType = new HashMap();
            }
            this.solutionsPerTargetType.put(typeBinding, methodBinding);
        }
    }

    @Override
    public InferenceContext18 getInferenceContext(ParameterizedMethodBinding parameterizedMethodBinding) {
        if (this.inferenceContexts == null) {
            return null;
        }
        return (InferenceContext18)this.inferenceContexts.get(parameterizedMethodBinding);
    }

    @Override
    public void cleanUpInferenceContexts() {
        if (this.inferenceContexts == null) {
            return;
        }
        for (Object object : this.inferenceContexts.valueTable) {
            if (object == null) continue;
            ((InferenceContext18)object).cleanUp();
        }
        this.inferenceContexts = null;
        this.outerInferenceContext = null;
        this.solutionsPerTargetType = null;
    }

    @Override
    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    @Override
    public InferenceContext18 freshInferenceContext(Scope scope) {
        return new InferenceContext18(scope, this.arguments, this, this.outerInferenceContext);
    }

    @Override
    public int nameSourceStart() {
        if (this.enumConstant != null) {
            return this.enumConstant.sourceStart;
        }
        return this.type.sourceStart;
    }

    @Override
    public int nameSourceEnd() {
        if (this.enumConstant != null) {
            return this.enumConstant.sourceEnd;
        }
        return this.type.sourceEnd;
    }
}

