/*
 * Decompiled with CFR 0.152.
 */
package org.netrexx.process;

import netrexx.lang.Rexx;
import org.netrexx.process.RxClassInfo;
import org.netrexx.process.RxClasser;
import org.netrexx.process.RxClauseParser;
import org.netrexx.process.RxCode;
import org.netrexx.process.RxCursor;
import org.netrexx.process.RxError;
import org.netrexx.process.RxField;
import org.netrexx.process.RxParser;
import org.netrexx.process.RxQuit;
import org.netrexx.process.RxSignal;
import org.netrexx.process.RxToken;
import org.netrexx.process.RxTranslator;
import org.netrexx.process.RxType;

public class NrSignal
implements RxClauseParser {
    private static final Rexx $01 = Rexx.toRexx("new");
    private static final Rexx $02 = Rexx.toRexx("()");
    private static final Rexx $03 = Rexx.toRexx("throw");
    private static final Rexx $04 = new Rexx(';');
    private static final String $0 = "NrSignal.nrx";
    private RxTranslator rxt;
    private RxParser parser;
    private RxToken[] tokens;
    private RxCode term;
    private RxField field;
    private static final RxCode[] noargs = new RxCode[0];

    public NrSignal(RxTranslator rxTranslator) {
        this.rxt = rxTranslator;
        this.parser = this.rxt.program.parser;
        this.tokens = this.parser.cursor.curclause.tokens;
        if (this.tokens[1].type == ';') {
            throw new RxError(this.rxt, this.tokens[1], "signal.term.expected");
        }
    }

    @Override
    public void scan(int n) {
        int n2 = 0;
        RxClassInfo rxClassInfo = null;
        String string = null;
        if (n < 2) {
            throw new RxQuit(this.rxt, this.tokens[0], "internal.error", Rexx.toRexx("NrSignal"), new Rexx(n));
        }
        RxClasser rxClasser = this.rxt.classer;
        this.parser.thislevel.terminal = true;
        n2 = this.tokens[1].type != 'B' ? 1 : 2;
        RxToken rxToken = this.tokens[n2];
        this.term = this.rxt.tparser.parseterm(this.parser.cursor, n2, true);
        if (this.term.group == 'U') {
            throw new RxError(this.rxt, rxToken, "unknown.variable");
        }
        int n3 = this.term.endoff + 1;
        if (this.tokens[n3].type != ';') {
            throw new RxError(this.rxt, this.tokens[n3], "junk.on.end");
        }
        RxType rxType = this.term.type;
        if (rxType.isarray()) {
            throw new RxError(this.rxt, rxToken, "simple.exception.expected");
        }
        if (!this.rxt.classer.issubclass(this.parser.cursor, rxType, RxType.THROWABLE_TYPE, rxToken)) {
            throw new RxError(this.rxt, rxToken, "type.not.exception", rxType.classname);
        }
        if (this.term.group == 'T') {
            rxClassInfo = rxClasser.findclass(this.parser.cursor, rxType, rxToken, false);
            string = rxClassInfo.shortname;
            this.field = rxClasser.findfield(this.parser.cursor, true, true, false, false, rxClassInfo, Rexx.toRexx(string), null, null);
            if (this.field == null) {
                this.field = rxClasser.findfield(this.parser.cursor, true, true, false, false, rxClassInfo, Rexx.toRexx(string), null, null, false);
                if (this.field == null) {
                    throw new RxError(this.rxt, rxToken, "constructor.not.found", Rexx.toRexx(string + "()"), rxType.classname);
                }
                throw new RxError(this.rxt, rxToken, "constructor.not.accessible", Rexx.toRexx(this.field.toConciseString(this.rxt.program)), this.field.fieldhidden.type.classname);
            }
        }
        this.parser.addexceptions(true, this.term.exceptions, rxToken);
        this.parser.addexceptions(true, this.term.type.toSig(), rxToken);
    }

    @Override
    public String[] getAssigns() {
        return null;
    }

    @Override
    public void generate() {
        Rexx rexx = null;
        rexx = this.term.group == 'T' ? $01.OpCcblank(null, this.term.javacode).OpCc(null, $02) : this.term.javacode;
        this.rxt.program.streamer.out($03.OpCcblank(null, rexx).OpCc(null, $04));
    }

    public void interpret() {
        this.interpret(null);
    }

    @Override
    public void interpret(RxCursor rxCursor) {
        RxCode rxCode = null;
        if (this.term.group == 'T') {
            rxCode = this.term;
            rxCode.value = this.rxt.interpreter.callMethod(null, this.field, noargs, this.tokens[0]);
        } else {
            rxCode = this.rxt.tparser.evalterm(rxCursor, this.term.begoff, true);
        }
        throw new RxSignal(rxCursor, rxCode.value, this.tokens[0]);
    }
}

