/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.splitflap.skin;

import eu.hansolo.enzo.common.ShapeConverter;
import eu.hansolo.enzo.common.Util;
import eu.hansolo.enzo.fonts.Fonts;
import eu.hansolo.enzo.splitflap.FlipEvent;
import eu.hansolo.enzo.splitflap.SplitFlap;
import java.util.ArrayList;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ListChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Shape;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.util.Duration;

public class SplitFlapSkin
extends SkinBase<SplitFlap>
implements Skin<SplitFlap> {
    private static final double PREFERRED_WIDTH = 112.0;
    private static final double PREFERRED_HEIGHT = 189.0;
    private static final double MINIMUM_WIDTH = 5.0;
    private static final double MINIMUM_HEIGHT = 5.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static double aspectRatio;
    private final FlipEvent FLIP_FINISHED = new FlipEvent((Object)this, (EventTarget)this.getSkinnable(), FlipEvent.FLIP_FINISHED);
    private ArrayList<String> selectedSet = ((SplitFlap)this.getSkinnable()).getSelectedSet();
    private int currentSelectionIndex = ((SplitFlap)this.getSkinnable()).getSelectedSet().indexOf(((SplitFlap)this.getSkinnable()).getText());
    private int nextSelectionIndex = this.currentSelectionIndex + 1 > ((SplitFlap)this.getSkinnable()).getSelectedSet().size() ? 0 : this.currentSelectionIndex + 1;
    private double width;
    private double height;
    private double flapHeight;
    private Pane pane;
    private Region fixtureRight;
    private Region fixtureLeft;
    private InnerShadow innerShadow;
    private InnerShadow innerHighlight;
    private InnerShadow reversedInnerShadow;
    private InnerShadow reversedInnerHighlight;
    private Region upperBackground;
    private Canvas upperBackgroundText;
    private GraphicsContext ctxUpperBackgroundText;
    private Region lowerBackground;
    private Canvas lowerBackgroundText;
    private GraphicsContext ctxLowerBackgroundText;
    private Region flap;
    private Canvas flapTextFront;
    private GraphicsContext ctxTextFront;
    private Canvas flapTextBack;
    private GraphicsContext ctxTextBack;
    private LinearGradient upperTextFill;
    private LinearGradient lowerTextFill;
    private Font font;
    private Rotate rotateFlap;
    private Timeline timeline;
    private KeyFrame keyFrame;
    private KeyValue keyValueFlap;

    public SplitFlapSkin(SplitFlap CONTROL) {
        super((Control)CONTROL);
        aspectRatio = 1.6875;
        this.pane = new Pane();
        this.rotateFlap = new Rotate();
        this.rotateFlap.setAxis(Rotate.X_AXIS);
        this.rotateFlap.setAngle(0.0);
        this.flapHeight = 93.0;
        this.timeline = new Timeline();
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((SplitFlap)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((SplitFlap)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((SplitFlap)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((SplitFlap)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((SplitFlap)this.getSkinnable()).getPrefWidth() > 0.0 && ((SplitFlap)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((SplitFlap)this.getSkinnable()).setPrefSize(((SplitFlap)this.getSkinnable()).getPrefWidth(), ((SplitFlap)this.getSkinnable()).getPrefHeight());
            } else {
                ((SplitFlap)this.getSkinnable()).setPrefSize(112.0, 189.0);
            }
        }
        if (Double.compare(((SplitFlap)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((SplitFlap)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((SplitFlap)this.getSkinnable()).setMinSize(5.0, 5.0);
        }
        if (Double.compare(((SplitFlap)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((SplitFlap)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((SplitFlap)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
        if (((SplitFlap)this.getSkinnable()).getPrefWidth() != 112.0 || ((SplitFlap)this.getSkinnable()).getPrefHeight() != 189.0) {
            aspectRatio = ((SplitFlap)this.getSkinnable()).getPrefHeight() / ((SplitFlap)this.getSkinnable()).getPrefWidth();
        }
        this.selectedSet.addAll(((SplitFlap)this.getSkinnable()).getSelectedSet());
    }

    private void initGraphics() {
        this.fixtureRight = new Region();
        this.fixtureRight.getStyleClass().setAll((Object[])new String[]{((SplitFlap)this.getSkinnable()).isDarkFixture() ? "fixture-dark" : "fixture"});
        this.fixtureRight.setOpacity(((SplitFlap)this.getSkinnable()).isWithFixture() ? 1.0 : 0.0);
        this.fixtureLeft = new Region();
        this.fixtureLeft.getStyleClass().setAll((Object[])new String[]{((SplitFlap)this.getSkinnable()).isDarkFixture() ? "fixture-dark" : "fixture"});
        this.fixtureLeft.setOpacity(((SplitFlap)this.getSkinnable()).isWithFixture() ? 1.0 : 0.0);
        this.innerShadow = new InnerShadow();
        this.innerShadow.setOffsetY(-0.01 * this.flapHeight);
        this.innerShadow.setRadius(0.01 * this.flapHeight);
        this.innerShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.65));
        this.innerShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.innerHighlight = new InnerShadow();
        this.innerHighlight.setOffsetY(0.01 * this.flapHeight);
        this.innerHighlight.setRadius(0.01 * this.flapHeight);
        this.innerHighlight.setColor(Color.rgb((int)255, (int)255, (int)255, (double)0.65));
        this.innerHighlight.setBlurType(BlurType.TWO_PASS_BOX);
        this.innerHighlight.setInput((Effect)this.innerShadow);
        this.reversedInnerShadow = new InnerShadow();
        this.reversedInnerShadow.setOffsetY(-0.004920634921 * this.height);
        this.reversedInnerShadow.setRadius(0.004920634921 * this.height);
        this.reversedInnerShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.65));
        this.reversedInnerShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.reversedInnerHighlight = new InnerShadow();
        this.reversedInnerHighlight.setOffsetY(0.004920634921 * this.height);
        this.reversedInnerHighlight.setRadius(0.004920634921 * this.height);
        this.reversedInnerHighlight.setColor(Color.rgb((int)255, (int)255, (int)255, (double)0.65));
        this.reversedInnerHighlight.setBlurType(BlurType.TWO_PASS_BOX);
        this.reversedInnerHighlight.setInput((Effect)this.innerShadow);
        ((SplitFlap)this.getSkinnable()).setStyle("-flap-base: " + Util.colorToCss(((SplitFlap)this.getSkinnable()).getFlapColor()) + ";");
        this.upperBackground = new Region();
        this.upperBackground.setEffect((Effect)this.innerHighlight);
        this.font = Fonts.bebasNeue(189.0);
        this.upperTextFill = new LinearGradient(0.0, 0.0, 0.0, this.flapHeight, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, ((SplitFlap)this.getSkinnable()).getTextColor()), new Stop(1.0, ((SplitFlap)this.getSkinnable()).getTextColor().darker())});
        this.upperBackgroundText = new Canvas();
        this.ctxUpperBackgroundText = this.upperBackgroundText.getGraphicsContext2D();
        this.ctxUpperBackgroundText.setTextBaseline(VPos.CENTER);
        this.ctxUpperBackgroundText.setTextAlign(TextAlignment.CENTER);
        this.lowerBackground = new Region();
        this.lowerBackground.setEffect((Effect)this.innerHighlight);
        this.lowerTextFill = new LinearGradient(0.0, 96.0, 0.0, 96.0 + this.flapHeight, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, ((SplitFlap)this.getSkinnable()).getTextColor().darker()), new Stop(1.0, ((SplitFlap)this.getSkinnable()).getTextColor())});
        this.lowerBackgroundText = new Canvas();
        this.ctxLowerBackgroundText = this.lowerBackgroundText.getGraphicsContext2D();
        this.ctxLowerBackgroundText.setTextBaseline(VPos.CENTER);
        this.ctxLowerBackgroundText.setTextAlign(TextAlignment.CENTER);
        this.flap = new Region();
        this.flap.setEffect((Effect)this.innerHighlight);
        this.flap.getTransforms().add((Object)this.rotateFlap);
        this.flapTextFront = new Canvas();
        this.flapTextFront.getTransforms().add((Object)this.rotateFlap);
        this.ctxTextFront = this.flapTextFront.getGraphicsContext2D();
        this.ctxTextFront.setTextBaseline(VPos.CENTER);
        this.ctxTextFront.setTextAlign(TextAlignment.CENTER);
        this.flapTextBack = new Canvas();
        this.flapTextBack.getTransforms().add((Object)this.rotateFlap);
        this.flapTextBack.setOpacity(0.0);
        this.ctxTextBack = this.flapTextBack.getGraphicsContext2D();
        this.ctxTextBack.setTextBaseline(VPos.CENTER);
        this.ctxTextBack.setTextAlign(TextAlignment.CENTER);
        if (((SplitFlap)this.getSkinnable()).isWithFixture()) {
            this.upperBackground.getStyleClass().setAll((Object[])new String[]{((SplitFlap)this.getSkinnable()).isSquareFlaps() ? "upper-square" : "upper"});
            this.lowerBackground.getStyleClass().setAll((Object[])new String[]{((SplitFlap)this.getSkinnable()).isSquareFlaps() ? "lower-square" : "lower"});
            this.flap.getStyleClass().setAll((Object[])new String[]{((SplitFlap)this.getSkinnable()).isSquareFlaps() ? "upper-square" : "upper"});
        } else {
            this.upperBackground.getStyleClass().setAll((Object[])new String[]{((SplitFlap)this.getSkinnable()).isSquareFlaps() ? "upper-no-fixture-square" : "upper-no-fixture"});
            this.lowerBackground.getStyleClass().setAll((Object[])new String[]{((SplitFlap)this.getSkinnable()).isSquareFlaps() ? "lower-no-fixture-square" : "lower-no-fixture"});
            this.flap.getStyleClass().setAll((Object[])new String[]{((SplitFlap)this.getSkinnable()).isSquareFlaps() ? "upper-no-fixture-square" : "upper-no-fixture"});
        }
        this.pane.getChildren().setAll((Object[])new Node[]{this.fixtureRight, this.fixtureLeft, this.upperBackground, this.lowerBackground, this.upperBackgroundText, this.lowerBackgroundText, this.flap, this.flapTextFront, this.flapTextBack});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
        this.resize();
    }

    private void registerListeners() {
        ((SplitFlap)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SplitFlap)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SplitFlap)this.getSkinnable()).prefWidthProperty().addListener(observable -> this.handleControlPropertyChanged("PREF_SIZE"));
        ((SplitFlap)this.getSkinnable()).prefHeightProperty().addListener(observable -> this.handleControlPropertyChanged("PREF_SIZE"));
        ((SplitFlap)this.getSkinnable()).textProperty().addListener(observable -> this.handleControlPropertyChanged("TEXT"));
        ((SplitFlap)this.getSkinnable()).flapColorProperty().addListener(observable -> this.handleControlPropertyChanged("FLAP_COLOR"));
        ((SplitFlap)this.getSkinnable()).textColorProperty().addListener(observable -> this.handleControlPropertyChanged("TEXT_COLOR"));
        ((SplitFlap)this.getSkinnable()).withFixtureProperty().addListener(observable -> this.handleControlPropertyChanged("WITH_FIXTURE"));
        ((SplitFlap)this.getSkinnable()).darkFixtureProperty().addListener(observable -> this.handleControlPropertyChanged("DARK_FIXTURE"));
        ((SplitFlap)this.getSkinnable()).squareFlapsProperty().addListener(observable -> this.handleControlPropertyChanged("SQUARE_FLAPS"));
        ((SplitFlap)this.getSkinnable()).getStyleClass().addListener((ListChangeListener)new ListChangeListener<String>(){

            public void onChanged(ListChangeListener.Change<? extends String> change) {
                SplitFlapSkin.this.resize();
            }
        });
        this.rotateFlap.angleProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldAngle, Number newAngle) {
                if (newAngle.doubleValue() > 90.0) {
                    SplitFlapSkin.this.flapTextFront.setOpacity(0.0);
                    SplitFlapSkin.this.flapTextBack.setOpacity(1.0);
                    SplitFlapSkin.this.flap.setEffect((Effect)SplitFlapSkin.this.reversedInnerHighlight);
                }
                if (newAngle.doubleValue() < 90.0) {
                    // empty if block
                }
            }
        });
        this.timeline.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent EVENT) {
                ((SplitFlap)SplitFlapSkin.this.getSkinnable()).fireEvent(SplitFlapSkin.this.FLIP_FINISHED);
                SplitFlapSkin.this.flap.setCache(false);
                SplitFlapSkin.this.flap.setCacheShape(false);
                if (Double.compare(SplitFlapSkin.this.rotateFlap.getAngle(), 180.0) == 0) {
                    SplitFlapSkin.this.flap.setEffect((Effect)SplitFlapSkin.this.innerHighlight);
                    SplitFlapSkin.this.rotateFlap.setAngle(0.0);
                    SplitFlapSkin.this.flapTextBack.setOpacity(0.0);
                    SplitFlapSkin.this.flapTextFront.setOpacity(1.0);
                    SplitFlapSkin.this.refreshTextCtx();
                    if (!((SplitFlap)SplitFlapSkin.this.getSkinnable()).getText().equals(SplitFlapSkin.this.selectedSet.get(SplitFlapSkin.this.currentSelectionIndex))) {
                        SplitFlapSkin.this.flipForward();
                    }
                } else if (Double.compare(SplitFlapSkin.this.rotateFlap.getAngle(), 0.0) == 0) {
                    SplitFlapSkin.this.rotateFlap.setAngle(180.0);
                }
            }
        });
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
        } else if ("PREF_SIZE".equals(PROPERTY)) {
            aspectRatio = ((SplitFlap)this.getSkinnable()).getPrefHeight() / ((SplitFlap)this.getSkinnable()).getPrefWidth();
        } else if ("TEXT".equals(PROPERTY)) {
            this.flipForward();
        } else if ("FLAP_COLOR".equals(PROPERTY)) {
            ((SplitFlap)this.getSkinnable()).setStyle("-flap-base: " + Util.colorToCss(((SplitFlap)this.getSkinnable()).getFlapColor()) + ";");
        } else if ("TEXT_COLOR".equals(PROPERTY)) {
            this.refreshTextCtx();
        } else if ("CHARACTER_SET".equals(PROPERTY)) {
            this.selectedSet.clear();
            for (String text : ((SplitFlap)this.getSkinnable()).getSelectedSet()) {
                this.selectedSet.add(text);
            }
        } else if ("WITH_FIXTURE".equals(PROPERTY)) {
            this.fixtureLeft.setOpacity(((SplitFlap)this.getSkinnable()).isWithFixture() ? 1.0 : 0.0);
            this.fixtureRight.setOpacity(((SplitFlap)this.getSkinnable()).isWithFixture() ? 1.0 : 0.0);
            if (!((SplitFlap)this.getSkinnable()).isWithFixture()) {
                this.upperBackground.getStyleClass().setAll((Object[])new String[]{"upper-no-fixture"});
                this.lowerBackground.getStyleClass().setAll((Object[])new String[]{"lower-no-fixture"});
                this.flap.getStyleClass().setAll((Object[])new String[]{"upper-no-fixture"});
            }
        } else if ("DARK_FIXTURE".equals(PROPERTY)) {
            this.fixtureLeft.getStyleClass().setAll((Object[])new String[]{((SplitFlap)this.getSkinnable()).isDarkFixture() ? "fixture-left-dark" : "fixture-left"});
            this.fixtureRight.getStyleClass().setAll((Object[])new String[]{((SplitFlap)this.getSkinnable()).isDarkFixture() ? "fixture-right-dark" : "fixture-right"});
        } else if ("SQUARE_FLAPS".equals(PROPERTY)) {
            if (((SplitFlap)this.getSkinnable()).isWithFixture()) {
                this.upperBackground.getStyleClass().setAll((Object[])new String[]{((SplitFlap)this.getSkinnable()).isSquareFlaps() ? "upper-square" : "upper"});
                this.lowerBackground.getStyleClass().setAll((Object[])new String[]{((SplitFlap)this.getSkinnable()).isSquareFlaps() ? "lower-square" : "lower"});
                this.flap.getStyleClass().setAll((Object[])new String[]{((SplitFlap)this.getSkinnable()).isSquareFlaps() ? "upper-square" : "upper"});
            } else {
                this.upperBackground.getStyleClass().setAll((Object[])new String[]{((SplitFlap)this.getSkinnable()).isSquareFlaps() ? "upper-no-fixture-square" : "upper-no-fixture"});
                this.lowerBackground.getStyleClass().setAll((Object[])new String[]{((SplitFlap)this.getSkinnable()).isSquareFlaps() ? "lower-no-fixture-square" : "lower-no-fixture"});
                this.flap.getStyleClass().setAll((Object[])new String[]{((SplitFlap)this.getSkinnable()).isSquareFlaps() ? "upper-no-fixture-square" : "upper-no-fixture"});
            }
        }
    }

    public void flipForward() {
        this.timeline.stop();
        this.flap.setCacheShape(true);
        this.flap.setCache(true);
        this.flap.setCacheHint(CacheHint.ROTATE);
        ++this.currentSelectionIndex;
        if (this.currentSelectionIndex >= this.selectedSet.size()) {
            this.currentSelectionIndex = 0;
        }
        this.nextSelectionIndex = this.currentSelectionIndex + 1;
        if (this.nextSelectionIndex >= this.selectedSet.size()) {
            this.nextSelectionIndex = 0;
        }
        this.keyValueFlap = new KeyValue((WritableValue)this.rotateFlap.angleProperty(), (Object)180, Interpolator.EASE_IN);
        this.keyFrame = new KeyFrame(Duration.millis((double)((SplitFlap)this.getSkinnable()).getFlipTime()), new KeyValue[]{this.keyValueFlap});
        this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{this.keyFrame});
        this.timeline.play();
    }

    public void flipBackward() {
        this.timeline.stop();
        this.keyValueFlap = new KeyValue((WritableValue)this.rotateFlap.angleProperty(), (Object)-180, Interpolator.EASE_IN);
        this.keyFrame = new KeyFrame(Duration.millis((double)((SplitFlap)this.getSkinnable()).getFlipTime()), new KeyValue[]{this.keyValueFlap});
        this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{this.keyFrame});
        this.timeline.play();
    }

    private void refreshTextCtx() {
        double flapWidth = this.flapTextFront.getWidth();
        double flapHeight = this.flapTextFront.getHeight();
        this.upperTextFill = new LinearGradient(0.0, 0.0, 0.0, flapHeight, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, ((SplitFlap)this.getSkinnable()).getTextColor().brighter().brighter()), new Stop(0.99, ((SplitFlap)this.getSkinnable()).getTextColor()), new Stop(1.0, ((SplitFlap)this.getSkinnable()).getTextColor().darker())});
        this.lowerTextFill = new LinearGradient(0.0, 0.0, 0.0, flapHeight, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, ((SplitFlap)this.getSkinnable()).getTextColor().brighter().brighter()), new Stop(0.01, ((SplitFlap)this.getSkinnable()).getTextColor().brighter()), new Stop(1.0, ((SplitFlap)this.getSkinnable()).getTextColor())});
        this.ctxUpperBackgroundText.clearRect(0.0, 0.0, flapWidth, flapHeight);
        this.ctxUpperBackgroundText.setFill((Paint)this.upperTextFill);
        this.ctxUpperBackgroundText.fillText(this.selectedSet.get(this.nextSelectionIndex), this.width * 0.5, this.height * 0.5);
        this.ctxLowerBackgroundText.clearRect(0.0, 0.0, flapWidth, flapHeight);
        this.ctxLowerBackgroundText.setFill((Paint)this.lowerTextFill);
        this.ctxLowerBackgroundText.fillText(this.selectedSet.get(this.currentSelectionIndex), this.width * 0.5, 0.0);
        this.ctxTextFront.clearRect(0.0, 0.0, flapWidth, flapHeight);
        this.ctxTextFront.setFill((Paint)this.upperTextFill);
        this.ctxTextFront.fillText(this.selectedSet.get(this.currentSelectionIndex), this.width * 0.5, this.height * 0.5);
        this.ctxTextBack.clearRect(0.0, 0.0, flapWidth, flapHeight);
        this.ctxTextBack.setFill((Paint)new LinearGradient(0.0, 0.0, 0.0, -flapHeight, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, ((SplitFlap)this.getSkinnable()).getTextColor().brighter().brighter()), new Stop(0.99, ((SplitFlap)this.getSkinnable()).getTextColor().brighter()), new Stop(1.0, ((SplitFlap)this.getSkinnable()).getTextColor())}));
        this.ctxTextBack.save();
        this.ctxTextBack.scale(1.0, -1.0);
        this.ctxTextBack.fillText(this.selectedSet.get(this.nextSelectionIndex), this.width * 0.5, -this.height * 0.5);
        this.ctxTextBack.restore();
    }

    private void resize() {
        this.width = ((SplitFlap)this.getSkinnable()).getWidth();
        this.height = ((SplitFlap)this.getSkinnable()).getHeight();
        if (((SplitFlap)this.getSkinnable()).isKeepAspect()) {
            if (aspectRatio * this.width > this.height) {
                this.width = 1.0 / (aspectRatio / this.height);
            } else if (1.0 / (aspectRatio / this.height) > this.width) {
                this.height = aspectRatio * this.width;
            }
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.flapHeight = 0.49206349206349204 * this.height;
            this.fixtureRight.setPrefSize(0.0476190476 * this.height, 0.164021164021164 * this.height);
            this.fixtureRight.setTranslateX(this.width - 0.0476190476 * this.height);
            this.fixtureRight.setTranslateY(0.41798941798941797 * this.height);
            this.fixtureRight.setCacheShape(true);
            this.fixtureLeft.setPrefSize(0.0476190476 * this.height, 0.164021164021164 * this.height);
            this.fixtureLeft.setTranslateY(0.41798941798941797 * this.height);
            this.fixtureLeft.setCacheShape(true);
            if (this.width > this.height && this.width > 0.0 && this.height > 0.0) {
                Path UPPER = new Path();
                UPPER.setFillRule(FillRule.EVEN_ODD);
                UPPER.getElements().add((Object)new MoveTo(this.width, 0.0));
                UPPER.getElements().add((Object)new LineTo(this.width, 0.4074074074074074 * this.height));
                UPPER.getElements().add((Object)new LineTo(this.width - 0.0582010582 * this.height, 0.4074074074074074 * this.height));
                UPPER.getElements().add((Object)new LineTo(this.width - 0.0582010582 * this.height, 0.49206349206349204 * this.height));
                UPPER.getElements().add((Object)new LineTo(0.0582010582 * this.height, 0.49206349206349204 * this.height));
                UPPER.getElements().add((Object)new LineTo(0.0582010582 * this.height, 0.4074074074074074 * this.height));
                UPPER.getElements().add((Object)new LineTo(0.0, 0.4074074074074074 * this.height));
                UPPER.getElements().add((Object)new LineTo(0.0, 0.0));
                UPPER.getElements().add((Object)new LineTo(this.width, 0.0));
                UPPER.getElements().add((Object)new ClosePath());
                String UPPER_SVG = ShapeConverter.shapeToSvgString((Shape)UPPER);
                Path LOWER = new Path();
                LOWER.setFillRule(FillRule.EVEN_ODD);
                LOWER.getElements().add((Object)new MoveTo(this.width, this.height));
                LOWER.getElements().add((Object)new LineTo(this.width, 0.5925925925925926 * this.height));
                LOWER.getElements().add((Object)new LineTo(this.width - 0.0582010582 * this.height, 0.5925925925925926 * this.height));
                LOWER.getElements().add((Object)new LineTo(this.width - 0.0582010582 * this.height, 0.5079365079365079 * this.height));
                LOWER.getElements().add((Object)new LineTo(0.0582010582 * this.height, 0.5079365079365079 * this.height));
                LOWER.getElements().add((Object)new LineTo(0.0582010582 * this.height, 0.5925925925925926 * this.height));
                LOWER.getElements().add((Object)new LineTo(0.0, 0.5925925925925926 * this.height));
                LOWER.getElements().add((Object)new LineTo(0.0, this.height));
                LOWER.getElements().add((Object)new LineTo(this.width, this.height));
                LOWER.getElements().add((Object)new ClosePath());
                String LOWER_SVG = ShapeConverter.shapeToSvgString((Shape)LOWER);
                this.upperBackground.setStyle("-fx-shape:" + "\"" + UPPER_SVG + "\";");
                this.lowerBackground.setStyle("-fx-shape:" + "\"" + LOWER_SVG + "\";");
                this.flap.setStyle("-fx-shape:" + "\"" + UPPER_SVG + "\";");
            }
            this.upperBackground.setPrefSize(this.width, this.flapHeight);
            this.upperBackground.setCacheShape(true);
            this.lowerBackground.setPrefSize(this.width, this.flapHeight);
            this.lowerBackground.setTranslateY(0.5079365079365079 * this.height);
            this.lowerBackground.setCacheShape(true);
            this.font = Fonts.bebasNeue(this.height * 0.9);
            this.upperBackgroundText.setWidth(this.width);
            this.upperBackgroundText.setHeight(this.flapHeight);
            this.lowerBackgroundText.setWidth(this.width);
            this.lowerBackgroundText.setHeight(this.flapHeight);
            this.lowerBackgroundText.setTranslateY(0.5079365079365079 * this.height);
            this.flap.setPrefSize(this.width, this.flapHeight);
            this.flap.setCacheShape(true);
            this.rotateFlap.setPivotY(this.height * 0.5);
            this.flapTextFront.setWidth(this.width);
            this.flapTextFront.setHeight(this.flapHeight);
            this.flapTextBack.setWidth(this.width);
            this.flapTextBack.setHeight(this.flapHeight);
            this.ctxUpperBackgroundText.setFont(this.font);
            this.ctxLowerBackgroundText.setFont(this.font);
            this.ctxTextFront.setFont(this.font);
            this.ctxTextBack.setFont(this.font);
            this.refreshTextCtx();
            this.innerShadow.setOffsetY(-0.01 * this.flapHeight);
            this.innerShadow.setRadius(0.01 * this.flapHeight);
            this.innerHighlight.setOffsetY(0.01 * this.flapHeight);
            this.innerHighlight.setRadius(0.01 * this.flapHeight);
            this.reversedInnerShadow.setOffsetY(-0.004920634921 * this.height);
            this.reversedInnerShadow.setRadius(0.004920634921 * this.height);
            this.reversedInnerHighlight.setOffsetY(0.004920634921 * this.height);
            this.reversedInnerHighlight.setRadius(0.004920634921 * this.height);
        }
    }
}

