/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.simpleindicator.skin;

import eu.hansolo.enzo.simpleindicator.SimpleIndicator;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;

public class SimpleIndicatorSkin
extends SkinBase<SimpleIndicator>
implements Skin<SimpleIndicator> {
    private static final double PREFERRED_SIZE = 48.0;
    private static final double MINIMUM_SIZE = 16.0;
    private static final double MAXIMUM_SIZE = 1024.0;
    private double size;
    private Pane pane;
    private Region outerFrame;
    private Region innerFrame;
    private Region mainBack;
    private Region main;
    private Region highlight;

    public SimpleIndicatorSkin(SimpleIndicator CONTROL) {
        super((Control)CONTROL);
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((SimpleIndicator)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((SimpleIndicator)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || ((SimpleIndicator)this.getSkinnable()).getWidth() <= 0.0 || ((SimpleIndicator)this.getSkinnable()).getHeight() <= 0.0) {
            ((SimpleIndicator)this.getSkinnable()).setPrefSize(48.0, 48.0);
        }
        if (Double.compare(((SimpleIndicator)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((SimpleIndicator)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((SimpleIndicator)this.getSkinnable()).setMinSize(16.0, 16.0);
        }
        if (Double.compare(((SimpleIndicator)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((SimpleIndicator)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((SimpleIndicator)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.outerFrame = new Region();
        this.outerFrame.getStyleClass().setAll((Object[])new String[]{"outer-frame"});
        this.innerFrame = new Region();
        this.innerFrame.getStyleClass().setAll((Object[])new String[]{"inner-frame"});
        this.mainBack = new Region();
        this.mainBack.getStyleClass().setAll((Object[])new String[]{"main-back"});
        this.main = new Region();
        this.main.getStyleClass().setAll((Object[])new String[]{"main"});
        this.highlight = new Region();
        this.highlight.getStyleClass().setAll((Object[])new String[]{"highlight"});
        this.pane = new Pane();
        this.pane.getChildren().setAll((Object[])new Node[]{this.outerFrame, this.innerFrame, this.mainBack, this.main, this.highlight});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((SimpleIndicator)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimpleIndicator)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimpleIndicator)this.getSkinnable()).indicatorStyleProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE"));
        ((SimpleIndicator)this.getSkinnable()).onProperty().addListener(observable -> this.handleControlPropertyChanged("ON"));
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
        } else if ("UPDATE".equals(PROPERTY)) {
            this.update();
        } else if ("ON".equals(PROPERTY)) {
            if (((SimpleIndicator)this.getSkinnable()).isOn()) {
                this.update();
            } else {
                ((SimpleIndicator)this.getSkinnable()).getStyleClass().setAll((Object[])new String[]{"indicator", "indicator-off"});
            }
        }
    }

    private void update() {
        ((SimpleIndicator)this.getSkinnable()).getStyleClass().setAll((Object[])new String[]{"indicator", ((SimpleIndicator)this.getSkinnable()).getIndicatorStyle().CLASS});
    }

    private void resize() {
        double d = this.size = ((SimpleIndicator)this.getSkinnable()).getWidth() < ((SimpleIndicator)this.getSkinnable()).getHeight() ? ((SimpleIndicator)this.getSkinnable()).getWidth() : ((SimpleIndicator)this.getSkinnable()).getHeight();
        if (this.size > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.outerFrame.setPrefSize(this.size, this.size);
            this.innerFrame.setPrefSize(this.size * 0.8, this.size * 0.8);
            this.innerFrame.setTranslateX((this.size - this.innerFrame.getPrefWidth()) * 0.5);
            this.innerFrame.setTranslateY((this.size - this.innerFrame.getPrefHeight()) * 0.5);
            this.mainBack.setPrefSize(this.size * 0.76, this.size * 0.76);
            this.mainBack.setTranslateX((this.size - this.mainBack.getPrefWidth()) * 0.5);
            this.mainBack.setTranslateY((this.size - this.mainBack.getPrefHeight()) * 0.5);
            this.main.setPrefSize(this.size * 0.76, this.size * 0.76);
            this.main.setTranslateX((this.size - this.main.getPrefWidth()) * 0.5);
            this.main.setTranslateY((this.size - this.main.getPrefHeight()) * 0.5);
            this.highlight.setPrefSize(this.size * 0.52, this.size * 0.3);
            this.highlight.setTranslateX((this.size - this.highlight.getPrefWidth()) * 0.5);
            this.highlight.setTranslateY((this.size - this.highlight.getPrefHeight()) * 0.2);
        }
    }
}

