/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.gauge;

import eu.hansolo.enzo.common.GradientLookup;
import eu.hansolo.enzo.fonts.Fonts;
import eu.hansolo.enzo.gauge.skin.FlatGaugeSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.WritableValue;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class FlatGauge
extends Control {
    private static final double PREFERRED_WIDTH = 300.0;
    private static final double PREFERRED_HEIGHT = 300.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final Color DEFAULT_BAR_COLOR = Color.web((String)"#00ffff");
    private static final Color DEFAULT_BACKGROUND_COLOR = Color.web((String)"#ffffff");
    private static final Color DEFAULT_TITLE_TEXT_COLOR = Color.web((String)"#333333");
    private static final Color DEFAULT_VALUE_TEXT_COLOR = Color.web((String)"#333333");
    private static final Color DEFAULT_UNIT_TEXT_COLOR = Color.web((String)"#333333");
    private static final Color DEFAULT_SEPARATOR_COLOR = Color.web((String)"#d0d0d0");
    private double size;
    private double width;
    private double height;
    private Circle colorRing;
    private Arc bar;
    private Line separator;
    private Circle background;
    private Text titleText;
    private Text valueText;
    private Text unitText;
    private Pane pane;
    private double range;
    private double angleStep;
    private int decimals;
    private int animationDurationInMs;
    private boolean multiColor;
    private DoubleProperty minValue;
    private DoubleProperty maxValue;
    private DoubleProperty value;
    private DoubleProperty currentValue;
    private StringProperty title;
    private StringProperty unit;
    private BooleanProperty separatorVisible;
    private BooleanProperty colorRingVisible;
    private ObjectProperty<Paint> barColor;
    private ObjectProperty<Paint> backgroundColor;
    private ObjectProperty<Paint> valueTextColor;
    private ObjectProperty<Paint> titleTextColor;
    private ObjectProperty<Paint> unitTextColor;
    private ObjectProperty<Paint> separatorColor;
    private Timeline barTimeline;
    private GradientLookup gradientLookup;

    public FlatGauge() {
        this.getStylesheets().add((Object)FlatGauge.class.getResource("flat-gauge.css").toExternalForm());
        this.getStyleClass().add((Object)"flat-gauge");
        this.range = 100.0;
        this.angleStep = 360.0 / this.range;
        this.decimals = 0;
        this.animationDurationInMs = 500;
        this.minValue = new DoublePropertyBase(0.0){

            public void set(double VALUE) {
                if (VALUE > FlatGauge.this.maxValue.get()) {
                    FlatGauge.this.maxValue.set(VALUE + 0.1);
                }
                double v = FlatGauge.this.clamp(-1.7976931348623157E308, FlatGauge.this.maxValue.get() - 0.1, VALUE);
                super.set(v);
            }

            public Object getBean() {
                return FlatGauge.this;
            }

            public String getName() {
                return "minValue";
            }
        };
        this.maxValue = new DoublePropertyBase(100.0){

            public void set(double VALUE) {
                if (VALUE < FlatGauge.this.minValue.get()) {
                    FlatGauge.this.minValue.set(VALUE - 0.1);
                }
                double v = FlatGauge.this.clamp(FlatGauge.this.minValue.get() + 0.1, Double.MAX_VALUE, VALUE);
                super.set(v);
            }

            public Object getBean() {
                return FlatGauge.this;
            }

            public String getName() {
                return "maxBarValue";
            }
        };
        this.value = new DoublePropertyBase(this.minValue.get()){

            public void set(double VALUE) {
                super.set(FlatGauge.this.clamp(FlatGauge.this.minValue.get(), FlatGauge.this.maxValue.get(), VALUE));
            }

            public Object getBean() {
                return FlatGauge.this;
            }

            public String getName() {
                return "value";
            }
        };
        this.currentValue = new SimpleDoubleProperty((Object)this, "currentValue", 0.0);
        this.title = new SimpleStringProperty((Object)this, "title", "");
        this.unit = new SimpleStringProperty((Object)this, "unit", "");
        this.separatorVisible = new SimpleBooleanProperty((Object)this, "separatorVisible", true);
        this.colorRingVisible = new SimpleBooleanProperty((Object)this, "colorRingVisible", true);
        this.barColor = new StyleableObjectProperty<Paint>((Paint)DEFAULT_BAR_COLOR){

            public CssMetaData getCssMetaData() {
                return StyleableProperties.BAR_COLOR;
            }

            public Object getBean() {
                return FlatGauge.this;
            }

            public String getName() {
                return "barColor";
            }
        };
        this.backgroundColor = new StyleableObjectProperty<Paint>((Paint)DEFAULT_BACKGROUND_COLOR){

            public CssMetaData getCssMetaData() {
                return StyleableProperties.BACKGROUND_COLOR;
            }

            public Object getBean() {
                return FlatGauge.this;
            }

            public String getName() {
                return "backgroundColor";
            }
        };
        this.titleTextColor = new StyleableObjectProperty<Paint>((Paint)DEFAULT_TITLE_TEXT_COLOR){

            public CssMetaData getCssMetaData() {
                return StyleableProperties.TITLE_TEXT_COLOR;
            }

            public Object getBean() {
                return FlatGauge.this;
            }

            public String getName() {
                return "titleTextColor";
            }
        };
        this.valueTextColor = new StyleableObjectProperty<Paint>((Paint)DEFAULT_VALUE_TEXT_COLOR){

            public CssMetaData getCssMetaData() {
                return StyleableProperties.VALUE_TEXT_COLOR;
            }

            public Object getBean() {
                return FlatGauge.this;
            }

            public String getName() {
                return "valueTextColor";
            }
        };
        this.unitTextColor = new StyleableObjectProperty<Paint>((Paint)DEFAULT_UNIT_TEXT_COLOR){

            public CssMetaData getCssMetaData() {
                return StyleableProperties.UNIT_TEXT_COLOR;
            }

            public Object getBean() {
                return FlatGauge.this;
            }

            public String getName() {
                return "unitTextColor";
            }
        };
        this.separatorColor = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SEPARATOR_COLOR){

            public CssMetaData getCssMetaData() {
                return StyleableProperties.SEPARATOR_COLOR;
            }

            public Object getBean() {
                return FlatGauge.this;
            }

            public String getName() {
                return "separatorColor";
            }
        };
        this.barTimeline = new Timeline();
        this.multiColor = false;
        this.gradientLookup = new GradientLookup(new Stop(0.0, Color.BLUE), new Stop(0.2, Color.CYAN), new Stop(0.4, Color.LIME), new Stop(0.6, Color.YELLOW), new Stop(0.8, Color.ORANGE), new Stop(1.0, Color.RED));
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(300.0, 300.0);
            }
        }
        if (Double.compare(this.getMinWidth(), 0.0) <= 0 || Double.compare(this.getMinHeight(), 0.0) <= 0) {
            this.setMinSize(50.0, 50.0);
        }
        if (Double.compare(this.getMaxWidth(), 0.0) <= 0 || Double.compare(this.getMaxHeight(), 0.0) <= 0) {
            this.setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.colorRing = new Circle(150.0, 150.0, 150.0);
        this.colorRing.setFill((Paint)Color.TRANSPARENT);
        this.colorRing.setStrokeWidth(2.25);
        this.colorRing.setStroke((Paint)DEFAULT_BAR_COLOR);
        this.colorRing.setVisible(this.colorRingVisible.get());
        this.bar = new Arc(150.0, 150.0, 140.4, 140.4, 90.0, 0.0);
        this.bar.setType(ArcType.OPEN);
        this.bar.setStroke((Paint)DEFAULT_BAR_COLOR);
        this.bar.setStrokeWidth(45.0);
        this.bar.setStrokeLineCap(StrokeLineCap.BUTT);
        this.bar.setFill(null);
        this.separator = new Line(150.0, 1.0, 150.0, 50.001000000000005);
        this.separator.setStroke((Paint)DEFAULT_SEPARATOR_COLOR);
        this.separator.setFill((Paint)Color.TRANSPARENT);
        this.separator.setVisible(this.separatorVisible.get());
        this.background = new Circle(150.0, 150.0, 108.89999999999999);
        this.background.setFill((Paint)DEFAULT_BACKGROUND_COLOR);
        this.titleText = new Text("");
        this.titleText.setFont(Fonts.robotoLight(24.0));
        this.titleText.setFill((Paint)DEFAULT_TITLE_TEXT_COLOR);
        this.valueText = new Text(String.format(Locale.US, "%." + this.decimals + "f", this.getValue()));
        this.valueText.setFont(Fonts.robotoRegular(81.99900000000001));
        this.valueText.setFill((Paint)DEFAULT_VALUE_TEXT_COLOR);
        this.unitText = new Text((String)this.unit.get());
        this.unitText.setFont(Fonts.robotoLight(24.0));
        this.unitText.setFill((Paint)DEFAULT_UNIT_TEXT_COLOR);
        this.pane = new Pane(new Node[]{this.colorRing, this.bar, this.separator, this.background, this.titleText, this.valueText, this.unitText});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.value.addListener(o -> this.handleControlPropertyChanged("VALUE"));
        this.currentValue.addListener(o -> this.handleControlPropertyChanged("CURRENT_VALUE"));
        this.title.addListener(o -> this.handleControlPropertyChanged("TITLE"));
        this.unit.addListener(o -> this.handleControlPropertyChanged("UNIT"));
        this.barColor.addListener(o -> this.handleControlPropertyChanged("BAR_COLOR"));
        this.backgroundColor.addListener(o -> this.handleControlPropertyChanged("BACKGROUND_COLOR"));
        this.valueTextColor.addListener(o -> this.handleControlPropertyChanged("VALUE_TEXT_COLOR"));
        this.unitTextColor.addListener(o -> this.handleControlPropertyChanged("UNIT_TEXT_COLOR"));
        this.titleTextColor.addListener(o -> this.handleControlPropertyChanged("TITLE_TEXT_COLOR"));
        this.separatorColor.addListener(o -> this.handleControlPropertyChanged("SEPARATOR_COLOR"));
        this.separatorVisible.addListener(o -> this.handleControlPropertyChanged("SEPARATOR_VISIBLE"));
        this.colorRingVisible.addListener(o -> this.handleControlPropertyChanged("COLOR_RING_VISIBLE"));
    }

    private void handleControlPropertyChanged(String PROPERTY) {
        if ("VALUE".equals(PROPERTY)) {
            this.barTimeline.stop();
            this.range = this.maxValue.get() - this.minValue.get();
            this.angleStep = 360.0 / this.range;
            this.currentValue.set(this.clamp(this.minValue.get(), this.maxValue.get(), this.currentValue.get()));
            KeyValue KV_START = new KeyValue((WritableValue)this.currentValue, (Object)this.currentValue.get(), Interpolator.EASE_BOTH);
            KeyValue KV_STOP = new KeyValue((WritableValue)this.currentValue, (Object)this.value.get(), Interpolator.EASE_BOTH);
            KeyFrame KF_START = new KeyFrame(Duration.ZERO, new KeyValue[]{KV_START});
            KeyFrame KF_STOP = new KeyFrame(Duration.millis((double)this.animationDurationInMs), new KeyValue[]{KV_STOP});
            this.barTimeline.getKeyFrames().setAll((Object[])new KeyFrame[]{KF_START, KF_STOP});
            this.barTimeline.play();
        } else if ("CURRENT_VALUE".equals(PROPERTY)) {
            this.setBar(this.currentValue.get());
        } else if ("TITLE".equals(PROPERTY)) {
            this.titleText.setText((String)this.title.get());
            this.resizeTitleText();
        } else if ("UNIT".equals(PROPERTY)) {
            this.unitText.setText((String)this.unit.get());
            this.resizeUnitText();
        } else if ("BAR_COLOR".equals(PROPERTY)) {
            this.bar.setStroke((Paint)this.barColor.get());
            this.colorRing.setStroke((Paint)this.barColor.get());
        } else if ("BACKGROUND_COLOR".equals(PROPERTY)) {
            this.background.setFill((Paint)this.backgroundColor.get());
        } else if ("VALUE_TEXT_COLOR".equals(PROPERTY)) {
            this.valueText.setFill((Paint)this.valueTextColor.get());
        } else if ("UNIT_TEXT_COLOR".equals(PROPERTY)) {
            this.unitText.setFill((Paint)this.unitTextColor.get());
        } else if ("TITLE_TEXT_COLOR".equals(PROPERTY)) {
            this.titleText.setFill((Paint)this.titleTextColor.get());
        } else if ("SEPARATOR_COLOR".equals(PROPERTY)) {
            this.separator.setStroke((Paint)this.separatorColor.get());
        } else if ("SEPARATOR_VISIBLE".equals(PROPERTY)) {
            this.separator.setVisible(this.separatorVisible.get());
        } else if ("COLOR_RING_VISIBLE".equals(PROPERTY)) {
            this.colorRing.setVisible(this.colorRingVisible.get());
        }
    }

    public double getMinValue() {
        return this.minValue.get();
    }

    public void setMinValue(double MIN_VALUE) {
        this.minValue.set(MIN_VALUE);
    }

    public DoubleProperty minValueProperty() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue.get();
    }

    public void setMaxValue(double MAX_VALUE) {
        this.maxValue.set(MAX_VALUE);
    }

    public DoubleProperty maxValueProperty() {
        return this.maxValue;
    }

    public double getValue() {
        return this.value.get();
    }

    public void setValue(double VALUE) {
        this.value.set(VALUE);
    }

    public DoubleProperty valueProperty() {
        return this.value;
    }

    public ReadOnlyDoubleProperty currentValueProperty() {
        return this.currentValue;
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public void setTitle(String TITLE) {
        this.title.set((Object)TITLE);
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public String getUnit() {
        return (String)this.unit.get();
    }

    public void setUnit(String UNIT) {
        this.unit.set((Object)UNIT);
    }

    public StringProperty unitProperty() {
        return this.unit;
    }

    public Paint getBarColor() {
        return (Paint)this.barColor.get();
    }

    public void setBarColor(Color BAR_COLOR) {
        if (this.multiColor) {
            return;
        }
        this.barColor.set((Object)BAR_COLOR);
    }

    public ObjectProperty<Paint> barColorProperty() {
        return this.barColor;
    }

    public Paint getBackgroundColor() {
        return (Paint)this.backgroundColor.get();
    }

    public void setBackgroundColor(Color BACKGROUND_COLOR) {
        this.backgroundColor.set((Object)BACKGROUND_COLOR);
    }

    public ObjectProperty<Paint> backgroundColorProperty() {
        return this.backgroundColor;
    }

    public Paint getValueTextColor() {
        return (Paint)this.valueTextColor.get();
    }

    public void setValueTextColor(Color VALUE_TEXT_COLOR) {
        this.valueTextColor.set((Object)VALUE_TEXT_COLOR);
    }

    public ObjectProperty<Paint> valueTextColorProperty() {
        return this.valueTextColor;
    }

    public Paint getTitleTextColor() {
        return (Paint)this.titleTextColor.get();
    }

    public void setTitleTextColor(Color TITLE_TEXT_COLOR) {
        this.titleTextColor.set((Object)TITLE_TEXT_COLOR);
    }

    public ObjectProperty<Paint> titleTextColorProperty() {
        return this.titleTextColor;
    }

    public Paint getUnitTextColor() {
        return (Paint)this.unitTextColor.get();
    }

    public void setUnitTextColor(Color UNIT_TEXT_COLOR) {
        this.unitTextColor.set((Object)UNIT_TEXT_COLOR);
    }

    public ObjectProperty<Paint> unitTextColorProperty() {
        return this.unitTextColor;
    }

    public Paint getSeparatorColor() {
        return (Paint)this.separatorColor.get();
    }

    public void setSeparatorColor(Color SEPARATOR_COLOR) {
        this.separatorColor.set((Object)SEPARATOR_COLOR);
    }

    public ObjectProperty<Paint> separatorColorProperty() {
        return this.separatorColor;
    }

    public boolean isSeparatorVisible() {
        return this.separatorVisible.get();
    }

    public void setSeparatorVisible(boolean SEPARATOR_VISIBLE) {
        this.separatorVisible.set(SEPARATOR_VISIBLE);
    }

    public BooleanProperty separatorVisibleProperty() {
        return this.separatorVisible;
    }

    public boolean isColorRingVisible() {
        return this.colorRingVisible.get();
    }

    public void setColorRingVisible(boolean COLOR_RING_VISIBLE) {
        this.colorRingVisible.set(COLOR_RING_VISIBLE);
    }

    public BooleanProperty colorRingVisibleProperty() {
        return this.colorRingVisible;
    }

    public void setGradient(Stop ... STOPS) {
        this.gradientLookup.setStops(STOPS);
    }

    public void setDecimals(int DECIMALS) {
        this.decimals = this.clamp(0, 3, DECIMALS);
        this.resizeValueText();
    }

    public int getAnimationDurationInMs() {
        return this.animationDurationInMs;
    }

    public void setAnimationDurationInMs(int ANIMATION_DURATION_IN_MS) {
        this.animationDurationInMs = this.clamp(1, 10000, ANIMATION_DURATION_IN_MS);
    }

    public boolean isMultiColor() {
        return this.multiColor;
    }

    public void setMultiColor(boolean MULTI_COLOR) {
        this.multiColor = MULTI_COLOR;
        if (this.multiColor) {
            return;
        }
        this.bar.setFill((Paint)this.barColor.get());
    }

    private void setBar(double VALUE) {
        if (this.multiColor) {
            this.bar.setFill((Paint)this.gradientLookup.getColorAt((VALUE - this.minValue.get()) / this.range));
        }
        if (this.minValue.get() > 0.0) {
            this.bar.setLength((VALUE - this.minValue.get()) * -1.0 * this.angleStep);
        } else if (VALUE < 0.0) {
            this.bar.setLength((-VALUE + this.minValue.get()) * this.angleStep);
        } else {
            this.bar.setLength((this.minValue.get() - VALUE) * this.angleStep);
        }
        this.valueText.setText(String.format(Locale.US, "%." + this.decimals + "f", VALUE));
        this.resizeValueText();
    }

    private String colorToCss(Color COLOR) {
        return COLOR.toString().replace("0x", "#");
    }

    private double clamp(double MIN_VALUE, double MAX_VALUE, double VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    private int clamp(int MIN_VALUE, int MAX_VALUE, int VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    protected Skin createDefaultSkin() {
        return new FlatGaugeSkin(this);
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("flat-gauge.css").toExternalForm();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return FlatGauge.getClassCssMetaData();
    }

    private void resizeTitleText() {
        this.titleText.setFont(Fonts.robotoLight(this.size * 0.08));
        double decrement = 0.0;
        while (this.titleText.getLayoutBounds().getWidth() > 0.56667 * this.size && this.titleText.getFont().getSize() > 0.0) {
            this.titleText.setFont(Fonts.robotoLight(this.size * (0.08 - decrement)));
            decrement += 0.01;
        }
        this.titleText.relocate((this.size - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.225);
    }

    private void resizeValueText() {
        this.valueText.setFont(Fonts.robotoRegular(this.size * 0.3));
        double decrement = 0.0;
        while (this.valueText.getLayoutBounds().getWidth() > 0.5 * this.size && this.valueText.getFont().getSize() > 0.0) {
            this.valueText.setFont(Fonts.robotoRegular(this.size * (0.3 - decrement)));
            decrement += 0.01;
        }
        this.valueText.relocate((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5, (this.size - this.valueText.getLayoutBounds().getHeight()) * 0.5);
    }

    private void resizeUnitText() {
        this.unitText.setFont(Fonts.robotoLight(this.size * 0.08));
        double decrement = 0.0;
        while (this.unitText.getLayoutBounds().getWidth() > 0.56667 * this.size && this.unitText.getFont().getSize() > 0.0) {
            this.unitText.setFont(Fonts.robotoLight(this.size * (0.08 - decrement)));
            decrement += 0.01;
        }
        this.unitText.relocate((this.size - this.unitText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.66);
    }

    private void resize() {
        this.width = this.getWidth();
        this.height = this.getHeight();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((this.width - this.size) * 0.5, (this.height - this.size) * 0.5);
            this.colorRing.setCenterX(this.size * 0.5);
            this.colorRing.setCenterY(this.size * 0.5);
            this.colorRing.setRadius(this.size * 0.5);
            this.colorRing.setStrokeWidth(this.size * 0.0075);
            this.bar.setCenterX(this.size * 0.5);
            this.bar.setCenterY(this.size * 0.5);
            this.bar.setRadiusX(this.size * 0.421);
            this.bar.setRadiusY(this.size * 0.421);
            this.bar.setStrokeWidth(this.size * 0.12);
            this.separator.setStartX(this.size * 0.5);
            this.separator.setStartY(this.size * 0.02);
            this.separator.setEndX(this.size * 0.5);
            this.separator.setEndY(this.size * 0.138);
            this.background.setCenterX(this.size * 0.5);
            this.background.setCenterY(this.size * 0.5);
            this.background.setRadius(this.size * 0.363);
            this.resizeTitleText();
            this.resizeValueText();
            this.resizeUnitText();
        }
    }

    static /* synthetic */ Color access$900() {
        return DEFAULT_BAR_COLOR;
    }

    static /* synthetic */ Color access$1100() {
        return DEFAULT_BACKGROUND_COLOR;
    }

    static /* synthetic */ Color access$1300() {
        return DEFAULT_TITLE_TEXT_COLOR;
    }

    static /* synthetic */ Color access$1500() {
        return DEFAULT_VALUE_TEXT_COLOR;
    }

    static /* synthetic */ Color access$1700() {
        return DEFAULT_UNIT_TEXT_COLOR;
    }

    static /* synthetic */ Color access$1900() {
        return DEFAULT_SEPARATOR_COLOR;
    }

    private static class StyleableProperties {
        private static final CssMetaData<FlatGauge, Paint> BAR_COLOR = new CssMetaData<FlatGauge, Paint>("-bar-color", StyleConverter.getPaintConverter(), (Paint)FlatGauge.access$900()){

            public boolean isSettable(FlatGauge node) {
                return null == node.barColor || !node.barColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(FlatGauge node) {
                return (StyleableProperty)node.barColorProperty();
            }

            public Paint getInitialValue(FlatGauge node) {
                return node.getBarColor();
            }
        };
        private static final CssMetaData<FlatGauge, Paint> BACKGROUND_COLOR = new CssMetaData<FlatGauge, Paint>("-background-color", StyleConverter.getPaintConverter(), (Paint)FlatGauge.access$1100()){

            public boolean isSettable(FlatGauge node) {
                return null == node.backgroundColor || !node.backgroundColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(FlatGauge node) {
                return (StyleableProperty)node.backgroundColorProperty();
            }

            public Paint getInitialValue(FlatGauge node) {
                return node.getBackgroundColor();
            }
        };
        private static final CssMetaData<FlatGauge, Paint> TITLE_TEXT_COLOR = new CssMetaData<FlatGauge, Paint>("-title-text-color", StyleConverter.getPaintConverter(), (Paint)FlatGauge.access$1300()){

            public boolean isSettable(FlatGauge node) {
                return null == node.titleTextColor || !node.titleTextColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(FlatGauge node) {
                return (StyleableProperty)node.titleTextColorProperty();
            }

            public Paint getInitialValue(FlatGauge node) {
                return node.getTitleTextColor();
            }
        };
        private static final CssMetaData<FlatGauge, Paint> VALUE_TEXT_COLOR = new CssMetaData<FlatGauge, Paint>("-value-text-color", StyleConverter.getPaintConverter(), (Paint)FlatGauge.access$1500()){

            public boolean isSettable(FlatGauge node) {
                return null == node.valueTextColor || !node.valueTextColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(FlatGauge node) {
                return (StyleableProperty)node.valueTextColorProperty();
            }

            public Paint getInitialValue(FlatGauge node) {
                return node.getValueTextColor();
            }
        };
        private static final CssMetaData<FlatGauge, Paint> UNIT_TEXT_COLOR = new CssMetaData<FlatGauge, Paint>("-unit-text-color", StyleConverter.getPaintConverter(), (Paint)FlatGauge.access$1700()){

            public boolean isSettable(FlatGauge node) {
                return null == node.unitTextColor || !node.unitTextColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(FlatGauge node) {
                return (StyleableProperty)node.unitTextColorProperty();
            }

            public Paint getInitialValue(FlatGauge node) {
                return node.getUnitTextColor();
            }
        };
        private static final CssMetaData<FlatGauge, Paint> SEPARATOR_COLOR = new CssMetaData<FlatGauge, Paint>("-separator-color", StyleConverter.getPaintConverter(), (Paint)FlatGauge.access$1900()){

            public boolean isSettable(FlatGauge node) {
                return null == node.separatorColor || !node.separatorColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(FlatGauge node) {
                return (StyleableProperty)node.separatorColorProperty();
            }

            public Paint getInitialValue(FlatGauge node) {
                return node.getSeparatorColor();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, BAR_COLOR, BACKGROUND_COLOR, TITLE_TEXT_COLOR, VALUE_TEXT_COLOR, UNIT_TEXT_COLOR, SEPARATOR_COLOR);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

