/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.gauge;

import eu.hansolo.enzo.common.Section;
import eu.hansolo.enzo.gauge.SimpleGauge;
import eu.hansolo.enzo.gauge.SimpleGaugeBuilder;
import java.util.Random;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.FlowPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class DemoMulti
extends Application {
    private Random rnd;
    private long lastTimerCall;
    private AnimationTimer timer;
    private SimpleGauge[] gauges;
    private static int noOfNodes;

    public void init() {
        this.rnd = new Random();
        this.lastTimerCall = 0L;
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > DemoMulti.this.lastTimerCall + 100000000L) {
                    for (SimpleGauge gauge : DemoMulti.this.gauges) {
                        gauge.setValue(DemoMulti.this.rnd.nextDouble() * 100.0);
                    }
                    DemoMulti.this.lastTimerCall = now;
                }
            }
        };
        this.gauges = new SimpleGauge[100];
        for (int i = 0; i < 100; ++i) {
            SimpleGauge gauge;
            this.gauges[i] = gauge = ((SimpleGaugeBuilder)SimpleGaugeBuilder.create().prefSize(50.0, 50.0)).animationDuration(80.0).animated(false).sections(new Section(0.0, 100.0)).styleClass("blue-to-red-6").build();
        }
    }

    public void start(Stage stage) {
        FlowPane pane = new FlowPane();
        pane.getChildren().addAll((Object[])this.gauges);
        Scene scene = new Scene((Parent)pane, 500.0, 500.0, (Paint)Color.WHITE);
        stage.setTitle("Gauge");
        stage.setScene(scene);
        stage.show();
        DemoMulti.calcNoOfNodes((Node)scene.getRoot());
        System.out.println("No. of nodes in scene: " + noOfNodes);
        this.timer.start();
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                DemoMulti.calcNoOfNodes(n);
            }
        }
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

