/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.flippanel;

import eu.hansolo.enzo.flippanel.FlipEvent;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.event.EventTarget;
import javafx.geometry.Orientation;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.util.Duration;

public class FlipPanel
extends StackPane {
    private StackPane front;
    private StackPane back;
    private Rotate rotate = new Rotate(0.0, Rotate.Y_AXIS);
    private Rotate backRotate;
    private Timeline flipToFront;
    private Timeline flipToBack;
    private double flipTime;
    private Orientation flipDirection;

    public FlipPanel() {
        this(Orientation.HORIZONTAL);
    }

    public FlipPanel(Orientation FLIP_DIRECTION) {
        this.getTransforms().add((Object)this.rotate);
        this.backRotate = new Rotate(180.0, Orientation.HORIZONTAL == FLIP_DIRECTION ? Rotate.Y_AXIS : Rotate.X_AXIS);
        this.front = new StackPane();
        this.back = new StackPane();
        this.back.setVisible(false);
        this.getChildren().setAll((Object[])new Node[]{this.back, this.front});
        this.flipToFront = new Timeline();
        this.flipToBack = new Timeline();
        this.flipTime = 700.0;
        this.flipDirection = FLIP_DIRECTION;
        this.registerListeners();
    }

    private void registerListeners() {
        this.front.widthProperty().addListener(observable -> this.adjustRotationAxis());
        this.front.heightProperty().addListener(observable -> this.adjustRotationAxis());
        this.back.widthProperty().addListener(observable -> this.adjustRotationAxis());
        this.back.heightProperty().addListener(observable -> this.adjustRotationAxis());
        this.rotate.angleProperty().addListener((ov, o, n) -> {
            if (Double.compare(o.doubleValue(), 90.0) < 0 && Double.compare(n.doubleValue(), 90.0) >= 0) {
                this.front.setVisible(false);
                this.back.setVisible(true);
            }
            if (Double.compare(o.doubleValue(), 90.0) > 0 && Double.compare(n.doubleValue(), 90.0) <= 0) {
                this.back.setVisible(false);
                this.front.setVisible(true);
            }
        });
    }

    public StackPane getFront() {
        return this.front;
    }

    public StackPane getBack() {
        return this.back;
    }

    public void flipToFront() {
        if (Double.compare(this.rotate.getAngle(), 0.0) == 0) {
            return;
        }
        KeyValue kvStart = new KeyValue((WritableValue)this.rotate.angleProperty(), (Object)180, Interpolator.EASE_IN);
        KeyValue kvStop = new KeyValue((WritableValue)this.rotate.angleProperty(), (Object)0, Interpolator.EASE_OUT);
        KeyFrame kfStart = new KeyFrame(Duration.ZERO, new KeyValue[]{kvStart});
        KeyFrame kfStop = new KeyFrame(Duration.millis((double)this.flipTime), new KeyValue[]{kvStop});
        this.flipToFront.getKeyFrames().setAll((Object[])new KeyFrame[]{kfStart, kfStop});
        this.front.setCache(true);
        this.front.setCacheHint(CacheHint.ROTATE);
        this.back.setCache(true);
        this.back.setCacheHint(CacheHint.ROTATE);
        this.flipToFront.setOnFinished(event -> {
            this.front.setCache(false);
            this.back.setCache(false);
            this.fireEvent(new FlipEvent((Object)this, (EventTarget)this, FlipEvent.FLIP_TO_FRONT_FINISHED));
        });
        this.flipToFront.play();
    }

    public void flipToBack() {
        if (Double.compare(this.rotate.getAngle(), 180.0) == 0) {
            return;
        }
        KeyValue kvStart = new KeyValue((WritableValue)this.rotate.angleProperty(), (Object)0, Interpolator.EASE_IN);
        KeyValue kvStop = new KeyValue((WritableValue)this.rotate.angleProperty(), (Object)180, Interpolator.EASE_OUT);
        KeyFrame kfStart = new KeyFrame(Duration.ZERO, new KeyValue[]{kvStart});
        KeyFrame kfStop = new KeyFrame(Duration.millis((double)this.flipTime), new KeyValue[]{kvStop});
        this.flipToBack.getKeyFrames().setAll((Object[])new KeyFrame[]{kfStart, kfStop});
        this.front.setCache(true);
        this.front.setCacheHint(CacheHint.ROTATE);
        this.back.setCache(true);
        this.back.setCacheHint(CacheHint.ROTATE);
        this.flipToBack.setOnFinished(event -> {
            this.front.setCache(false);
            this.back.setCache(false);
            this.fireEvent(new FlipEvent((Object)this, (EventTarget)this, FlipEvent.FLIP_TO_BACK_FINISHED));
        });
        this.flipToBack.play();
    }

    public boolean isFrontVisible() {
        return this.front.isVisible();
    }

    public boolean isBackVisible() {
        return this.back.isVisible();
    }

    public void setFlipTime(double FLIP_TIME) {
        this.flipTime = this.clamp(100.0, 2000.0, FLIP_TIME);
    }

    private void adjustRotationAxis() {
        if (this.front.getWidth() < 0.0 || this.back.getWidth() < 0.0 || this.front.getHeight() < 0.0 || this.back.getHeight() < 0.0) {
            return;
        }
        double width = this.front.getWidth() > this.back.getWidth() ? this.front.getWidth() : this.back.getWidth();
        double height = this.front.getHeight() > this.back.getHeight() ? this.front.getHeight() : this.back.getHeight();
        this.setPrefSize(width, height);
        if (Orientation.HORIZONTAL == this.flipDirection) {
            this.backRotate.setAngle(0.0);
            this.backRotate.setAxis(Rotate.Y_AXIS);
            this.backRotate.setPivotX(0.5 * width);
            this.backRotate.setAngle(180.0);
            this.back.getTransforms().setAll((Object[])new Transform[]{this.backRotate});
            this.rotate.setAxis(Rotate.Y_AXIS);
            this.rotate.setPivotX(0.5 * width);
        } else {
            this.backRotate.setAngle(0.0);
            this.backRotate.setAxis(Rotate.X_AXIS);
            this.backRotate.setPivotY(0.5 * height);
            this.backRotate.setAngle(180.0);
            this.back.getTransforms().setAll((Object[])new Transform[]{this.backRotate});
            this.rotate.setAxis(Rotate.X_AXIS);
            this.rotate.setPivotY(0.5 * height);
        }
    }

    public Orientation getFlipDirection() {
        return this.flipDirection;
    }

    public void setFlipDirection(Orientation FLIP_DIRECTION) {
        if (FLIP_DIRECTION == this.flipDirection) {
            return;
        }
        this.flipDirection = FLIP_DIRECTION;
        this.backRotate = new Rotate(180.0, Orientation.HORIZONTAL == FLIP_DIRECTION ? Rotate.Y_AXIS : Rotate.X_AXIS);
        this.adjustRotationAxis();
    }

    private double clamp(double MIN, double MAX, double VALUE) {
        if (VALUE < MIN) {
            return MIN;
        }
        if (VALUE > MAX) {
            return MAX;
        }
        return VALUE;
    }
}

