/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.common;

import eu.hansolo.enzo.common.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javafx.animation.Interpolator;
import javafx.geometry.Point2D;
import javafx.scene.image.Image;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Shape;

public class ConicalGradient {
    private static final double ANGLE_FACTOR = 0.002777777777777778;
    private Point2D center;
    private List<Stop> sortedStops;

    public ConicalGradient(Stop ... STOPS) {
        this(null, Arrays.asList(STOPS));
    }

    public ConicalGradient(List<Stop> STOPS) {
        this(null, STOPS);
    }

    public ConicalGradient(Point2D CENTER, Stop ... STOPS) {
        this(CENTER, 0.0, Arrays.asList(STOPS));
    }

    public ConicalGradient(Point2D CENTER, List<Stop> STOPS) {
        this(CENTER, 0.0, STOPS);
    }

    public ConicalGradient(Point2D CENTER, double OFFSET, Stop ... STOPS) {
        this(CENTER, OFFSET, Arrays.asList(STOPS));
    }

    public ConicalGradient(Point2D CENTER, double OFFSET, List<Stop> STOPS) {
        List<Object> stops;
        double offset = Util.clamp(0.0, 1.0, OFFSET);
        this.center = CENTER;
        if (null == STOPS || STOPS.isEmpty()) {
            stops = new ArrayList();
            stops.add(new Stop(0.0, Color.TRANSPARENT));
            stops.add(new Stop(1.0, Color.TRANSPARENT));
        } else {
            stops = STOPS;
        }
        LinkedHashMap<Double, Object> stopMap = new LinkedHashMap<Double, Object>(stops.size());
        for (Stop stop : stops) {
            stopMap.put(stop.getOffset(), stop.getColor());
        }
        this.sortedStops = new LinkedList<Stop>();
        TreeSet sortedFractions = new TreeSet(((HashMap)stopMap).keySet());
        if ((Double)sortedFractions.last() < 1.0) {
            stopMap.put(1.0, ((HashMap)stopMap).get(sortedFractions.first()));
            sortedFractions.add(1.0);
        }
        if ((Double)sortedFractions.first() > 0.0) {
            stopMap.put(0.0, ((HashMap)stopMap).get(sortedFractions.last()));
            sortedFractions.add(0.0);
        }
        for (Double FRACTION : sortedFractions) {
            this.sortedStops.add(new Stop(FRACTION.doubleValue(), (Color)((HashMap)stopMap).get(FRACTION)));
        }
        if (offset > 0.0) {
            this.recalculate(offset);
        }
    }

    public void recalculateWithAngle(double ANGLE) {
        double angle = ANGLE % 360.0;
        this.recalculate(0.002777777777777778 * angle);
    }

    public void recalculate(double OFFSET) {
        ArrayList<Stop> stops = new ArrayList<Stop>(this.sortedStops.size());
        for (Stop stop : this.sortedStops) {
            double newOffset = (stop.getOffset() + OFFSET) % 1.0;
            if (Double.compare(newOffset, 0.0) == 0) {
                newOffset = 1.0;
                stops.add(new Stop(1.0E-6, stop.getColor()));
            } else if (stop.getOffset() + OFFSET > 1.0) {
                newOffset -= 1.0E-6;
            }
            stops.add(new Stop(newOffset, stop.getColor()));
        }
        LinkedHashMap<Double, Object> stopMap = new LinkedHashMap<Double, Object>(stops.size());
        for (Stop stop : stops) {
            stopMap.put(stop.getOffset(), stop.getColor());
        }
        LinkedList<Stop> linkedList = new LinkedList<Stop>();
        TreeSet sortedFractions = new TreeSet(((HashMap)stopMap).keySet());
        if ((Double)sortedFractions.last() < 1.0) {
            stopMap.put(1.0, ((HashMap)stopMap).get(sortedFractions.first()));
            sortedFractions.add(1.0);
        }
        if ((Double)sortedFractions.first() > 0.0) {
            stopMap.put(0.0, ((HashMap)stopMap).get(sortedFractions.last()));
            sortedFractions.add(0.0);
        }
        for (Double fraction : sortedFractions) {
            linkedList.add(new Stop(fraction.doubleValue(), (Color)((HashMap)stopMap).get(fraction)));
        }
        this.sortedStops.clear();
        this.sortedStops.addAll(linkedList);
    }

    public List<Stop> getStops() {
        return this.sortedStops;
    }

    public Point2D getCenter() {
        return this.center;
    }

    public Image getImage(double WIDTH, double HEIGHT) {
        int width = (int)WIDTH <= 0 ? 100 : (int)WIDTH;
        int height = (int)HEIGHT <= 0 ? 100 : (int)HEIGHT;
        Color color = Color.TRANSPARENT;
        WritableImage RASTER = new WritableImage(width, height);
        PixelWriter PIXEL_WRITER = RASTER.getPixelWriter();
        if (null == this.center) {
            this.center = new Point2D((double)(width / 2), (double)(height / 2));
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                double dy;
                double dx = (double)x - this.center.getX();
                double distance = Math.sqrt(dx * dx + (dy = (double)y - this.center.getY()) * dy);
                distance = Double.compare(distance, 0.0) == 0 ? 1.0 : distance;
                double angle = Math.abs(Math.toDegrees(Math.acos(dx / distance)));
                if (dx >= 0.0 && dy <= 0.0) {
                    angle = 90.0 - angle;
                } else if (dx >= 0.0 && dy >= 0.0) {
                    angle += 90.0;
                } else if (dx <= 0.0 && dy >= 0.0) {
                    angle += 90.0;
                } else if (dx <= 0.0 && dy <= 0.0) {
                    angle = 450.0 - angle;
                }
                for (int i = 0; i < this.sortedStops.size() - 1; ++i) {
                    if (!(angle >= this.sortedStops.get(i).getOffset() * 360.0) || !(angle < this.sortedStops.get(i + 1).getOffset() * 360.0)) continue;
                    double fraction = (angle - this.sortedStops.get(i).getOffset() * 360.0) / ((this.sortedStops.get(i + 1).getOffset() - this.sortedStops.get(i).getOffset()) * 360.0);
                    color = (Color)Interpolator.LINEAR.interpolate((Object)this.sortedStops.get(i).getColor(), (Object)this.sortedStops.get(i + 1).getColor(), fraction);
                }
                PIXEL_WRITER.setColor(x, y, color);
            }
        }
        return RASTER;
    }

    public ImagePattern apply(Shape SHAPE) {
        double x = SHAPE.getLayoutBounds().getMinX();
        double y = SHAPE.getLayoutBounds().getMinY();
        double width = SHAPE.getLayoutBounds().getWidth();
        double height = SHAPE.getLayoutBounds().getHeight();
        this.center = new Point2D(width * 0.5, height * 0.5);
        return new ImagePattern(this.getImage(width, height), x, y, width, height, false);
    }
}

