/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.common;

import java.util.Random;
import java.util.stream.IntStream;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.shape.Shape;

public class BrushedMetalPaint {
    private int radius;
    private double amount;
    private int color;
    private double shine;
    private boolean monochrome;
    private Random randomNumbers;

    public BrushedMetalPaint() {
        this(Color.rgb((int)136, (int)136, (int)136), 5, 0.1, true, 0.3);
    }

    public BrushedMetalPaint(Color COLOR) {
        this(COLOR, 5, 0.1, true, 0.3);
    }

    public BrushedMetalPaint(Color COLOR, int RADIUS, double AMOUNT, boolean MONOCHROME, double SHINE) {
        this.color = this.getIntFromColor(COLOR);
        this.radius = RADIUS;
        this.amount = AMOUNT;
        this.monochrome = MONOCHROME;
        this.shine = SHINE;
    }

    public Image getImage(double W, double H) {
        int WIDTH = (int)W;
        int HEIGHT = (int)H;
        WritableImage DESTINATION = new WritableImage(WIDTH, HEIGHT);
        int[] IN_PIXELS = new int[WIDTH];
        int[] OUT_PIXELS = new int[WIDTH];
        this.randomNumbers = new Random(0L);
        int ALPHA = this.color & 0xFF000000;
        int RED = this.color >> 16 & 0xFF;
        int GREEN = this.color >> 8 & 0xFF;
        int BLUE = this.color & 0xFF;
        IntStream.range(0, HEIGHT).parallel().forEachOrdered(y -> {
            IntStream.range(0, WIDTH).parallel().forEachOrdered(x -> {
                int tr = RED;
                int tg = GREEN;
                int tb = BLUE;
                if (this.shine != 0.0) {
                    int f = (int)(255.0 * this.shine * Math.sin((double)x / (double)WIDTH * Math.PI));
                    tr += f;
                    tg += f;
                    tb += f;
                }
                if (this.monochrome) {
                    int n = (int)((double)(255.0f * (2.0f * this.randomNumbers.nextFloat() - 1.0f)) * this.amount);
                    IN_PIXELS[x] = ALPHA | this.clamp(tr + n) << 16 | this.clamp(tg + n) << 8 | this.clamp(tb + n);
                } else {
                    IN_PIXELS[x] = ALPHA | this.random(tr) << 16 | this.random(tg) << 8 | this.random(tb);
                }
            });
            if (this.radius != 0) {
                this.blur(IN_PIXELS, OUT_PIXELS, WIDTH, this.radius);
                this.setRGB(DESTINATION, 0, y, OUT_PIXELS);
            } else {
                this.setRGB(DESTINATION, 0, y, IN_PIXELS);
            }
        });
        return DESTINATION;
    }

    public ImageView getImageView(double W, double H, Shape CLIP) {
        Image IMAGE = this.getImage(W, H);
        ImageView IMAGE_VIEW = new ImageView(IMAGE);
        IMAGE_VIEW.setClip((Node)CLIP);
        return IMAGE_VIEW;
    }

    public ImagePattern apply(Shape SHAPE) {
        double x = SHAPE.getLayoutBounds().getMinX();
        double y = SHAPE.getLayoutBounds().getMinY();
        double width = SHAPE.getLayoutBounds().getWidth();
        double height = SHAPE.getLayoutBounds().getHeight();
        return new ImagePattern(this.getImage(width, height), x, y, width, height, false);
    }

    public void blur(int[] IN, int[] OUT, int WIDTH, int RADIUS) {
        int WIDTH_MINUS_1 = WIDTH - 1;
        int R2 = 2 * RADIUS + 1;
        int tr = 0;
        int tg = 0;
        int tb = 0;
        for (int i = -RADIUS; i <= RADIUS; ++i) {
            int rgb = IN[this.mod(i, WIDTH)];
            tr += rgb >> 16 & 0xFF;
            tg += rgb >> 8 & 0xFF;
            tb += rgb & 0xFF;
        }
        for (int x = 0; x < WIDTH; ++x) {
            int i2;
            OUT[x] = 0xFF000000 | tr / R2 << 16 | tg / R2 << 8 | tb / R2;
            int i1 = x + RADIUS + 1;
            if (i1 > WIDTH_MINUS_1) {
                i1 = this.mod(i1, WIDTH);
            }
            if ((i2 = x - RADIUS) < 0) {
                i2 = this.mod(i2, WIDTH);
            }
            int rgb1 = IN[i1];
            int rgb2 = IN[i2];
            tr += (rgb1 & 0xFF0000) - (rgb2 & 0xFF0000) >> 16;
            tg += (rgb1 & 0xFF00) - (rgb2 & 0xFF00) >> 8;
            tb += (rgb1 & 0xFF) - (rgb2 & 0xFF);
        }
    }

    public void setRadius(int RADIUS) {
        this.radius = RADIUS;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setAmount(double AMOUNT) {
        this.amount = AMOUNT;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setColor(int COLOR) {
        this.color = COLOR;
    }

    public int getColor() {
        return this.color;
    }

    public void setMonochrome(boolean MONOCHROME) {
        this.monochrome = MONOCHROME;
    }

    public boolean isMonochrome() {
        return this.monochrome;
    }

    public void setShine(double SHINE) {
        this.shine = SHINE;
    }

    public double getShine() {
        return this.shine;
    }

    private int random(int x) {
        if ((x += (int)((double)(255.0f * (2.0f * this.randomNumbers.nextFloat() - 1.0f)) * this.amount)) < 0) {
            x = 0;
        } else if (x > 255) {
            x = 255;
        }
        return x;
    }

    private int clamp(int C) {
        int ret = C;
        if (C < 0) {
            ret = 0;
        }
        if (C > 255) {
            ret = 255;
        }
        return ret;
    }

    private int mod(int a, int B) {
        int N;
        if ((a -= (N = a / B) * B) < 0) {
            return a + B;
        }
        return a;
    }

    private void setRGB(WritableImage IMAGE, int X, int Y, int[] PIXELS) {
        PixelWriter RASTER = IMAGE.getPixelWriter();
        for (int x = 0; x < PIXELS.length; ++x) {
            RASTER.setColor(X + x, Y, Color.rgb((int)(PIXELS[x] >> 16 & 0xFF), (int)(PIXELS[x] >> 8 & 0xFF), (int)(PIXELS[x] & 0xFF)));
        }
    }

    private int getIntFromColor(Color COLOR) {
        String hex = COLOR.toString();
        StringBuilder intValue = new StringBuilder(10);
        intValue.append(hex.substring(8, 10));
        intValue.append(hex.substring(2, 8));
        return (int)Long.parseLong(intValue.toString(), 16);
    }
}

